/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.util.Iterator;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class Batch
extends IDMapperResource {
    private DataSource sourceDs;
    private DataSource targetDs;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            System.out.println("Batch Xrefs.doInit start");
            String dsName = this.urlDecode((String)this.getRequest().getAttributes().get("system"));
            this.sourceDs = this.parseDataSource(dsName);
            String targetDsName = (String)this.getRequest().getAttributes().get("dataSource");
            this.targetDs = this.parseDataSource(targetDsName);
            if (targetDsName != null) {
                this.targetDs = this.parseDataSource(this.urlDecode(targetDsName));
            }
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Post
    public String accept(Representation entity) {
        String result = null;
        result = this.sourceDs != null ? this.oneDataSource(entity) : this.multiDataSource(entity);
        return result;
    }

    public String multiDataSource(Representation entity) {
        System.out.println("Batch Multi Xrefs.getXrefs() start");
        try {
            String[] splitXrefs = entity.getText().split("\n");
            IDMapperStack mapper = this.getIDMappers();
            StringBuilder result = new StringBuilder();
            for (String line : splitXrefs) {
                String[] lineSplit = line.split("\t");
                String id = lineSplit[0].trim();
                DataSource ds = this.parseDataSource(lineSplit[1]);
                Xref source = new Xref(lineSplit[0].trim(), ds);
                Set xrefs = this.targetDs == null ? mapper.mapID(source, new DataSource[0]) : mapper.mapID(source, new DataSource[]{this.targetDs});
                if (xrefs.isEmpty()) {
                    result.append(id.trim());
                    result.append("\t");
                    result.append(ds.getFullName());
                    result.append("\t");
                    result.append("N/A");
                    result.append("\n");
                    continue;
                }
                result.append(id.trim());
                result.append("\t");
                result.append(ds.getFullName());
                result.append("\t");
                Iterator iter = xrefs.iterator();
                result.append(iter.next());
                while (iter.hasNext()) {
                    result.append("," + iter.next());
                }
                result.append("\n");
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }

    public String oneDataSource(Representation entity) {
        System.out.println("Batch Xrefs.getXrefs() start");
        try {
            String[] splitXrefs = entity.getText().split("\n");
            IDMapperStack mapper = this.getIDMappers();
            StringBuilder result = new StringBuilder();
            for (String id : splitXrefs) {
                Xref xref = new Xref(id.trim(), this.sourceDs);
                Set xrefs = this.targetDs == null ? mapper.mapID(xref, new DataSource[0]) : mapper.mapID(xref, new DataSource[]{this.targetDs});
                if (xrefs.isEmpty()) {
                    result.append(id.trim());
                    result.append("\t");
                    result.append(this.sourceDs.getFullName());
                    result.append("\t");
                    result.append("N/A");
                    result.append("\n");
                    continue;
                }
                result.append(id.trim());
                result.append("\t");
                result.append(this.sourceDs.getFullName());
                result.append("\t");
                Iterator iter = xrefs.iterator();
                result.append(iter.next());
                while (iter.hasNext()) {
                    result.append("," + iter.next());
                }
                result.append("\n");
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }

    @Override
    protected DataSource parseDataSource(String dsName) {
        if (dsName == null) {
            return null;
        }
        DataSource ds = null;
        ds = DataSource.getFullNames().contains(dsName) ? DataSource.getExistingByFullName((String)dsName) : DataSource.getExistingBySystemCode((String)dsName);
        return ds;
    }
}

