/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperStack;
import org.bridgedb.bio.Organism;
import org.bridgedb.rdb.GdbProvider;
import org.bridgedb.server.IDMapperService;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class IDMapperResource
extends ServerResource {
    private IDMapperStack mappers;
    private String orgName;

    protected DataSource parseDataSource(String dsName) {
        if (dsName == null) {
            return null;
        }
        DataSource ds = null;
        ds = DataSource.getFullNames().contains(dsName) ? DataSource.getExistingByFullName((String)dsName) : DataSource.getExistingBySystemCode((String)dsName);
        return ds;
    }

    protected void doInit() throws ResourceException {
        try {
            this.orgName = this.urlDecode((String)this.getRequest().getAttributes().get("organism"));
            String requestedID = this.urlDecode((String)this.getRequest().getAttributes().get("id"));
            if (requestedID != null && requestedID.startsWith("HMDB") && requestedID.length() == 11) {
                String newId = requestedID.replace("0000", "00");
                Map<String, String> newIdAttributes = new HashMap();
                newIdAttributes = this.getRequest().getAttributes();
                newIdAttributes.put("id", newId);
                this.getRequest().setAttributes(newIdAttributes);
            }
            this.initIDMappers();
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    protected String urlDecode(String string) throws UnsupportedEncodingException {
        return string == null ? null : URLDecoder.decode(string, "UTF-8");
    }

    private void initIDMappers() {
        Organism org = Organism.fromLatinName((String)this.orgName);
        if (org == null) {
            org = Organism.fromCode((String)this.orgName);
        }
        if (org == null) {
            org = Organism.fromShortName((String)this.orgName);
        }
        if (org == null) {
            throw new IllegalArgumentException("Unknown organism: " + this.orgName + "<p><font size='+1'><i>Double check the spelling. We are expecting an entry like: Human</i></font></p>");
        }
        this.mappers = this.getGdbProvider().getStack(org);
        if (this.mappers.getSize() == 0) {
            throw new IllegalArgumentException("No database found for: " + this.orgName + "<p><font size='+1'><i>Verify that the database is supported and properly referenced in gdb.config.</i></font></p>");
        }
    }

    protected IDMapperStack getIDMappers() {
        return this.mappers;
    }

    private GdbProvider getGdbProvider() {
        return ((IDMapperService)this.getApplication()).getGdbProvider();
    }
}

