/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import org.bridgedb.DataSource;
import org.bridgedb.IDMapperStack;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class IsMappingSupported
extends IDMapperResource {
    DataSource srcDs;
    DataSource destDs;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            String dsName = this.urlDecode((String)this.getRequest().getAttributes().get("src"));
            this.srcDs = this.parseDataSource(dsName);
            if (this.srcDs == null) {
                throw new IllegalArgumentException("Unknown datasource: " + dsName);
            }
            dsName = this.urlDecode((String)this.getRequest().getAttributes().get("dest"));
            this.destDs = this.parseDataSource(dsName);
            if (this.destDs == null) {
                throw new IllegalArgumentException("Unknown datasource: " + dsName);
            }
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Get
    public String isMappingSupported() {
        try {
            IDMapperStack m = this.getIDMappers();
            boolean supported = m.getCapabilities().isMappingSupported(this.srcDs, this.destDs);
            return "" + supported;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }
}

