/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.bridgedb.server.IDMapperService;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;

public class Server {
    private Component component;

    public void run(int port, File configFile) {
        this.run(port, configFile, false);
    }

    public void run(int port, File configFile, boolean transitive) {
        this.component = new Component();
        this.component.getServers().add(Protocol.HTTP, port);
        this.component.getDefaultHost().attach((Restlet)new IDMapperService(configFile, transitive));
        try {
            System.out.println("Starting server on port " + port);
            this.component.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.component.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        Class.forName("org.bridgedb.rdb.IDMapperRdb");
        int port = 8183;
        boolean transitive = false;
        File configFile = null;
        Options options = new Options();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Port to use (default: 8183)");
        options.addOption(OptionBuilder.create((String)"p"));
        options.addOption("t", false, "Enable transitive mode (default: false)");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override configuration file (default: gdb.config)");
        options.addOption(OptionBuilder.create((String)"f"));
        options.addOption("h", false, "Print help and quit");
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.getArgs().length > 0) {
                throw new ParseException("Unknown options: " + line.getArgList());
            }
            if (line.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("startserver.sh", options);
                System.exit(0);
            }
            if (line.hasOption("p")) {
                port = Integer.parseInt(line.getOptionValue("p"));
            }
            if (line.hasOption("f")) {
                configFile = new File(line.getOptionValue("f"));
            }
            if (line.hasOption("t")) {
                transitive = true;
            }
        }
        catch (Exception e) {
            System.err.println("Did not understand command line options. Reason: " + e.getClass().getName() + " " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("startserver.sh", options);
            System.exit(-1);
        }
        Server server = new Server();
        server.run(port, configFile, transitive);
    }
}

