/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class Xrefs
extends IDMapperResource {
    Xref xref;
    DataSource targetDs;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            System.out.println("Xrefs.doInit start");
            String id = this.urlDecode((String)this.getRequest().getAttributes().get("id"));
            String dsName = this.urlDecode((String)this.getRequest().getAttributes().get("system"));
            DataSource dataSource = this.parseDataSource(dsName);
            if (dataSource == null) {
                throw new IllegalArgumentException("Unknown datasource: " + dsName);
            }
            this.xref = new Xref(id, dataSource);
            String targetDsName = (String)this.getRequest().getAttributes().get("dataSource");
            if (targetDsName != null) {
                this.targetDs = this.parseDataSource(this.urlDecode(targetDsName));
            }
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Get
    public String getXrefs() {
        System.out.println("Xrefs.getXrefs() start");
        try {
            IDMapperStack mapper = this.getIDMappers();
            Set xrefs = this.targetDs == null ? mapper.mapID(this.xref, new DataSource[0]) : mapper.mapID(this.xref, new DataSource[]{this.targetDs});
            StringBuilder result = new StringBuilder();
            for (Xref x : xrefs) {
                result.append(x.getId());
                result.append("\t");
                result.append(x.getDataSource().getFullName());
                result.append("\n");
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }
}

