/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.tools.qc;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.bio.Organism;
import org.bridgedb.rdb.SimpleGdb;
import org.bridgedb.rdb.SimpleGdbFactory;
import org.bridgedb.tools.qc.PatternChecker;

public class BridgeQC {
    private final File oldDb;
    private final File newDb;
    private SimpleGdb oldGdb;
    private SimpleGdb newGdb;
    private PrintStream out;
    Map<DataSource, Integer> oldSet = new HashMap<DataSource, Integer>();
    Map<DataSource, Integer> newSet = new HashMap<DataSource, Integer>();

    public BridgeQC(File f1, File f2) throws IDMapperException {
        this(f1, f2, System.out);
    }

    public BridgeQC(File f1, File f2, OutputStream out) throws IDMapperException {
        if (out == null) {
            throw new NullPointerException("OutputStream is null");
        }
        this.oldDb = f1;
        this.newDb = f2;
        this.out = new PrintStream(out);
    }

    public void initDatabases() throws IDMapperException {
        String url1 = "jdbc:derby:jar:(" + this.oldDb + ")database";
        this.oldGdb = SimpleGdbFactory.createInstance((String)"old", (String)url1);
        this.out.printf("INFO: old database is %s %s (build: %s)\n", this.oldGdb.getCapabilities().getProperty("DATASOURCENAME"), this.oldGdb.getCapabilities().getProperty("DATASOURCEVERSION"), this.oldGdb.getCapabilities().getProperty("BUILDDATE"));
        String url2 = "jdbc:derby:jar:(" + this.newDb + ")database";
        this.newGdb = SimpleGdbFactory.createInstance((String)"new", (String)url2);
        this.out.printf("INFO: new database is %s %s (build: %s)\n", this.newGdb.getCapabilities().getProperty("DATASOURCENAME"), this.newGdb.getCapabilities().getProperty("DATASOURCEVERSION"), this.newGdb.getCapabilities().getProperty("BUILDDATE"));
    }

    public void compareDataSources() throws IDMapperException {
        int newGenes;
        for (DataSource ds : this.oldGdb.getCapabilities().getSupportedSrcDataSources()) {
            int oldGenes = this.oldGdb.getGeneCount(ds);
            this.oldSet.put(ds, oldGenes);
        }
        for (DataSource ds : this.newGdb.getCapabilities().getSupportedSrcDataSources()) {
            newGenes = this.newGdb.getGeneCount(ds);
            this.newSet.put(ds, newGenes);
        }
        for (DataSource ds : this.oldSet.keySet()) {
            if (this.newSet.containsKey(ds)) continue;
            this.out.printf("INFO: %s%s is only in old database\n", ds.getSystemCode(), ds.getFullName() != null && ds.getFullName().length() > 0 ? " (" + ds.getFullName() + ")" : "");
        }
        for (DataSource ds : this.newSet.keySet()) {
            Object oldXref2;
            newGenes = this.newSet.get(ds);
            if (newGenes == 0) {
                this.out.println("WARNING: " + ds.getSystemCode() + " has 0 ids");
            }
            if (!this.oldSet.containsKey(ds)) {
                this.out.printf("INFO: %s%s is only in new database\n", ds.getSystemCode(), ds.getFullName() != null && ds.getFullName().length() > 0 ? " (" + ds.getFullName() + ")" : "");
                this.out.printf("INFO: Number of ids in %s%s: %d\n", ds.getSystemCode(), ds.getFullName() != null && ds.getFullName().length() > 0 ? " (" + ds.getFullName() + ")" : "", newGenes);
                continue;
            }
            HashSet<String> oldIDs = new HashSet<String>();
            for (Object oldXref2 : this.oldGdb.getIterator(ds)) {
                oldIDs.add(oldXref2.getId());
            }
            HashSet<String> newIDs = new HashSet<String>();
            oldXref2 = this.newGdb.getIterator(ds).iterator();
            while (oldXref2.hasNext()) {
                Xref newXref = (Xref)oldXref2.next();
                newIDs.add(newXref.getId());
            }
            HashSet<String> newGenesAdded = new HashSet<String>();
            newGenesAdded.addAll(newIDs);
            newGenesAdded.removeAll(oldIDs);
            HashSet<String> genesRemoved = new HashSet<String>();
            genesRemoved.addAll(oldIDs);
            genesRemoved.removeAll(newIDs);
            int oldGenes = this.oldSet.get(ds);
            double delta = (double)(newGenes - oldGenes) / (double)oldGenes;
            if (newGenesAdded.size() + genesRemoved.size() == 0) {
                this.out.printf("INFO: Number of ids in %s%s: %d (unchanged)\n", ds.getSystemCode(), ds.getFullName() != null && ds.getFullName().length() > 0 ? " (" + ds.getFullName() + ")" : "", newGenes);
            } else {
                this.out.printf("INFO: Number of ids in %s%s: %d (%d added, %d removed -> overall changed %+3.1f%%)\n", ds.getSystemCode(), ds.getFullName() != null && ds.getFullName().length() > 0 ? " (" + ds.getFullName() + ")" : "", newGenes, newGenesAdded.size(), genesRemoved.size(), delta * 100.0);
            }
            if (genesRemoved.size() > 0 && "true".equals(System.getProperty("showRemovedIDs", "false"))) {
                this.out.printf("INFO: The ids removed from %s%s: %s\n", ds.getSystemCode(), ds.getFullName() != null && ds.getFullName().length() > 0 ? " (" + ds.getFullName() + ")" : "", "" + genesRemoved);
            }
            if (!(delta < -0.1)) continue;
            this.out.println("WARNING: Number of ids in " + ds.getSystemCode() + " has shrunk by more than 10%");
        }
    }

    public void compareLinks() throws SQLException {
        Connection con = this.oldGdb.getConnection();
    }

    public void checkDatabaseSanity() throws SQLException {
        String sql;
        Connection con = this.newGdb.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(sql = "select coderight, idright from link left outer join datanode on link.idright = datanode.id and link.coderight = datanode.code where datanode.code IS NULL");
        if (rs.next()) {
            this.out.println("ERROR: 'link' table contains ids that do not occur in 'datanode' table.");
            this.out.print("ERROR: A few examples: ");
            String sep = "";
            int i = 0;
            do {
                this.out.print(sep + rs.getString(1) + ":" + rs.getString(2));
                sep = ", ";
            } while (rs.next() && ++i < 8);
            this.out.println();
            this.out.println("ERROR: These ids will not map properly.");
        }
    }

    public void compareFileSizes() throws SQLException {
        long oldSize = this.oldDb.length();
        long newSize = this.newDb.length();
        this.out.printf("INFO: new size is %d Mb (changed %+3.1f%%)\n", newSize / 1000000L, (double)(newSize - oldSize) / (double)oldSize * 100.0);
    }

    public void compareAttributes() throws IDMapperException {
        Set oldAttrSet = this.oldGdb.getAttributeSet();
        Set newAttrSet = this.newGdb.getAttributeSet();
        for (String oldAttr : oldAttrSet) {
            if (newAttrSet.contains(oldAttr)) continue;
            this.out.println("WARNING: Attribute " + oldAttr + " only in old database");
        }
        for (String newAttr : newAttrSet) {
            this.out.println("INFO: Attribute provided: " + newAttr);
            if (oldAttrSet.contains(newAttr)) continue;
            this.out.println("INFO: Attribute " + newAttr + " only in new database");
        }
    }

    public static boolean safeEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public void compareInfo() {
        for (Props p : Props.values()) {
            p.checkWrap(this.oldGdb.getCapabilities().getProperty(p.name()), this.newGdb.getCapabilities().getProperty(p.name()), System.out);
        }
    }

    public void run() throws IDMapperException, SQLException {
        this.initDatabases();
        this.checkDatabaseSanity();
        this.compareInfo();
        this.compareDataSources();
        this.compareLinks();
        this.compareAttributes();
        this.compareFileSizes();
        this.summarizeOverallStats(this.oldGdb, "OLD");
        this.summarizeOverallStats(this.newGdb, "NEW");
    }

    private void summarizeOverallStats(SimpleGdb gdb, String oldNew) throws IDMapperException, SQLException {
        boolean isSchemaUpdated;
        this.out.println("INFO: " + oldNew + " database has a total number of identifiers of " + gdb.getGeneCount());
        this.out.println("INFO: " + oldNew + " database has a total number of mappings of " + gdb.getLinkCount());
        Connection con = gdb.getConnection();
        con.setAutoCommit(false);
        Statement st = con.createStatement();
        String sqlSchema = "SELECT schemaversion FROM info ";
        ResultSet schema = st.executeQuery(sqlSchema);
        boolean bl = isSchemaUpdated = schema.next() && schema.getInt("schemaversion") >= 4;
        if (isSchemaUpdated) {
            for (DataSource ds : gdb.getCapabilities().getSupportedSrcDataSources()) {
                this.out.println("INFO: " + oldNew + " database data source " + ds.getFullName() + " has " + gdb.getPrimaryIDCount(ds) + " primary ids");
                this.out.println("INFO: " + oldNew + " database data source " + ds.getFullName() + " has " + (gdb.getGeneCount(ds) - gdb.getPrimaryIDCount(ds)) + " secondary ids");
            }
        } else {
            this.out.println("INFO: " + oldNew + " database has Schema Version is less than 4, and we cannot calculate Primary and Secondary identifier counts");
        }
    }

    public static void printUsage() {
        System.out.println("Expected 2 arguments: <old database> <new database>");
    }

    public static void main(String[] args) throws IDMapperException, SQLException {
        if (args.length != 2) {
            BridgeQC.printUsage();
            return;
        }
        BridgeQC main = new BridgeQC(new File(args[0]), new File(args[1]));
        DataSourceTxt.init();
        main.run();
        PatternChecker checker = new PatternChecker();
        checker.run(new File(args[0]));
    }

    static enum Props implements PropertyChecker
    {
        ORGANISM(true, false){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
                Organism o;
                if (newVal != null && (o = Organism.fromLatinName((String)newVal)) == null) {
                    out.println("WARNING: species '" + newVal + "' is not a recognized latin name");
                }
            }
        }
        ,
        DATASOURCENAME(true, true){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
            }
        }
        ,
        SERIES(true, true){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
            }
        }
        ,
        DATATYPE(true, true){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
            }
        }
        ,
        DATASOURCEVERSION(false, true){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
            }
        }
        ,
        BUILDDATE(false, true){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
                SimpleDateFormat sft = new SimpleDateFormat("yyyyMMdd");
                Date oldDate = null;
                Date newDate = null;
                try {
                    if (oldVal != null) {
                        oldDate = sft.parse(oldVal);
                    }
                }
                catch (ParseException e) {
                    out.println("ERROR: " + oldVal + " does not match pattern yyyymmdd");
                }
                try {
                    if (newVal != null) {
                        newDate = sft.parse(newVal);
                    }
                }
                catch (ParseException e) {
                    out.println("ERROR: " + oldVal + " does not match pattern yyyymmdd");
                }
                if (oldDate != null && newDate != null && oldDate.after(newDate)) {
                    out.println("ERROR: new date " + newVal + " is older than old date " + oldVal);
                }
            }
        }
        ,
        SCHEMAVERSION(false, true){

            @Override
            public void check(String oldVal, String newVal, PrintStream out) {
            }
        };

        private boolean mustBeSame;
        private boolean mustBeDefined;
        PrintStream out;

        private Props(boolean mustBeSame, boolean mustBeDefined) {
            this.mustBeSame = mustBeSame;
            this.mustBeDefined = mustBeDefined;
        }

        public void checkWrap(String oldVal, String newVal, PrintStream out) {
            if (this.mustBeSame && !BridgeQC.safeEquals(oldVal, newVal)) {
                out.println("WARNING: old " + this.name() + " '" + oldVal + "' doesn't match new " + this.name() + " '" + newVal + "'");
            }
            if (this.mustBeDefined && (newVal == null || newVal.equals(""))) {
                out.println("WARNING: property " + this.name() + " is undefined");
            }
            this.check(oldVal, newVal, out);
        }
    }

    public static interface PropertyChecker {
        public void check(String var1, String var2, PrintStream var3);
    }
}

