/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.argparser.TaggedArgument;
import org.broadinstitute.barclay.argparser.TaggedArgumentParser;
import org.broadinstitute.barclay.utils.Utils;

public class NamedArgumentDefinition
extends ArgumentDefinition {
    private static final Logger logger = LogManager.getLogger();
    private final Argument argumentAnnotation;
    private final CommandLinePluginDescriptor<?> descriptorForControllingPlugin;
    private final boolean isOptional;
    private final Set<String> mutuallyExclusiveArgs;
    private final String defaultValueAsString;
    private boolean hasBeenSet = false;
    public static final String NULL_ARGUMENT_STRING = "null";
    public static Comparator<NamedArgumentDefinition> sortByLongName = (argDef1, argDef2) -> String.CASE_INSENSITIVE_ORDER.compare(argDef1.getLongName(), argDef2.getLongName());

    public NamedArgumentDefinition(Argument argumentAnnotation, Object containingObject, Field underlyingField, CommandLinePluginDescriptor<?> descriptorForControllingPlugin) {
        super(containingObject, underlyingField);
        Utils.nonNull(argumentAnnotation);
        Utils.nonNull(containingObject);
        Utils.nonNull(underlyingField);
        this.argumentAnnotation = argumentAnnotation;
        this.descriptorForControllingPlugin = descriptorForControllingPlugin;
        this.mutuallyExclusiveArgs = new LinkedHashSet<String>(Arrays.asList(argumentAnnotation.mutex()));
        this.defaultValueAsString = this.convertDefaultValueToString();
        boolean bl = this.isOptional = argumentAnnotation.optional() || !this.defaultValueAsString.equals(NULL_ARGUMENT_STRING);
        if (!this.isOptional) {
            if (this.isHidden()) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("A required argument cannot be annotated with @Hidden: %s", this.getLongName()));
            }
            if (this.isAdvanced()) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("A required argument cannot be annotated with @Advanced: %s", this.getLongName()));
            }
        }
        if (this.isCollection()) {
            this.intializeCollection("@Argument");
        } else if (argumentAnnotation.suppressFileExpansion()) {
            throw new CommandLineException.CommandLineParserInternalException("suppressFileExpansion can only be used for collection arguments");
        }
        this.validateBoundsDefinitions();
    }

    public String getShortName() {
        return this.argumentAnnotation.shortName();
    }

    public String getFullName() {
        return this.argumentAnnotation.fullName();
    }

    public String getLongName() {
        return !this.getFullName().isEmpty() ? this.getFullName() : this.getUnderlyingField().getName();
    }

    public String getDocString() {
        return this.argumentAnnotation.doc();
    }

    public boolean isCommon() {
        return this.argumentAnnotation.common();
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isHidden() {
        return this.getUnderlyingField().getAnnotation(Hidden.class) != null;
    }

    public boolean isAdvanced() {
        return this.getUnderlyingField().getAnnotation(Advanced.class) != null;
    }

    public boolean isDeprecated() {
        return this.getUnderlyingField().isAnnotationPresent(Deprecated.class);
    }

    public boolean isFlag() {
        return this.getUnderlyingFieldClass().equals(Boolean.TYPE) || this.getUnderlyingFieldClass().equals(Boolean.class);
    }

    public int getMinElements() {
        return this.argumentAnnotation.minElements();
    }

    public int getMaxElements() {
        return this.argumentAnnotation.maxElements();
    }

    public boolean hasBoundedRange() {
        return this.getMinValue() != Double.NEGATIVE_INFINITY || this.getMaxValue() != Double.POSITIVE_INFINITY;
    }

    public boolean hasRecommendedRange() {
        return this.getMaxRecommendedValue() != Double.POSITIVE_INFINITY || this.getMinRecommendedValue() != Double.NEGATIVE_INFINITY;
    }

    public Double getMinValue() {
        return this.argumentAnnotation.minValue();
    }

    public Double getMaxValue() {
        return this.argumentAnnotation.maxValue();
    }

    public Double getMinRecommendedValue() {
        return this.argumentAnnotation.minRecommendedValue();
    }

    public Double getMaxRecommendedValue() {
        return this.argumentAnnotation.maxRecommendedValue();
    }

    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    public Set<String> getMutexTargetList() {
        return this.mutuallyExclusiveArgs;
    }

    public void addMutexTarget(String target) {
        this.mutuallyExclusiveArgs.add(target);
    }

    public CommandLinePluginDescriptor<?> getDescriptorForControllingPlugin() {
        return this.descriptorForControllingPlugin;
    }

    public boolean getHasBeenSet() {
        return this.hasBeenSet;
    }

    @Override
    public String getCommandLineDisplayString() {
        Object value = this.getArgumentValue();
        if (this.isCollection()) {
            List<String> collect = this.getOriginalCommandLineValues() == null ? (List<String>)value : this.getOriginalCommandLineValues();
            return collect.stream().map(this::getNameValuePairForDisplay).collect(Collectors.joining(" "));
        }
        return this.getNameValuePairForDisplay(value);
    }

    public List<String> getArgumentAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        if (!this.getShortName().isEmpty()) {
            aliases.add(this.getShortName());
        }
        if (!this.getFullName().isEmpty()) {
            aliases.add(this.getFullName());
        } else {
            aliases.add(this.getUnderlyingField().getName());
        }
        return aliases;
    }

    public String getArgumentAliasDisplayString() {
        return this.getArgumentAliases().stream().collect(Collectors.joining("/"));
    }

    public boolean isControlledByPlugin() {
        return this.descriptorForControllingPlugin != null;
    }

    @Override
    public void setArgumentValues(CommandLineArgumentParser commandLineArgumentParser, PrintStream messageStream, List<String> preprocessedValues) {
        if (this.isCollection()) {
            this.setCollectionValues(commandLineArgumentParser, messageStream, preprocessedValues);
        } else {
            this.setScalarValue(commandLineArgumentParser, messageStream, preprocessedValues);
        }
        this.hasBeenSet = true;
    }

    private void setCollectionValues(CommandLineArgumentParser commandLineArgumentParser, PrintStream messageStream, List<String> preprocessedValues) {
        Collection c = (Collection)this.getArgumentValue();
        if (!commandLineArgumentParser.getAppendToCollectionsParserOption()) {
            c.clear();
        }
        for (int i = 0; i < preprocessedValues.size(); ++i) {
            String stringValue = preprocessedValues.get(i);
            if (stringValue.equals(NULL_ARGUMENT_STRING)) {
                if (i != 0) {
                    logger.warn(String.format("A \"null\" value was detected for an option after values for that option were already set. Clobbering previously set values for this option: %s.", this.getArgumentAliasDisplayString()));
                }
                if (!this.isOptional()) {
                    throw new CommandLineException(String.format("Non \"null\" value must be provided for '%s'", this.getArgumentAliasDisplayString()));
                }
                c.clear();
                continue;
            }
            Pair<String, String> normalizedSurrogatePair = this.getNormalizedTagValuePair(commandLineArgumentParser, stringValue);
            List<Object> expandedValues = this.argumentAnnotation.suppressFileExpansion() ? Collections.singletonList(normalizedSurrogatePair.getRight()) : commandLineArgumentParser.expandFromExpansionFile(this, messageStream, (String)normalizedSurrogatePair.getRight(), preprocessedValues);
            for (String string : expandedValues) {
                Object actualValue = this.getValuePopulatedWithTags((String)normalizedSurrogatePair.getLeft(), string);
                this.checkArgumentRange(actualValue);
                c.add(actualValue);
            }
        }
    }

    private void setScalarValue(CommandLineArgumentParser commandLineArgumentParser, PrintStream messageStream, List<String> originalValues) {
        if (this.getHasBeenSet() || originalValues.size() > 1) {
            throw new CommandLineException.BadArgumentValue(String.format("Argument '%s' cannot be specified more than once.", this.getArgumentAliasDisplayString()));
        }
        if (this.isFlag() && originalValues.isEmpty()) {
            this.setArgumentValue(true);
        } else {
            String stringValue = originalValues.get(0);
            Object value = null;
            if (stringValue.equals(NULL_ARGUMENT_STRING)) {
                if (this.getUnderlyingField().getType().isPrimitive()) {
                    throw new CommandLineException.BadArgumentValue(String.format("Argument '%s' is not a nullable argument type.", this.getArgumentAliasDisplayString()));
                }
            } else {
                Pair<String, String> normalizedSurrogatePair = this.getNormalizedTagValuePair(commandLineArgumentParser, stringValue);
                value = this.getValuePopulatedWithTags((String)normalizedSurrogatePair.getLeft(), (String)normalizedSurrogatePair.getRight());
            }
            this.checkArgumentRange(value);
            this.setArgumentValue(value);
        }
    }

    private Pair<String, String> getNormalizedTagValuePair(CommandLineArgumentParser commandLineArgumentParser, String preprocessedValue) {
        Pair taggedSurrogatePair = commandLineArgumentParser.getTaggedArgumentParser().getTaggedOptionForSurrogate(preprocessedValue);
        return taggedSurrogatePair == null ? Pair.of(null, (Object)preprocessedValue) : taggedSurrogatePair;
    }

    @Override
    public void validateValues(CommandLineArgumentParser commandLineArgumentParser) {
        Collection c;
        String fullName = this.getLongName();
        ArrayList<String> providedMutexArguments = new ArrayList<String>();
        for (String mutexWith : this.getMutexTargetList()) {
            NamedArgumentDefinition mutexWithDef = commandLineArgumentParser.getNamedArgumentDefinitionByAlias(mutexWith);
            if (!mutexWithDef.getHasBeenSet()) continue;
            providedMutexArguments.add(mutexWithDef.getLongName());
        }
        if (this.getHasBeenSet() && !providedMutexArguments.isEmpty()) {
            throw new CommandLineException(String.format("Argument '%s' cannot be used in conjunction with argument(s) %s", fullName, providedMutexArguments.stream().collect(Collectors.joining(" "))));
        }
        if (!this.isOptional() && (this.isCollection() ? (c = (Collection)this.getArgumentValue()).isEmpty() && providedMutexArguments.isEmpty() : !this.getHasBeenSet() && providedMutexArguments.isEmpty())) {
            throw new CommandLineException.MissingArgument(fullName, this.getArgRequiredErrorMessage());
        }
    }

    public String getArgumentUsage(Map<String, NamedArgumentDefinition> allActualArguments, Collection<CommandLinePluginDescriptor<?>> pluginDescriptors, int argumentColumnWidth, int descriptionColumnWidth) {
        StringBuilder sb = new StringBuilder();
        sb.append("--").append(this.getLongName());
        if (!this.getShortName().isEmpty()) {
            sb.append(",-").append(this.getShortName());
        }
        sb.append(":").append(this.getUnderlyingFieldClass().getSimpleName());
        int labelLength = sb.toString().length();
        int numSpaces = argumentColumnWidth - labelLength;
        if (labelLength > argumentColumnWidth) {
            sb.append("\n");
            numSpaces = argumentColumnWidth;
        }
        NamedArgumentDefinition.printSpaces(sb, numSpaces);
        String description = this.getArgumentDescription(allActualArguments, pluginDescriptors);
        String wrappedDescription = Utils.wrapParagraph(description, descriptionColumnWidth);
        String[] descriptionLines = wrappedDescription.split("\n");
        for (int i = 0; i < descriptionLines.length; ++i) {
            if (i > 0) {
                NamedArgumentDefinition.printSpaces(sb, argumentColumnWidth);
            }
            sb.append(descriptionLines[i]);
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getNameValuePairForDisplay(Object value) {
        if (value != null) {
            if (this.argumentAnnotation.sensitive()) {
                return String.format("--%s ***********", this.getLongName());
            }
            if (value instanceof TaggedArgument) {
                return String.format("--%s %s", TaggedArgumentParser.getDisplayString(this.getLongName(), (TaggedArgument)value), value);
            }
            return String.format("--%s %s", this.getLongName(), value);
        }
        return "";
    }

    private String convertDefaultValueToString() {
        Object initialValue = this.getArgumentValue();
        if (initialValue != null) {
            if (this.isCollection() && ((Collection)initialValue).isEmpty()) {
                return NULL_ARGUMENT_STRING;
            }
            return initialValue.toString();
        }
        return NULL_ARGUMENT_STRING;
    }

    private static boolean isInfinityOrMathematicalInteger(double value) {
        return Double.isInfinite(value) || value == Math.rint(value);
    }

    private void validateBoundsDefinitions() {
        if (!Number.class.isAssignableFrom(this.getUnderlyingFieldClass()) && (this.hasBoundedRange() || this.hasRecommendedRange())) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("Min/max value ranges can only be set for numeric arguments. Argument --%s has a minimum or maximum value but has a non-numeric type.", this.getLongName()));
        }
        if (!(!Integer.class.isAssignableFrom(this.getUnderlyingFieldClass()) || NamedArgumentDefinition.isInfinityOrMathematicalInteger(this.getMaxValue()) && NamedArgumentDefinition.isInfinityOrMathematicalInteger(this.getMinValue()) && NamedArgumentDefinition.isInfinityOrMathematicalInteger(this.getMaxRecommendedValue()) && NamedArgumentDefinition.isInfinityOrMathematicalInteger(this.getMinRecommendedValue()))) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("Integer argument --%s has a minimum or maximum attribute with a non-integral value.", this.getLongName()));
        }
    }

    private Object getValuePopulatedWithTags(String originalTag, String stringValue) {
        Object value = this.constructFromString(stringValue, this.getLongName());
        if (TaggedArgument.class.isAssignableFrom(this.getUnderlyingFieldClass())) {
            TaggedArgument taggedArgument = (TaggedArgument)value;
            TaggedArgumentParser.populateArgumentTags(taggedArgument, this.getLongName(), originalTag);
        } else if (originalTag != null) {
            throw new CommandLineException(String.format("The argument: \"%s/%s\" does not accept tags: \"%s\"", this.getShortName(), this.getFullName(), originalTag));
        }
        return value;
    }

    private String getArgumentDescription(Map<String, NamedArgumentDefinition> allActualArguments, Collection<CommandLinePluginDescriptor<?>> pluginDescriptors) {
        StringBuilder sb = new StringBuilder();
        if (!this.getDocString().isEmpty()) {
            sb.append(this.getDocString());
            sb.append("  ");
        }
        if (this.isCollection()) {
            if (this.isOptional()) {
                sb.append("This argument may be specified 0 or more times. ");
            } else {
                sb.append("This argument must be specified at least once. ");
            }
        }
        if (this.isOptional()) {
            sb.append("Default value: ");
            sb.append(this.getDefaultValueAsString());
            sb.append(". ");
        } else {
            sb.append("Required. ");
        }
        if (!this.usageForPluginDescriptorArgument(sb, pluginDescriptors)) {
            sb.append(this.getOptionsAsDisplayString());
        }
        if (!this.getMutexTargetList().isEmpty()) {
            sb.append(" Cannot be used in conjunction with argument(s)");
            for (String argument : this.getMutexTargetList()) {
                NamedArgumentDefinition mutexArgumentDefinition = allActualArguments.get(argument);
                sb.append(" ").append(mutexArgumentDefinition.getUnderlyingField().getName());
                if (mutexArgumentDefinition.getShortName().isEmpty()) continue;
                sb.append(" (").append(mutexArgumentDefinition.getShortName()).append(")");
            }
        }
        return sb.toString();
    }

    private boolean usageForPluginDescriptorArgument(StringBuilder sb, Collection<CommandLinePluginDescriptor<?>> pluginDescriptors) {
        if (this.getUnderlyingFieldClass().equals(String.class)) {
            for (CommandLinePluginDescriptor<?> descriptor : pluginDescriptors) {
                Set<String> allowedValues = descriptor.getAllowedValuesForDescriptorHelp(this.getLongName());
                if (allowedValues == null) continue;
                if (allowedValues.isEmpty()) {
                    sb.append("Any value allowed");
                } else {
                    sb.append("Possible values: {");
                    sb.append(String.join((CharSequence)", ", allowedValues.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList())));
                    sb.append("Possible values: {");
                }
                return true;
            }
        }
        return false;
    }

    private String getArgRequiredErrorMessage() {
        return this.getMutexTargetList().isEmpty() ? String.format("Argument '%s' is required", this.getLongName()) : String.format("Argument '%s' is required unless one of {%s} are provided", this.getLongName(), this.getMutexTargetList());
    }

    private void checkArgumentRange(Object argumentValue) {
        Double argumentDoubleValue;
        if (!Number.class.isAssignableFrom(this.getUnderlyingFieldClass())) {
            return;
        }
        Double d = argumentDoubleValue = argumentValue == null ? null : Double.valueOf(((Number)argumentValue).doubleValue());
        if (this.hasBoundedRange() && this.isValueOutOfRange(argumentDoubleValue)) {
            throw new CommandLineException.OutOfRangeArgumentValue(this.getLongName(), this.getMinValue(), this.getMaxValue(), argumentValue);
        }
        if (this.hasRecommendedRange() && this.isValueOutOfRange(argumentDoubleValue)) {
            boolean outMaxValue;
            boolean outMinValue = this.getMinRecommendedValue() != Double.NEGATIVE_INFINITY;
            boolean bl = outMaxValue = this.getMaxRecommendedValue() != Double.POSITIVE_INFINITY;
            if (outMinValue && outMaxValue) {
                logger.warn("Argument --{} has value {}, but recommended within range ({},{})", new Object[]{this.getLongName(), argumentDoubleValue, this.getMinRecommendedValue(), this.getMaxRecommendedValue()});
            } else if (outMinValue) {
                logger.warn("Argument --{} has value {}, but minimum recommended is {}", new Object[]{this.getLongName(), argumentDoubleValue, this.getMinRecommendedValue()});
            } else if (outMaxValue) {
                logger.warn("Argument --{} has value {}, but maximum recommended is {}", new Object[]{this.getLongName(), argumentDoubleValue, this.getMaxRecommendedValue()});
            }
        }
    }

    private void setArgumentValue(Object value) {
        try {
            this.getUnderlyingField().set(this.getContainingObject(), value);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException(String.format("Couldn't set field value for %s in %s with value %s.", this.getUnderlyingField().getName(), this.getContainingObject().toString(), value.toString()), e);
        }
    }

    private boolean isValueOutOfRange(Double value) {
        return value == null || this.getMinValue() != Double.NEGATIVE_INFINITY && value < this.getMinValue() || this.getMaxValue() != Double.POSITIVE_INFINITY && value > this.getMaxValue();
    }

    private static void printSpaces(StringBuilder sb, int numSpaces) {
        for (int i = 0; i < numSpaces; ++i) {
            sb.append(" ");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedArgumentDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedArgumentDefinition that = (NamedArgumentDefinition)o;
        if (this.isOptional() != that.isOptional()) {
            return false;
        }
        if (!this.argumentAnnotation.equals(that.argumentAnnotation)) {
            return false;
        }
        if (this.getDescriptorForControllingPlugin() != null ? !this.getDescriptorForControllingPlugin().equals(that.getDescriptorForControllingPlugin()) : that.getDescriptorForControllingPlugin() != null) {
            return false;
        }
        if (!this.mutuallyExclusiveArgs.equals(that.mutuallyExclusiveArgs)) {
            return false;
        }
        return this.getDefaultValueAsString() != null ? this.getDefaultValueAsString().equals(that.getDefaultValueAsString()) : that.getDefaultValueAsString() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.argumentAnnotation.hashCode();
        result = 31 * result + (this.getDescriptorForControllingPlugin() != null ? this.getDescriptorForControllingPlugin().hashCode() : 0);
        result = 31 * result + (this.isOptional() ? 1 : 0);
        result = 31 * result + this.mutuallyExclusiveArgs.hashCode();
        result = 31 * result + (this.getDefaultValueAsString() != null ? this.getDefaultValueAsString().hashCode() : 0);
        return result;
    }
}

