/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLinePluginProvider;
import org.broadinstitute.barclay.argparser.CommandLineProgramGroup;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.NamedArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArgumentDefinition;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocletUtils;
import org.broadinstitute.barclay.help.GSONArgument;
import org.broadinstitute.barclay.help.HelpDoclet;

public class DefaultDocWorkUnitHandler
extends DocWorkUnitHandler {
    protected static final Logger logger = LogManager.getLogger(DefaultDocWorkUnitHandler.class);
    private static final String NAME_FOR_POSITIONAL_ARGS = "[NA - Positional]";
    private static final String DEFAULT_FREEMARKER_TEMPLATE_NAME = "generic.html.ftl";

    public DefaultDocWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    @Override
    public String getTemplateName(DocWorkUnit workUnit) {
        return DEFAULT_FREEMARKER_TEMPLATE_NAME;
    }

    @Override
    public String getSummaryForWorkUnit(DocWorkUnit workUnit) {
        String summary = workUnit.getDocumentedFeature().summary();
        if (summary == null || summary.isEmpty()) {
            CommandLineProgramProperties commandLineProperties = workUnit.getCommandLineProperties();
            if (commandLineProperties != null) {
                summary = commandLineProperties.oneLineSummary();
            }
            if (summary == null || summary.isEmpty()) {
                summary = Arrays.stream(workUnit.getClassDoc().firstSentenceTags()).map(tag -> tag.text()).collect(Collectors.joining());
            }
        }
        return summary == null ? "" : summary;
    }

    @Override
    public String getGroupNameForWorkUnit(DocWorkUnit workUnit) {
        String groupName = workUnit.getDocumentedFeature().groupName();
        if (groupName == null || groupName.isEmpty()) {
            CommandLineProgramGroup clpGroup = workUnit.getCommandLineProgramGroup();
            if (clpGroup != null) {
                groupName = clpGroup.getName();
            }
            if (groupName == null || groupName.isEmpty()) {
                logger.warn("No group name declared for: " + workUnit.getClazz().getCanonicalName());
                groupName = "";
            }
        }
        return groupName;
    }

    @Override
    public String getGroupSummaryForWorkUnit(DocWorkUnit workUnit) {
        String groupSummary = workUnit.getDocumentedFeature().groupSummary();
        CommandLineProgramGroup clpGroup = workUnit.getCommandLineProgramGroup();
        if (groupSummary == null || groupSummary.isEmpty()) {
            if (clpGroup != null) {
                groupSummary = clpGroup.getDescription();
            }
            if (groupSummary == null || groupSummary.isEmpty()) {
                logger.warn("No group summary declared for: " + workUnit.getClazz().getCanonicalName());
                groupSummary = "";
            }
        }
        return groupSummary;
    }

    protected String getDescription(DocWorkUnit currentWorkUnit) {
        return Arrays.stream(currentWorkUnit.getClassDoc().inlineTags()).filter(t -> this.getTagPrefix() == null || !t.name().startsWith(this.getTagPrefix())).map(t -> t.text()).collect(Collectors.joining());
    }

    @Override
    public void processWorkUnit(DocWorkUnit workUnit, List<Map<String, String>> featureMaps, List<Map<String, String>> groupMaps) {
        List<Object> pluginDescriptors;
        CommandLineArgumentParser clp;
        block4: {
            clp = null;
            pluginDescriptors = new ArrayList();
            try {
                Object argumentContainer = workUnit.getClazz().newInstance();
                if (argumentContainer instanceof CommandLinePluginProvider) {
                    pluginDescriptors = ((CommandLinePluginProvider)argumentContainer).getPluginDescriptors();
                    clp = new CommandLineArgumentParser(argumentContainer, pluginDescriptors, Collections.emptySet());
                } else {
                    clp = new CommandLineArgumentParser(argumentContainer);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                if (workUnit.getCommandLineProperties() == null) break block4;
                throw new RuntimeException(workUnit.getClazz() + " requires a non-arg constructor, because it is annotated with CommandLineProgramProperties ", e);
            }
        }
        workUnit.setProperty("groups", groupMaps);
        workUnit.setProperty("data", featureMaps);
        this.addHighLevelBindings(workUnit);
        this.addCommandLineArgumentBindings(workUnit, clp);
        this.addDefaultPlugins(workUnit, pluginDescriptors);
        this.addExtraDocsBindings(workUnit);
        this.addCustomBindings(workUnit);
    }

    protected void addHighLevelBindings(DocWorkUnit workUnit) {
        workUnit.setProperty("name", workUnit.getName());
        workUnit.setProperty("group", workUnit.getGroupName());
        workUnit.setProperty("summary", workUnit.getSummary());
        workUnit.setProperty("beta", workUnit.isBetaFeature());
        workUnit.setProperty("experimental", workUnit.isExperimentalFeature());
        workUnit.setProperty("description", this.getDescription(workUnit));
        workUnit.setProperty("version", this.getDoclet().getBuildVersion());
        workUnit.setProperty("timestamp", this.getDoclet().getBuildTimeStamp());
    }

    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        String tagFilterPrefix = this.getTagPrefix();
        Arrays.stream(currentWorkUnit.getClassDoc().inlineTags()).filter(t -> t.name().startsWith(tagFilterPrefix)).forEach(t -> currentWorkUnit.setProperty(t.name().substring(tagFilterPrefix.length()), t.text()));
    }

    protected String getTagFilterPrefix() {
        return "";
    }

    protected void addExtraDocsBindings(DocWorkUnit currentWorkUnit) {
        ArrayList<1> extraDocsData = new ArrayList<1>();
        for (Class<?> extraDocClass : currentWorkUnit.getDocumentedFeature().extraDocs()) {
            final DocWorkUnit otherUnit = this.getDoclet().findWorkUnitForClass(extraDocClass);
            if (otherUnit == null) {
                String msg = String.format("An \"extradocs\" value (%s) was specified for (%s), but the target was not included in the source list for this javadoc run, or the target has no documentation.", extraDocClass, currentWorkUnit.getName());
                throw new DocException(msg);
            }
            extraDocsData.add(new HashMap<String, Object>(){
                static final long serialVersionUID = 0L;
                {
                    this.put("name", otherUnit.getName());
                    this.put("filename", otherUnit.getTargetFileName());
                }
            });
        }
        currentWorkUnit.setProperty("extradocs", extraDocsData);
    }

    protected void addCommandLineArgumentBindings(DocWorkUnit currentWorkUnit, CommandLineArgumentParser clp) {
        Map<String, List<Map<String, Object>>> argMap = this.createArgumentMap();
        currentWorkUnit.setProperty("arguments", argMap);
        if (clp != null) {
            this.processPositionalArguments(clp, argMap);
            clp.getNamedArgumentDefinitions().stream().forEach(argDef -> this.processNamedArgument(currentWorkUnit, argMap, (NamedArgumentDefinition)argDef));
            argMap.entrySet().stream().forEach(entry -> entry.setValue(this.sortArguments((List)entry.getValue())));
            ArrayList<GSONArgument> allGSONArgs = new ArrayList<GSONArgument>();
            for (Map<String, Object> item : argMap.get("all")) {
                GSONArgument itemGSONArg = new GSONArgument();
                itemGSONArg.populate(item.get("summary").toString(), item.get("name").toString(), item.get("synonyms").toString(), item.get("type").toString(), item.get("required").toString(), item.get("fulltext").toString(), item.get("defaultValue").toString(), item.get("minValue").toString(), item.get("maxValue").toString(), item.get("minRecValue").toString(), item.get("maxRecValue").toString(), item.get("kind").toString(), (List)item.get("options"));
                allGSONArgs.add(itemGSONArg);
            }
            currentWorkUnit.setProperty("gson-arguments", allGSONArgs);
        }
    }

    private String getTagPrefix() {
        String customPrefix = this.getTagFilterPrefix();
        return customPrefix == null ? customPrefix : "@" + customPrefix + ".";
    }

    protected void addDefaultPlugins(DocWorkUnit currentWorkUnit, List<? extends CommandLinePluginDescriptor<?>> pluginDescriptors) {
        for (CommandLinePluginDescriptor<?> descriptor : pluginDescriptors) {
            String descriptorName = descriptor.getDisplayName();
            HashSet defaultsForPlugins = new HashSet();
            currentWorkUnit.setProperty(descriptorName, defaultsForPlugins);
            for (Object plugin : descriptor.getDefaultInstances()) {
                HashMap<String, String> pluginDetails = new HashMap<String, String>();
                pluginDetails.put("name", plugin.getClass().getSimpleName());
                pluginDetails.put("filename", DocletUtils.phpFilenameForClass(plugin.getClass(), this.getDoclet().getOutputFileExtension()));
                defaultsForPlugins.add(pluginDetails);
            }
        }
    }

    protected void processNamedArgument(DocWorkUnit currentWorkUnit, Map<String, List<Map<String, Object>>> args, NamedArgumentDefinition argDef) {
        if (!(argDef.isControlledByPlugin() || argDef.isHidden() && !this.getDoclet().showHiddenFeatures())) {
            HashMap<String, Object> argMap = new HashMap<String, Object>();
            FieldDoc fieldDoc = this.getFieldDocForCommandLineArgument(currentWorkUnit, argDef);
            String argKind = this.processNamedArgument(argMap, argDef, fieldDoc.commentText());
            args.get(argKind).add(argMap);
            args.get("all").add(argMap);
        }
    }

    private FieldDoc getFieldDocForCommandLineArgument(DocWorkUnit currentWorkUnit, NamedArgumentDefinition argDef) {
        String declaringClassTypeName = argDef.getUnderlyingField().getDeclaringClass().getTypeName();
        ClassDoc declaringClassDoc = this.getDoclet().getRootDoc().classNamed(declaringClassTypeName);
        if (declaringClassDoc == null) {
            throw new DocException(String.format("Can't resolve ClassDoc for declaring class for argument \"%s\" in \"%s\" with qualified name \"%s\"", argDef.getUnderlyingField().getName(), currentWorkUnit.getClassDoc().qualifiedTypeName(), declaringClassTypeName));
        }
        FieldDoc fieldDoc = this.getFieldDoc(declaringClassDoc, argDef.getUnderlyingField().getName());
        if (fieldDoc == null) {
            throw new DocException(String.format("The class \"%s\" is referenced by \"%s\", and must be included in the list of documentation sources.", argDef.getUnderlyingField().getDeclaringClass().getCanonicalName(), currentWorkUnit.getClassDoc().qualifiedTypeName()));
        }
        String normalizedTypeName = declaringClassTypeName.replace('$', '.');
        if (!fieldDoc.qualifiedName().startsWith(normalizedTypeName)) {
            if (argDef.getUnderlyingField().getDeclaringClass().isLocalClass() || argDef.getUnderlyingField().getDeclaringClass().isAnonymousClass()) {
                logger.warn(String.format("Field level Javadoc is ignored for local/anonymous class for member field \"%s\" in \"%s\" of type \"%s\".", argDef.getUnderlyingField().getName(), currentWorkUnit.getClazz().getCanonicalName(), declaringClassTypeName));
            } else {
                logger.warn(String.format("Can't validate FieldDoc \"%s\" for member field \"%s\" in \"%s\" of type \"%s\".", fieldDoc.qualifiedName(), argDef.getUnderlyingField().getName(), currentWorkUnit.getClazz().getCanonicalName(), declaringClassTypeName));
            }
        }
        return fieldDoc;
    }

    protected void processPositionalArguments(CommandLineArgumentParser clp, Map<String, List<Map<String, Object>>> args) {
        PositionalArgumentDefinition positionalArgDef = clp.getPositionalArgumentDefinition();
        if (positionalArgDef != null) {
            HashMap<String, Object> argBindings = new HashMap<String, Object>();
            argBindings.put("kind", "positional");
            argBindings.put("name", NAME_FOR_POSITIONAL_ARGS);
            argBindings.put("summary", positionalArgDef.getPositionalArgumentsAnnotation().doc());
            argBindings.put("fulltext", positionalArgDef.getPositionalArgumentsAnnotation().doc());
            argBindings.put("otherArgumentRequired", "NA");
            argBindings.put("synonyms", "NA");
            argBindings.put("exclusiveOf", "NA");
            argBindings.put("type", this.argumentTypeString(positionalArgDef.getUnderlyingField().getGenericType()));
            argBindings.put("options", Collections.EMPTY_LIST);
            argBindings.put("attributes", "NA");
            argBindings.put("required", "yes");
            argBindings.put("minRecValue", "NA");
            argBindings.put("maxRecValue", "NA");
            argBindings.put("minValue", "NA");
            argBindings.put("maxValue", "NA");
            argBindings.put("defaultValue", "NA");
            argBindings.put("minElements", positionalArgDef.getPositionalArgumentsAnnotation().minElements());
            argBindings.put("maxElements", positionalArgDef.getPositionalArgumentsAnnotation().maxElements());
            args.get("positional").add(argBindings);
            args.get("all").add(argBindings);
        }
    }

    private String docKindOfArg(NamedArgumentDefinition argumentDefinition) {
        if (argumentDefinition.isDeprecated()) {
            return "deprecated";
        }
        if (argumentDefinition.isControlledByPlugin()) {
            return "dependent";
        }
        if (!argumentDefinition.isOptional()) {
            return "required";
        }
        if (argumentDefinition.isCommon()) {
            return "common";
        }
        if (argumentDefinition.isAdvanced()) {
            return "advanced";
        }
        if (argumentDefinition.isHidden()) {
            return "hidden";
        }
        return "optional";
    }

    private Map<String, List<Map<String, Object>>> createArgumentMap() {
        HashMap<String, List<Map<String, Object>>> args = new HashMap<String, List<Map<String, Object>>>();
        args.put("all", new ArrayList());
        args.put("common", new ArrayList());
        args.put("positional", new ArrayList());
        args.put("required", new ArrayList());
        args.put("optional", new ArrayList());
        args.put("advanced", new ArrayList());
        args.put("dependent", new ArrayList());
        args.put("hidden", new ArrayList());
        args.put("deprecated", new ArrayList());
        return args;
    }

    private List<Map<String, Object>> sortArguments(List<Map<String, Object>> unsorted) {
        Collections.sort(unsorted, new CompareArgumentsByName());
        return unsorted;
    }

    private Object prettyPrintValueString(Object value) {
        if (value instanceof String) {
            return value.equals("") ? "\"\"" : value;
        }
        return value.toString();
    }

    private FieldDoc getFieldDoc(ClassDoc classDoc, String argumentFieldName) {
        for (FieldDoc fieldDoc : classDoc.fields(false)) {
            if (fieldDoc.name().equals(argumentFieldName)) {
                return fieldDoc;
            }
            Field field = DocletUtils.getFieldForFieldDoc(fieldDoc);
            if (field == null) {
                logger.warn(String.format("Could not access the field definition for %s while searching for %s, presumably because the field is inaccessible", fieldDoc.name(), argumentFieldName));
                continue;
            }
            if (!field.isAnnotationPresent(ArgumentCollection.class)) continue;
            ClassDoc typeDoc = this.getDoclet().getRootDoc().classNamed(fieldDoc.type().qualifiedTypeName());
            if (typeDoc == null) {
                throw new DocException("Tried to get javadocs for ArgumentCollection field " + fieldDoc + " but couldn't find the class in the RootDoc");
            }
            FieldDoc result = this.getFieldDoc(typeDoc, argumentFieldName);
            if (result == null) continue;
            return result;
        }
        if (classDoc.superclass() != null) {
            return this.getFieldDoc(classDoc.superclass(), argumentFieldName);
        }
        return null;
    }

    private Pair<String, String> displayNames(String s1, String s2) {
        s1 = s1 == null || s1.length() == 0 ? null : "-" + s1;
        String string = s2 = s2 == null || s2.length() == 0 ? null : "--" + s2;
        if (s1 == null) {
            return Pair.of((Object)s2, null);
        }
        if (s2 == null) {
            return Pair.of((Object)s1, null);
        }
        return Pair.of((Object)s2, (Object)s1);
    }

    protected String argumentTypeString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ArrayList<String> subs = new ArrayList<String>();
            for (Type actualType : parameterizedType.getActualTypeArguments()) {
                subs.add(this.argumentTypeString(actualType));
            }
            return this.argumentTypeString(((ParameterizedType)type).getRawType()) + "[" + String.join((CharSequence)",", subs) + "]";
        }
        if (type instanceof GenericArrayType) {
            return this.argumentTypeString(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("We don't support wildcards in arguments: " + type);
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        throw new DocException("Unknown type: " + type);
    }

    protected String processNamedArgument(Map<String, Object> argBindings, NamedArgumentDefinition argDef, String fieldCommentText) {
        Object fieldValue = argDef.getArgumentValue();
        argBindings.put("defaultValue", fieldValue == null ? argDef.getDefaultValueAsString() : this.prettyPrintValueString(fieldValue));
        if (fieldValue instanceof Number) {
            argBindings.put("minValue", argDef.getMinValue());
            argBindings.put("maxValue", argDef.getMaxValue());
            argBindings.put("minRecValue", argDef.getMinRecommendedValue() != Double.NEGATIVE_INFINITY ? argDef.getMinRecommendedValue() : "NA");
            argBindings.put("maxRecValue", argDef.getMaxRecommendedValue() != Double.POSITIVE_INFINITY ? argDef.getMaxRecommendedValue() : "NA");
        } else {
            argBindings.put("minValue", "NA");
            argBindings.put("maxValue", "NA");
            argBindings.put("minRecValue", "NA");
            argBindings.put("maxRecValue", "NA");
        }
        argBindings.put("minElements", argDef.getMinElements());
        argBindings.put("maxElements", argDef.getMaxElements());
        String kind = this.docKindOfArg(argDef);
        argBindings.put("kind", kind);
        Pair<String, String> names = this.displayNames(argDef.getShortName(), argDef.getLongName());
        argBindings.put("name", names.getLeft());
        argBindings.put("synonyms", names.getRight() != null ? names.getRight() : "NA");
        argBindings.put("required", argDef.isOptional() ? "no" : "yes");
        argBindings.put("type", this.argumentTypeString(argDef.getUnderlyingField().getGenericType()));
        argBindings.put("summary", argDef.getDocString() != null ? argDef.getDocString() : "");
        argBindings.put("fulltext", fieldCommentText);
        if (argDef.isControlledByPlugin()) {
            argBindings.put("otherArgumentRequired", argDef.getContainingObject().getClass().getSimpleName().length() == 0 ? argDef.getContainingObject().getClass().getName() : argDef.getContainingObject().getClass().getSimpleName());
        } else {
            argBindings.put("otherArgumentRequired", "NA");
        }
        argBindings.put("exclusiveOf", argDef.getMutexTargetList() != null && !argDef.getMutexTargetList().isEmpty() ? String.join((CharSequence)", ", argDef.getMutexTargetList()) : "NA");
        argBindings.put("options", argDef.getUnderlyingField().getType().isEnum() ? this.docForEnumArgument(argDef.getUnderlyingField().getType()) : Collections.EMPTY_LIST);
        ArrayList<String> attributes = new ArrayList<String>();
        if (!argDef.isOptional()) {
            attributes.add("required");
        }
        if (argDef.isDeprecated()) {
            attributes.add("deprecated");
        }
        argBindings.put("attributes", attributes.size() > 0 ? String.join((CharSequence)", ", attributes) : "NA");
        return kind;
    }

    private List<Map<String, Object>> docForEnumArgument(Class<?> enumClass) {
        ClassDoc doc = this.getDoclet().getClassDocForClass(enumClass);
        if (doc == null) {
            throw new RuntimeException("Tried to get docs for enum " + enumClass + " but got null instead");
        }
        Set<String> enumConstantFieldNames = this.enumConstantsNames(enumClass);
        ArrayList<Map<String, Object>> bindings = new ArrayList<Map<String, Object>>();
        for (final FieldDoc fieldDoc : doc.fields(false)) {
            if (!enumConstantFieldNames.contains(fieldDoc.name())) continue;
            bindings.add((Map<String, Object>)new HashMap<String, Object>(){
                static final long serialVersionUID = 0L;
                {
                    this.put("name", fieldDoc.name());
                    this.put("summary", fieldDoc.commentText());
                }
            });
        }
        return bindings;
    }

    private Set<String> enumConstantsNames(Class<?> enumClass) {
        HashSet<String> enumConstantFieldNames = new HashSet<String>();
        for (Field field : enumClass.getFields()) {
            if (!field.isEnumConstant()) continue;
            enumConstantFieldNames.add(field.getName());
        }
        return enumConstantFieldNames;
    }

    private class CompareArgumentsByName
    implements Comparator<Map<String, Object>> {
        private CompareArgumentsByName() {
        }

        @Override
        public int compare(Map<String, Object> x, Map<String, Object> y) {
            return this.elt(x).compareTo(this.elt(y));
        }

        private String elt(Map<String, Object> m) {
            String v = m.get("name").toString().toLowerCase();
            if (v.startsWith("--")) {
                return v.substring(2);
            }
            if (v.startsWith("-")) {
                return v.substring(1);
            }
            if (v.equals(DefaultDocWorkUnitHandler.NAME_FOR_POSITIONAL_ARGS.toLowerCase())) {
                return "Positional";
            }
            throw new RuntimeException("Expect to see arguments beginning with at least one -, but found " + v);
        }
    }
}

