/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;

public class Utils {
    private static final int TEXT_WARNING_WIDTH = 68;
    private static final String TEXT_WARNING_PREFIX = "* ";
    private static final String TEXT_WARNING_BORDER = Utils.dupString('*', "* ".length() + 68);
    private static final char ESCAPE_CHAR = '\u001b';
    public static final String TEXT_BLINK = "\u001b[5m";
    public static final String TEXT_RESET = "\u001b[m";

    public static <T> T nonNull(T object) {
        return Utils.nonNull(object, "Null object is not allowed here.");
    }

    public static <T> T nonNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static <T> T nonNull(T object, Supplier<String> message) {
        if (object == null) {
            throw new IllegalArgumentException(message.get());
        }
        return object;
    }

    public static List<String> warnUserLines(String msg) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(String.format(TEXT_WARNING_BORDER, new Object[0]));
        results.add(String.format("* WARNING:", new Object[0]));
        results.add(String.format(TEXT_WARNING_PREFIX, new Object[0]));
        Utils.prettyPrintWarningMessage(results, msg);
        results.add(String.format(TEXT_WARNING_BORDER, new Object[0]));
        return results;
    }

    private static void prettyPrintWarningMessage(List<String> results, String message) {
        for (String line : message.split("\\r?\\n")) {
            StringBuilder builder = new StringBuilder(line);
            while (builder.length() > 68) {
                int space = Utils.getLastSpace(builder, 68);
                if (space <= 0) {
                    space = 68;
                }
                results.add(String.format("%s%s", TEXT_WARNING_PREFIX, builder.substring(0, space)));
                builder.delete(0, space + 1);
            }
            results.add(String.format("%s%s", TEXT_WARNING_PREFIX, builder));
        }
    }

    private static int getLastSpace(CharSequence message, int width) {
        int length = message.length();
        int stopPos = width;
        int lastSpace = -1;
        boolean inEscape = false;
        for (int currPos = 0; currPos < stopPos && currPos < length; ++currPos) {
            char c = message.charAt(currPos);
            if (c == '\u001b') {
                ++stopPos;
                inEscape = true;
                continue;
            }
            if (inEscape) {
                ++stopPos;
                if (!Character.isLetter(c)) continue;
                inEscape = false;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            lastSpace = currPos;
        }
        return lastSpace;
    }

    public static String dupString(char c, int nCopies) {
        char[] chars = new char[nCopies];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static boolean equals(Object lhs, Object rhs) {
        return lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
    }

    public static String wrapParagraph(String input, int width) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder out = new StringBuilder();
        try (BufferedReader bufReader = new BufferedReader(new StringReader(input));){
            out.append(bufReader.lines().map(line -> WordUtils.wrap((String)line, (int)width)).collect(Collectors.joining("\n")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unreachable Statement.\nHow did the Buffered reader throw when it was wrapping a StringReader?", e);
        }
        if (input.charAt(input.length() - 1) == '\n') {
            out.append('\n');
        }
        return out.toString();
    }
}

