/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WDLTransforms {
    private static final Set<String> wdlReservedWords = Stream.of("after", "alias", "Array", "as", "boolean", "call", "else", "equal", "float", "if", "import", "in", "input", "integer", "meta", "none", "not", "null", "object", "output", "parameter_meta", "runtime", "scatter", "string", "struct", "task", "then", "version", "workflow").collect(Collectors.toCollection(HashSet::new));
    private static final Map<Class<?>, ImmutablePair<String, String>> javaToWDLTypeMap = new HashMap<Class<?>, ImmutablePair<String, String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(String.class, new ImmutablePair((Object)"String", (Object)"String"));
            this.put(Boolean.TYPE, new ImmutablePair((Object)"boolean", (Object)"Boolean"));
            this.put(Boolean.class, new ImmutablePair((Object)"Boolean", (Object)"Boolean"));
            this.put(Byte.TYPE, new ImmutablePair((Object)"byte", (Object)"Int"));
            this.put(Byte.class, new ImmutablePair((Object)"Byte", (Object)"Int"));
            this.put(Integer.TYPE, new ImmutablePair((Object)"int", (Object)"Int"));
            this.put(Integer.class, new ImmutablePair((Object)"Integer", (Object)"Int"));
            this.put(Long.TYPE, new ImmutablePair((Object)"long", (Object)"Int"));
            this.put(Long.class, new ImmutablePair((Object)"Long", (Object)"Int"));
            this.put(Float.TYPE, new ImmutablePair((Object)"float", (Object)"Float"));
            this.put(Float.class, new ImmutablePair((Object)"Float", (Object)"Float"));
            this.put(Double.TYPE, new ImmutablePair((Object)"double", (Object)"Float"));
            this.put(Double.class, new ImmutablePair((Object)"Double", (Object)"Float"));
            this.put(File.class, new ImmutablePair((Object)"File", (Object)"File"));
            this.put(URI.class, new ImmutablePair((Object)"URI", (Object)"String"));
            this.put(URL.class, new ImmutablePair((Object)"URL", (Object)"String"));
        }
    };
    private static final Map<Class<?>, ImmutablePair<String, String>> javaCollectionToWDLCollectionTypeMap = new HashMap<Class<?>, ImmutablePair<String, String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(List.class, new ImmutablePair((Object)"List", (Object)"Array"));
            this.put(ArrayList.class, new ImmutablePair((Object)"ArrayList", (Object)"Array"));
            this.put(Set.class, new ImmutablePair((Object)"Set", (Object)"Array"));
            this.put(EnumSet.class, new ImmutablePair((Object)"EnumSet", (Object)"Array"));
        }
    };

    public static String transformJavaNameToWDLName(String candidateArgName) {
        return WDLTransforms.transformWDLReservedWord(candidateArgName.replace("-", "_"));
    }

    public static String transformWDLReservedWord(String candidateArgName) {
        return wdlReservedWords.contains(candidateArgName) ? candidateArgName + "_arg" : candidateArgName;
    }

    public static Pair<String, String> transformToWDLType(Class<?> argumentClass) {
        return (Pair)javaToWDLTypeMap.get(argumentClass);
    }

    public static Pair<String, String> transformToWDLCollectionType(Class<?> argumentCollectionClass) {
        return (Pair)javaCollectionToWDLCollectionTypeMap.get(argumentCollectionClass);
    }
}

