/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.NamedArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArgumentDefinition;
import org.broadinstitute.barclay.argparser.SpecialArgumentsCollection;
import org.broadinstitute.barclay.argparser.WorkflowInput;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DefaultDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.WDLTransforms;

public class WDLWorkUnitHandler
extends DefaultDocWorkUnitHandler {
    private static final String GATK_FREEMARKER_TEMPLATE_NAME = "wdlToolTemplate.wdl.ftl";
    public static final String POSITIONAL_ARGS = "--positionalArgs";
    protected final Map<String, String> runtimeOutputs = new LinkedHashMap<String, String>();
    protected final Map<String, String> requiredOutputs = new LinkedHashMap<String, String>();
    protected final Map<String, List<Map<String, String>>> requiredCompanionFiles = new HashMap<String, List<Map<String, String>>>();
    protected final Map<String, List<Map<String, String>>> optionalCompanionFiles = new HashMap<String, List<Map<String, String>>>();
    protected final Set<String> localizationOptional = new LinkedHashSet<String>();

    public WDLWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    @Override
    public String getTemplateName(DocWorkUnit workUnit) {
        return GATK_FREEMARKER_TEMPLATE_NAME;
    }

    @Override
    protected void addCommandLineArgumentBindings(DocWorkUnit currentWorkUnit, CommandLineArgumentParser clp) {
        super.addCommandLineArgumentBindings(currentWorkUnit, clp);
        currentWorkUnit.getRootMap().put("runtimeOutputs", this.runtimeOutputs);
        currentWorkUnit.getRootMap().put("requiredOutputs", this.requiredOutputs);
        currentWorkUnit.getRootMap().put("requiredCompanions", this.requiredCompanionFiles);
        currentWorkUnit.getRootMap().put("optionalCompanions", this.optionalCompanionFiles);
        currentWorkUnit.getRootMap().put("localizationOptional", this.localizationOptional);
    }

    @Override
    protected void processNamedArgument(DocWorkUnit currentWorkUnit, Map<String, List<Map<String, Object>>> args, NamedArgumentDefinition argDef) {
        if (!argDef.getUnderlyingField().getDeclaringClass().equals(SpecialArgumentsCollection.class)) {
            super.processNamedArgument(currentWorkUnit, args, argDef);
        }
    }

    @Override
    protected String processNamedArgument(Map<String, Object> argBindings, NamedArgumentDefinition argDef, String fieldCommentText) {
        String argCategory = super.processNamedArgument(argBindings, argDef, fieldCommentText);
        String actualArgName = (String)argBindings.get("name");
        argBindings.put("actualArgName", actualArgName);
        String wdlName = "--" + this.transformJavaNameToWDLName(actualArgName.substring(2));
        argBindings.put("name", wdlName);
        this.propagateArgument(wdlName, argDef, argBindings);
        return argCategory;
    }

    @Override
    protected void processPositionalArguments(CommandLineArgumentParser clp, Map<String, List<Map<String, Object>>> argBindings) {
        super.processPositionalArguments(clp, argBindings);
        PositionalArgumentDefinition argDef = clp.getPositionalArgumentDefinition();
        if (argDef != null) {
            Map<String, Object> positionalArgBindings = argBindings.get("positional").get(0);
            this.propagateArgument(POSITIONAL_ARGS, argDef, positionalArgBindings);
        }
    }

    protected void propagateArgument(String wdlArgName, ArgumentDefinition argDef, Map<String, Object> argBindings) {
        WorkflowInput workFlowInput = argDef.getUnderlyingField().getAnnotation(WorkflowInput.class);
        WorkflowOutput workFlowOutput = argDef.getUnderlyingField().getAnnotation(WorkflowOutput.class);
        String preProcessedType = (String)argBindings.get("type");
        String wdlType = this.getWDLTypeForArgument(argDef, null, preProcessedType);
        String wdlInputType = this.getWDLTypeForArgument(argDef, workFlowOutput, preProcessedType);
        argBindings.put("type", wdlType);
        argBindings.put("wdlinputtype", wdlInputType);
        argBindings.put("defaultValue", this.defaultValueAsJSON(wdlType, (String)argBindings.get("defaultValue")));
        boolean argIsRequired = wdlArgName.equals(POSITIONAL_ARGS) || argBindings.get("required").equals("yes");
        this.propagateWorkflowAttributes(workFlowInput, workFlowOutput, wdlArgName, wdlType, !argIsRequired);
    }

    protected void propagateWorkflowAttributes(WorkflowInput workflowInput, WorkflowOutput workflowOutput, String targetArgWDLName, String targetArgWDLType, boolean targetArgIsOptional) {
        Map<String, String> companionMap;
        ArrayList<Map<String, String>> requiredCompanions = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> optionalCompanions = new ArrayList<Map<String, String>>();
        if (workflowInput != null) {
            if (workflowInput.localizationOptional()) {
                this.localizationOptional.add(targetArgWDLName);
            }
            for (String requiredInputCompanion : workflowInput.requiredCompanions()) {
                Map<String, String> requiredInputCompanionMap = this.createCompanionMapEntry(targetArgWDLName, requiredInputCompanion);
                if (targetArgIsOptional) {
                    optionalCompanions.add(requiredInputCompanionMap);
                } else {
                    requiredCompanions.add(requiredInputCompanionMap);
                }
                if (!workflowInput.localizationOptional()) continue;
                this.localizationOptional.add(requiredInputCompanionMap.get("name"));
            }
            for (String optionalInputCompanion : workflowInput.optionalCompanions()) {
                companionMap = this.createCompanionMapEntry(targetArgWDLName, optionalInputCompanion);
                optionalCompanions.add(companionMap);
                if (!workflowInput.localizationOptional()) continue;
                this.localizationOptional.add(companionMap.get("name"));
            }
        }
        if (workflowOutput != null) {
            this.runtimeOutputs.put(targetArgWDLName, targetArgWDLType);
            if (!targetArgIsOptional) {
                this.requiredOutputs.put(targetArgWDLName, targetArgWDLType);
            }
            for (String requiredOutputCompanion : workflowOutput.requiredCompanions()) {
                companionMap = this.createCompanionMapEntry(targetArgWDLName, requiredOutputCompanion);
                this.runtimeOutputs.put(companionMap.get("name"), targetArgWDLType);
                if (targetArgIsOptional) {
                    optionalCompanions.add(companionMap);
                    continue;
                }
                requiredCompanions.add(companionMap);
                this.requiredOutputs.put(companionMap.get("name"), targetArgWDLType);
            }
            for (String optionalOutputCompanion : workflowOutput.optionalCompanions()) {
                companionMap = this.createCompanionMapEntry(targetArgWDLName, optionalOutputCompanion);
                this.runtimeOutputs.put(companionMap.get("name"), targetArgWDLType);
                optionalCompanions.add(companionMap);
            }
        }
        this.requiredCompanionFiles.put(targetArgWDLName, requiredCompanions);
        this.optionalCompanionFiles.put(targetArgWDLName, optionalCompanions);
    }

    protected Map<String, String> createCompanionMapEntry(String targetArgName, String companionName) {
        HashMap<String, String> companionMap = new HashMap<String, String>();
        String companionArgOption = "--" + companionName;
        companionMap.put("name", companionArgOption);
        companionMap.put("summary", String.format("Companion resource for %s", targetArgName.substring(2)));
        return companionMap;
    }

    protected String getWDLTypeForArgument(ArgumentDefinition argDef, WorkflowOutput workflowOutput, String argDocType) {
        Field argField = argDef.getUnderlyingField();
        Class<?> argumentClass = argField.getType();
        String wdlType = argDocType;
        if (argDef.isCollection()) {
            Pair<String, String> conversionPair = this.transformToWDLCollectionType(argumentClass);
            if (conversionPair == null) {
                throw new IllegalArgumentException(String.format("Unrecognized collection type %s for argument %s in work unit %s.Argument collection type must be one of List or Set.", argumentClass, argField.getName(), argField.getDeclaringClass()));
            }
            wdlType = wdlType.replace((CharSequence)conversionPair.getLeft(), (CharSequence)conversionPair.getRight());
            Type typeParamType = argField.getGenericType();
            if (typeParamType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)typeParamType;
                Type[] genericTypes = pType.getActualTypeArguments();
                if (genericTypes.length != 1) {
                    throw new RuntimeException(String.format("Generating WDL for tools with arguments that have types that require multiple type parameters is not supported (class %s for arg %s in %s has multiple type parameters).", argumentClass, argField.getName(), argField.getDeclaringClass()));
                }
                ParameterizedType pType2 = null;
                try {
                    if (genericTypes[0] instanceof ParameterizedType) {
                        pType2 = (ParameterizedType)genericTypes[0];
                        Type[] genericTypes2 = pType2.getActualTypeArguments();
                        if (genericTypes2.length != 1) {
                            throw new RuntimeException(String.format("Generating WDL for tools with args with multiple type parameters is not supported (class %s for arg %s in %s has multiple type parameters).", argumentClass, argField.getName(), argField.getDeclaringClass()));
                        }
                        Class<?> nestedTypeClass = Class.forName(pType2.getRawType().getTypeName());
                        wdlType = this.convertJavaTypeToWDLType(workflowOutput, nestedTypeClass, wdlType, argField.getDeclaringClass().toString());
                    } else {
                        Class<?> nestedTypeClass = Class.forName(genericTypes[0].getTypeName());
                        wdlType = this.convertJavaTypeToWDLType(workflowOutput, nestedTypeClass, wdlType, argField.getDeclaringClass().toString());
                    }
                    return wdlType;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(String.format("WDL generation can't find class %s for %s", pType2.getRawType().toString(), argField.getDeclaringClass()), e);
                }
            }
            throw new RuntimeException(String.format("Generic type must have a ParameterizedType (class %s for argument %s/%s)", argumentClass, argField.getName(), argField.getDeclaringClass()));
        }
        return this.convertJavaTypeToWDLType(workflowOutput, argumentClass, wdlType, argField.getDeclaringClass().toString());
    }

    protected String convertJavaTypeToWDLType(WorkflowOutput workflowOutput, Class<?> argumentClass, String docType, String sourceContext) {
        String convertedWDLType;
        Pair<String, String> typeConversionPair = this.transformToWDLType(argumentClass);
        if (typeConversionPair != null) {
            convertedWDLType = docType.replace((CharSequence)typeConversionPair.getKey(), this.transformWorkflowOutputTypeToInputType(workflowOutput, (String)typeConversionPair.getValue()));
        } else if (argumentClass.isEnum()) {
            convertedWDLType = docType.replace(argumentClass.getSimpleName(), "String");
        } else {
            throw new RuntimeException(String.format("Don't know how to convert Java type %s in %s to a corresponding WDL type. The WDL generator type converter code must be updated to support this Java type.", argumentClass, sourceContext));
        }
        return convertedWDLType;
    }

    protected String transformWorkflowOutputTypeToInputType(WorkflowOutput workflowOutput, String convertedWDLType) {
        return workflowOutput != null && convertedWDLType.equals("File") ? "String" : convertedWDLType;
    }

    protected Pair<String, String> transformToWDLType(Class<?> argumentClass) {
        return WDLTransforms.transformToWDLType(argumentClass);
    }

    protected String defaultValueAsJSON(String wdlType, String defaultWDLValue) {
        if (defaultWDLValue.equals("null") || defaultWDLValue.equals("\"\"")) {
            return defaultWDLValue;
        }
        if (defaultWDLValue.equals("[]")) {
            return "null";
        }
        if (defaultWDLValue.startsWith("[") && wdlType.equals("Array[String]")) {
            return this.quoteWDLArrayValues(defaultWDLValue);
        }
        if (wdlType.equals("String")) {
            return "\"" + defaultWDLValue + "\"";
        }
        if (wdlType.equals("Float") && (defaultWDLValue.equalsIgnoreCase("Infinity") || defaultWDLValue.equalsIgnoreCase("Nan"))) {
            return "\"" + defaultWDLValue + "\"";
        }
        return defaultWDLValue;
    }

    protected String quoteWDLArrayValues(String wdlArray) {
        String wdlValues = wdlArray.substring(1, wdlArray.length() - 1);
        String[] wdlValueArray = wdlValues.split(",");
        return String.format("[%s]", Arrays.stream(wdlValueArray).map(s -> String.format("\"%s\"", s.trim())).collect(Collectors.joining(",")));
    }

    protected String transformJavaNameToWDLName(String candidateName) {
        return WDLTransforms.transformJavaNameToWDLName(candidateName);
    }

    protected Pair<String, String> transformToWDLCollectionType(Class<?> argumentCollectionClass) {
        return WDLTransforms.transformToWDLCollectionType(argumentCollectionClass);
    }

    @Override
    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        super.addCustomBindings(currentWorkUnit);
        WorkflowProperties rtProperties = currentWorkUnit.getClazz().getAnnotation(WorkflowProperties.class);
        if (rtProperties != null) {
            HashMap<String, String> workflowPropertiesMap = new HashMap<String, String>();
            workflowPropertiesMap.put("memoryRequirements", rtProperties.memory());
            workflowPropertiesMap.put("diskRequirements", rtProperties.disks());
            workflowPropertiesMap.put("cpuRequirements", Integer.toString(rtProperties.cpu()));
            workflowPropertiesMap.put("preemptibleRequirements", Integer.toString(rtProperties.preEmptible()));
            workflowPropertiesMap.put("bootdisksizegbRequirements", Integer.toString(rtProperties.bootDiskSizeGb()));
            currentWorkUnit.setProperty("workflowProperties", workflowPropertiesMap);
        }
    }

    @Override
    protected void addExtraDocsBindings(DocWorkUnit currentWorkUnit) {
    }
}

