/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocletUtils;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.utils.Utils;

public abstract class DocWorkUnitHandler {
    private final HelpDoclet doclet;

    public DocWorkUnitHandler(HelpDoclet doclet) {
        Utils.nonNull("Doclet cannot be null");
        this.doclet = doclet;
    }

    public HelpDoclet getDoclet() {
        return this.doclet;
    }

    public abstract void processWorkUnit(DocWorkUnit var1, List<Map<String, String>> var2, List<Map<String, String>> var3);

    public abstract String getTemplateName(DocWorkUnit var1);

    public String getDestinationFilename(DocWorkUnit workUnit) {
        return DocletUtils.phpFilenameForClass(workUnit.getClazz(), this.getDoclet().outputFileExtension);
    }

    public String getJSONFilename(DocWorkUnit workUnit) {
        return DocletUtils.phpFilenameForClass(workUnit.getClazz(), "json");
    }

    public String getSummaryForWorkUnit(DocWorkUnit workUnit) {
        return workUnit.getDocumentedFeature().summary();
    }

    public String getGroupNameForWorkUnit(DocWorkUnit workUnit) {
        return workUnit.getDocumentedFeature().groupName();
    }

    public String getGroupSummaryForWorkUnit(DocWorkUnit workUnit) {
        return workUnit.getDocumentedFeature().groupSummary();
    }
}

