/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.broadinstitute.barclay.help.DocumentedFeature;

public class DocletUtils {
    public static Class<?> getClassForDeclaredElement(Element docElement, DocletEnvironment docEnv, Reporter reporter) {
        return DocletUtils.getClassForClassName(DocletUtils.getClassName(docElement, docEnv), reporter);
    }

    public static Class<?> getClassForClassName(String className, Reporter reporter) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
        catch (IncompatibleClassChangeError e) {
            reporter.print(Diagnostic.Kind.WARNING, String.format("Unexpected class change error for class %s ignored: %s", e.getMessage(), className));
            return null;
        }
    }

    protected static String getClassName(Element element, DocletEnvironment docEnv) {
        PackageElement pe = docEnv.getElementUtils().getPackageOf(element);
        if (pe == null || !element.toString().contains(".")) {
            return element.toString();
        }
        String qualifiedName = pe.getQualifiedName().toString();
        String className = element.toString().substring(qualifiedName.length() + 1);
        String qualifiedClassName = className.replaceAll("\\.", "\\$");
        String s = String.format("%s.%s", pe.getQualifiedName(), qualifiedClassName);
        return s;
    }

    public static DocumentedFeature getDocumentedFeatureForClass(Class<?> clazz) {
        if (clazz != null && clazz.isAnnotationPresent(DocumentedFeature.class)) {
            return clazz.getAnnotation(DocumentedFeature.class);
        }
        return null;
    }

    public static String phpFilenameForClass(Class<?> c) {
        return DocletUtils.phpFilenameForClass(c, "php");
    }

    public static String phpFilenameForClass(Class<?> c, String extension) {
        return c.getName().replace(".", "_") + "." + extension;
    }
}

