/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.WDLWorkUnitHandler;

public class WDLDoclet
extends HelpDoclet {
    @Override
    public boolean includeInDocs(DocumentedFeature documentedFeature, Class<?> clazz) {
        if (super.includeInDocs(documentedFeature, clazz)) {
            boolean isCommandLineProgram;
            boolean hasWorkflowProperties = clazz.getAnnotation(WorkflowProperties.class) != null;
            boolean bl = isCommandLineProgram = clazz.getAnnotation(CommandLineProgramProperties.class) != null;
            if (hasWorkflowProperties) {
                if (!isCommandLineProgram) {
                    throw new DocException(String.format("WorkflowProperties can only be applied to classes that are annotated with CommandLineProgramProperties (%s)", clazz));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public DocWorkUnit createWorkUnit(Element classElement, Class<?> clazz, DocumentedFeature documentedFeature) {
        return this.includeInDocs(documentedFeature, clazz) ? new DocWorkUnit(new WDLWorkUnitHandler(this), classElement, clazz, documentedFeature) : null;
    }

    @Override
    protected void processWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
        try {
            Template wdlTemplate = cfg.getTemplate(workUnit.getTemplateName());
            File wdlOutputPath = new File(this.getDestinationDir(), workUnit.getTargetFileName());
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(wdlOutputPath));){
                wdlTemplate.process(workUnit.getRootMap(), (Writer)out);
            }
            Template jsonTemplate = cfg.getTemplate("wdlJSONTemplate.json.ftl");
            File jsonOutputPath = new File(this.getDestinationDir(), workUnit.getJSONFileName());
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(jsonOutputPath));){
                jsonTemplate.process(workUnit.getRootMap(), (Writer)out);
            }
        }
        catch (IOException e) {
            throw new DocException("IOException during documentation creation", e);
        }
        catch (TemplateException e) {
            throw new DocException("TemplateException during documentation creation", e);
        }
    }
}

