/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help.scanners;

import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementScanner14;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocletUtils;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.utils.Utils;

public class DocumentedFeatureScanner
extends ElementScanner14<Void, Void> {
    private final HelpDoclet helpDoclet;
    private final DocletEnvironment docEnv;
    private final Reporter reporter;
    private Set<DocWorkUnit> workUnits = new TreeSet<DocWorkUnit>();

    DocumentedFeatureScanner(HelpDoclet helpDoclet, DocletEnvironment docEnv, Reporter reporter) {
        Utils.nonNull(helpDoclet, "helpDoclet");
        Utils.nonNull(docEnv, "doclet environment");
        Utils.nonNull(reporter, "logger");
        this.helpDoclet = helpDoclet;
        this.docEnv = docEnv;
        this.reporter = reporter;
    }

    @Override
    public Void scan(Element e, Void unused) {
        Class<?> clazz;
        DocumentedFeature documentedFeature;
        if (e.asType().getKind().equals((Object)TypeKind.DECLARED) && (documentedFeature = DocletUtils.getDocumentedFeatureForClass(clazz = DocletUtils.getClassForDeclaredElement(e, this.docEnv, this.reporter))) != null) {
            if (documentedFeature.enable() && this.helpDoclet.includeInDocs(documentedFeature, clazz)) {
                DocWorkUnit workUnit = this.helpDoclet.createWorkUnit(e, clazz, documentedFeature);
                if (workUnit != null) {
                    this.workUnits.add(workUnit);
                }
            } else {
                this.reporter.print(Diagnostic.Kind.NOTE, "Skipping disabled documentation for feature: " + e);
            }
        }
        return (Void)super.scan(e, unused);
    }

    Set<DocWorkUnit> getWorkUnits() {
        return this.workUnits;
    }
}

