/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help.scanners;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.ElementFilter;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.scanners.CommentScanner;
import org.broadinstitute.barclay.help.scanners.CommentScannerWithTagFilter;
import org.broadinstitute.barclay.help.scanners.DocumentedFeatureScanner;
import org.broadinstitute.barclay.help.scanners.FieldScanner;
import org.broadinstitute.barclay.help.scanners.UnknownInlineTagScanner;
import org.broadinstitute.barclay.utils.Utils;

public class JavaLanguageModelScanners {
    private static final String EMPTY_COMMENT = "";

    public static Set<DocWorkUnit> getWorkUnits(HelpDoclet helpDoclet, DocletEnvironment docEnv, Reporter reporter, Set<? extends Element> includedElements) {
        Utils.nonNull(helpDoclet, "helps doclet");
        Utils.nonNull(docEnv, "doclet environment");
        Utils.nonNull(reporter, "reporter");
        Utils.nonNull(includedElements, "includedElements");
        DocumentedFeatureScanner documentedFeatureScanner = new DocumentedFeatureScanner(helpDoclet, docEnv, reporter);
        documentedFeatureScanner.scan(ElementFilter.typesIn(includedElements), null);
        return documentedFeatureScanner.getWorkUnits();
    }

    public static String getDocComment(DocletEnvironment docEnv, Element targetElement) {
        Utils.nonNull(docEnv, "doclet env");
        Utils.nonNull(targetElement, "target element");
        CommentScanner docScanner = new CommentScanner(docEnv, targetElement);
        DocCommentTree docTree = docEnv.getDocTrees().getDocCommentTree(targetElement);
        if (docTree == null) {
            return EMPTY_COMMENT;
        }
        docScanner.scan((DocTree)docTree, null);
        return docScanner.getComment();
    }

    public static String getDocCommentWithoutTags(DocletEnvironment docEnv, Element targetElement) {
        Utils.nonNull(docEnv, "doclet env");
        Utils.nonNull(targetElement, "targetElement");
        DocCommentTree docTree = docEnv.getDocTrees().getDocCommentTree(targetElement);
        if (docTree == null) {
            return EMPTY_COMMENT;
        }
        CommentScannerWithTagFilter docScanner = new CommentScannerWithTagFilter(docEnv, docTree);
        docScanner.scan((DocTree)docTree, null);
        return docScanner.getCommentWithoutTags();
    }

    public static String getDocCommentFirstSentence(DocletEnvironment docEnv, Element targetElement) {
        DocCommentTree docTree = docEnv.getDocTrees().getDocCommentTree(targetElement);
        StringBuilder sb = new StringBuilder();
        if (docTree != null) {
            docTree.getFirstSentence().forEach(t -> sb.append(t.toString()));
        }
        return sb.toString();
    }

    public static Element getElementForField(DocletEnvironment docEnv, Element enclosingClassElement, Field targetField, ElementKind targetElementKind) {
        Utils.nonNull(docEnv, "doclet environment");
        Utils.nonNull(enclosingClassElement, "enclosing element");
        Utils.nonNull(targetField, "target field");
        Utils.nonNull(targetElementKind, "target element kind");
        FieldScanner fieldScanner = new FieldScanner(docEnv, targetField.getName(), targetElementKind);
        fieldScanner.scan(enclosingClassElement);
        return fieldScanner.getFieldElement();
    }

    public static Map<String, List<String>> getUnknownInlineTags(DocletEnvironment docEnv, Element targetElement) {
        Utils.nonNull(docEnv, "doclet env");
        Utils.nonNull(targetElement, "targetElement");
        DocCommentTree docTree = docEnv.getDocTrees().getDocCommentTree(targetElement);
        if (docTree != null) {
            UnknownInlineTagScanner unknownInlineTagScanner = new UnknownInlineTagScanner(docEnv, docTree);
            unknownInlineTagScanner.scan((DocTree)docTree, null);
            return unknownInlineTagScanner.getInlineTags();
        }
        return new LinkedHashMap<String, List<String>>();
    }
}

