/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help.scanners;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.util.DocTreeScanner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.javadoc.doclet.DocletEnvironment;
import org.broadinstitute.barclay.utils.Utils;

public class UnknownInlineTagScanner
extends DocTreeScanner<Void, Void> {
    final DocTree docTree;
    final DocletEnvironment docEnv;
    private final Map<String, List<String>> inlineTags = new HashMap<String, List<String>>();

    UnknownInlineTagScanner(DocletEnvironment docEnv, DocTree docTree) {
        Utils.nonNull(docEnv, "doclet environment");
        Utils.nonNull(docTree, "docTree");
        this.docEnv = docEnv;
        this.docTree = docTree;
    }

    @Override
    public Void scan(DocTree t, Void unused) {
        Utils.nonNull(this.docTree, "DocTree");
        if (t.getKind().equals((Object)DocTree.Kind.UNKNOWN_INLINE_TAG)) {
            UnknownInlineTagTree tagTree = (UnknownInlineTagTree)t;
            List<String> tagParts = tagTree.getContent().stream().map(Object::toString).toList();
            this.inlineTags.put(tagTree.getTagName(), tagParts);
            return null;
        }
        return (Void)super.scan(t, null);
    }

    Map<String, List<String>> getInlineTags() {
        return this.inlineTags;
    }
}

