/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.bwa;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;
import org.broadinstitute.hellbender.utils.bwa.BwaMemPairEndStats;

public final class BwaMemAligner
implements AutoCloseable {
    private final BwaMemIndex index;
    private ByteBuffer opts;
    private BwaMemPairEndStats pairEndStats;
    public static final int MEM_F_PE = 2;
    public static final int MEM_F_NOPAIRING = 4;
    public static final int MEM_F_ALL = 8;
    public static final int MEM_F_NO_MULTI = 16;
    public static final int MEM_F_NO_RESCUE = 32;
    public static final int MEM_F_REF_HDR = 256;
    public static final int MEM_F_SOFTCLIP = 512;
    public static final int MEM_F_SMARTPE = 1024;
    public static final int MEM_F_PRIMARY5 = 2048;

    public BwaMemAligner(BwaMemIndex index) {
        this.index = index;
        if (!index.isOpen()) {
            throw new IllegalStateException("Can't create aligner: bwa-mem index has been closed");
        }
        this.opts = BwaMemIndex.createDefaultOptions();
        this.opts.order(ByteOrder.nativeOrder()).position(0).limit(this.opts.capacity());
        this.pairEndStats = null;
    }

    public boolean isOpen() {
        return this.opts != null;
    }

    @Override
    public void close() {
        if (this.opts != null) {
            BwaMemIndex.destroyByteBuffer(this.opts);
            this.opts = null;
        }
    }

    public int getMatchScoreOption() {
        return this.getOpts().getInt(0);
    }

    public void setMatchScoreOption(int a) {
        this.getOpts().putInt(0, a);
    }

    public int getMismatchPenaltyOption() {
        return this.getOpts().getInt(4);
    }

    public void setMismatchPenaltyOption(int b) {
        this.getOpts().putInt(4, b);
    }

    public int getDGapOpenPenaltyOption() {
        return this.getOpts().getInt(8);
    }

    public void setDGapOpenPenaltyOption(int o_del) {
        this.getOpts().putInt(8, o_del);
    }

    public int getDGapExtendPenaltyOption() {
        return this.getOpts().getInt(12);
    }

    public void setDGapExtendPenaltyOption(int e_del) {
        this.getOpts().putInt(12, e_del);
    }

    public int getIGapOpenPenaltyOption() {
        return this.getOpts().getInt(16);
    }

    public void setIGapOpenPenaltyOption(int o_ins) {
        this.getOpts().putInt(16, o_ins);
    }

    public int getIGapExtendPenaltyOption() {
        return this.getOpts().getInt(20);
    }

    public void setIGapExtendPenaltyOption(int e_ins) {
        this.getOpts().putInt(20, e_ins);
    }

    public int getUnpairedPenaltyOption() {
        return this.getOpts().getInt(24);
    }

    public void setUnpairedPenaltyOption(int pen_unpaired) {
        this.getOpts().putInt(24, pen_unpaired);
    }

    public int getClip5PenaltyOption() {
        return this.getOpts().getInt(28);
    }

    public void setClip5PenaltyOption(int pen_clip5) {
        this.getOpts().putInt(28, pen_clip5);
    }

    public int getClip3PenaltyOption() {
        return this.getOpts().getInt(32);
    }

    public void setClip3PenaltyOption(int pen_clip3) {
        this.getOpts().putInt(32, pen_clip3);
    }

    public int getBandwidthOption() {
        return this.getOpts().getInt(36);
    }

    public void setBandwidthOption(int w) {
        this.getOpts().putInt(36, w);
    }

    public int getZDropOption() {
        return this.getOpts().getInt(40);
    }

    public void setZDropOption(int zdrop) {
        this.getOpts().putInt(40, zdrop);
    }

    public long getMaxMemIntvOption() {
        return this.getOpts().getLong(48);
    }

    public void setMaxMemIntvOption(long max_mem_intv) {
        this.getOpts().putLong(48, max_mem_intv);
    }

    public int getOutputScoreThresholdOption() {
        return this.getOpts().getInt(56);
    }

    public void setOutputScoreThresholdOption(int T) {
        this.getOpts().putInt(56, T);
    }

    public void alignPairs() {
        this.setFlagOption(2 | this.getFlagOption());
    }

    public int getFlagOption() {
        return this.getOpts().getInt(60);
    }

    public void setFlagOption(int flag) {
        this.getOpts().putInt(60, flag);
    }

    public int getMinSeedLengthOption() {
        return this.getOpts().getInt(64);
    }

    public void setMinSeedLengthOption(int min_seed_len) {
        this.getOpts().putInt(64, min_seed_len);
    }

    public int getMinChainWeightOption() {
        return this.getOpts().getInt(68);
    }

    public void setMinChainWeightOption(int min_chain_weight) {
        this.getOpts().putInt(68, min_chain_weight);
    }

    public int getMaxChainExtendOption() {
        return this.getOpts().getInt(72);
    }

    public void setMaxChainExtendOption(int max_chain_extend) {
        this.getOpts().putInt(72, max_chain_extend);
    }

    public float getSplitFactorOption() {
        return this.getOpts().getFloat(76);
    }

    public void setSplitFactorOption(float split_factor) {
        this.getOpts().putFloat(76, split_factor);
    }

    public int getSplitWidthOption() {
        return this.getOpts().getInt(80);
    }

    public void setSplitWidthOption(int split_width) {
        this.getOpts().putInt(80, split_width);
    }

    public int getMaxSeedOccurencesOption() {
        return this.getOpts().getInt(84);
    }

    public void setMaxSeedOccurencesOption(int max_occ) {
        this.getOpts().putInt(84, max_occ);
    }

    public int getMaxChainGapOption() {
        return this.getOpts().getInt(88);
    }

    public void setMaxChainGapOption(int max_chain_gap) {
        this.getOpts().putInt(88, max_chain_gap);
    }

    public int getNThreadsOption() {
        return this.getOpts().getInt(92);
    }

    public void setNThreadsOption(int n_threads) {
        this.getOpts().putInt(92, n_threads);
    }

    public int getChunkSizeOption() {
        return this.getOpts().getInt(96);
    }

    public void setChunkSizeOption(int chunk_size) {
        this.getOpts().putInt(96, chunk_size);
    }

    public float getMaskLevelOption() {
        return this.getOpts().getFloat(100);
    }

    public void setMaxLevelOption(float max_level) {
        this.getOpts().putFloat(100, max_level);
    }

    public float getDropRatioOption() {
        return this.getOpts().getFloat(104);
    }

    public void setDropRatioOption(float drop_ratio) {
        this.getOpts().putFloat(104, drop_ratio);
    }

    public float getXADropRatio() {
        return this.getOpts().getFloat(108);
    }

    public void setXADropRatio(float XA_drop_ratio) {
        this.getOpts().putFloat(108, XA_drop_ratio);
    }

    public float getMaskLevelRedunOption() {
        return this.getOpts().getFloat(112);
    }

    public void setMaskLevelRedunOption(float max_level_redun) {
        this.getOpts().putFloat(112, max_level_redun);
    }

    public float getMapQCoefLenOption() {
        return this.getOpts().getFloat(116);
    }

    public void setMapQCoefLenOption(float mapQ_coef_len) {
        this.getOpts().putFloat(116, mapQ_coef_len);
    }

    public int getMapQCoefFacOption() {
        return this.getOpts().getInt(120);
    }

    public void setMapQCoefFacOption(int mapQ_coef_fac) {
        this.getOpts().putInt(120, mapQ_coef_fac);
    }

    public int getMaxInsOption() {
        return this.getOpts().getInt(124);
    }

    public void setMaxInsOption(int max_ins) {
        this.getOpts().putInt(124, max_ins);
    }

    public int getMaxMateSWOption() {
        return this.getOpts().getInt(128);
    }

    public void setMaxMateSWOption(int max_matesw) {
        this.getOpts().putInt(128, max_matesw);
    }

    public int getMaxXAHitsOption() {
        return this.getOpts().getInt(132);
    }

    public void setMaxXAHitsOption(int max_XA_hits) {
        this.getOpts().putInt(132, max_XA_hits);
    }

    public int getMaxXAHitsAltOption() {
        return this.getOpts().getInt(136);
    }

    public void setMaxXAHitsAltOption(int max_XA_hits_alt) {
        this.getOpts().putInt(136, max_XA_hits_alt);
    }

    public byte[] getScoringMatrixOption() {
        byte[] result = new byte[25];
        ByteBuffer tmpOpts = this.getOpts();
        tmpOpts.position(140);
        tmpOpts.get(result);
        return result;
    }

    public void setScoringMatrixOption(byte[] mat) {
        ByteBuffer tmpOpts = this.getOpts();
        tmpOpts.position(140);
        tmpOpts.put(mat);
    }

    int getExpectedOptsSize() {
        return 168;
    }

    int getOptsSize() {
        return this.getOpts().capacity();
    }

    public void setIntraCtgOptions() {
        this.setDGapOpenPenaltyOption(16);
        this.setIGapOpenPenaltyOption(16);
        this.setMismatchPenaltyOption(9);
        this.setClip5PenaltyOption(5);
        this.setClip3PenaltyOption(5);
    }

    public void inferPairEndStats() {
        this.pairEndStats = null;
    }

    public void dontInferPairEndStats() {
        this.pairEndStats = BwaMemPairEndStats.DO_NOT_INFER;
    }

    public void setProperPairEndStats(BwaMemPairEndStats stats) {
        this.pairEndStats = stats;
    }

    public BwaMemIndex getIndex() {
        return this.index;
    }

    public List<List<BwaMemAlignment>> alignSeqs(List<byte[]> sequences) {
        return this.alignSeqs(sequences, seq -> seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<List<BwaMemAlignment>> alignSeqs(Iterable<T> iterable, Function<T, byte[]> func) {
        ByteBuffer alignsBuf;
        ByteBuffer tmpOpts = this.getOpts();
        this.index.refIndex();
        int nSequences = 0;
        try {
            int bufferCapacity = 4;
            for (Object ele : iterable) {
                ++nSequences;
                bufferCapacity += func.apply(ele).length + 1;
            }
            ByteBuffer contigBuf = ByteBuffer.allocateDirect(bufferCapacity);
            contigBuf.order(ByteOrder.nativeOrder());
            contigBuf.putInt(nSequences);
            for (Object ele : iterable) {
                contigBuf.put(func.apply(ele)).put((byte)0);
            }
            contigBuf.flip();
            alignsBuf = this.index.doAlignment(contigBuf, tmpOpts, this.pairEndStats);
        }
        finally {
            this.index.deRefIndex();
        }
        alignsBuf.order(ByteOrder.nativeOrder()).position(0).limit(alignsBuf.capacity());
        ArrayList<List<BwaMemAlignment>> allAlignments = new ArrayList<List<BwaMemAlignment>>(nSequences);
        while (nSequences-- > 0) {
            int nAligns = alignsBuf.getInt();
            ArrayList<BwaMemAlignment> alignments = new ArrayList<BwaMemAlignment>(nAligns);
            while (nAligns-- > 0) {
                int templateLen;
                int mateStartPos;
                int mateRefId;
                String xaTag;
                String mdTag;
                int suboptimalScore;
                int alignerScore;
                int nMismatches;
                int seqEnd;
                int seqStart;
                int refEnd;
                int refStart;
                int refId;
                int flag_mapQ = alignsBuf.getInt();
                int flags = flag_mapQ >>> 16;
                int mapQual = flag_mapQ & 0xFF;
                StringBuilder cigar = new StringBuilder();
                if ((flags & 4) != 0) {
                    refId = -1;
                    refStart = -1;
                    refEnd = -1;
                    seqStart = -1;
                    seqEnd = -1;
                    nMismatches = 0;
                    alignerScore = 0;
                    suboptimalScore = 0;
                    mdTag = null;
                    xaTag = null;
                } else {
                    refId = alignsBuf.getInt();
                    refStart = alignsBuf.getInt();
                    nMismatches = alignsBuf.getInt();
                    alignerScore = alignsBuf.getInt();
                    suboptimalScore = alignsBuf.getInt();
                    int nCigarOps = alignsBuf.getInt();
                    String cigarOps = "MID?S???????????";
                    if (nCigarOps <= 0) {
                        seqStart = 0;
                        seqEnd = 0;
                        refEnd = refStart;
                    } else {
                        int refLen = 0;
                        int seqLen = 0;
                        int lenOp = alignsBuf.getInt();
                        int len = lenOp >>> 4;
                        char op = "MID?S???????????".charAt(lenOp & 0xF);
                        cigar.append(len);
                        cigar.append(op);
                        int n = seqStart = op == 'S' ? len : 0;
                        if (op == 'M' || op == 'D') {
                            refLen += len;
                        }
                        if (op == 'M' || op == 'I') {
                            seqLen += len;
                        }
                        while (--nCigarOps > 0) {
                            lenOp = alignsBuf.getInt();
                            len = lenOp >>> 4;
                            op = "MID?S???????????".charAt(lenOp & 0xF);
                            cigar.append(len);
                            cigar.append(op);
                            if (op == 'M' || op == 'D') {
                                refLen += len;
                            }
                            if (op != 'M' && op != 'I') continue;
                            seqLen += len;
                        }
                        refEnd = refStart + refLen;
                        seqEnd = seqStart + seqLen;
                    }
                    mdTag = this.getTag(alignsBuf);
                    xaTag = this.getTag(alignsBuf);
                }
                if ((flags & 1) == 0 || (flags & 8) != 0) {
                    mateRefId = -1;
                    mateStartPos = -1;
                    templateLen = 0;
                } else {
                    mateRefId = alignsBuf.getInt();
                    mateStartPos = alignsBuf.getInt();
                    templateLen = alignsBuf.getInt();
                }
                alignments.add(new BwaMemAlignment(flags, refId, refStart, refEnd, seqStart, seqEnd, mapQual, nMismatches, alignerScore, suboptimalScore, cigar.toString(), mdTag, xaTag, mateRefId, mateStartPos, templateLen));
            }
            allAlignments.add(alignments);
        }
        BwaMemIndex.destroyByteBuffer(alignsBuf);
        return allAlignments;
    }

    private String getTag(ByteBuffer buffer) {
        int tagLen = buffer.getInt();
        if (tagLen == 0) {
            return null;
        }
        byte[] tagBytes = new byte[tagLen + 3 & 0xFFFFFFFC];
        buffer.get(tagBytes);
        return new String(tagBytes, 0, tagLen);
    }

    private ByteBuffer getOpts() {
        if (this.opts == null) {
            throw new IllegalStateException("The aligner has been closed.");
        }
        return this.opts;
    }
}

