/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.bwa;

public final class BwaMemPairEndStats {
    public static final int DEFAULT_LOW_AND_HIGH_SIGMA = 4;
    public static final double DEFAULT_STD_TO_AVERAGE_RATIO = 0.1;
    public static final BwaMemPairEndStats FAILED;
    public static final BwaMemPairEndStats DO_NOT_INFER;
    public final int low;
    public final int high;
    public final boolean failed;
    public final double average;
    public final double std;

    public BwaMemPairEndStats(double average, double std) {
        this(average, std, Math.max(1, (int)Math.round(average - 4.0 * std)), Math.max(1, (int)Math.round(average + 4.0 * std)));
    }

    public BwaMemPairEndStats(double average) {
        this(average, average * 0.1);
    }

    public BwaMemPairEndStats(double average, double std, int low, int high) {
        if (Double.isNaN(average) || !Double.isFinite(average) || average < 1.0) {
            throw new IllegalArgumentException("invalid input average: " + average);
        }
        if (Double.isNaN(std) || !Double.isFinite(std) || std < 0.0) {
            throw new IllegalArgumentException("invalid std. err: " + std);
        }
        if ((double)low > average) {
            throw new IllegalArgumentException("the low limit cannot be larger than the average");
        }
        if ((double)high < average) {
            throw new IllegalArgumentException("the high limit cannot be larger than the average");
        }
        this.failed = false;
        this.average = average;
        this.std = std;
        this.high = high;
        this.low = low;
    }

    private BwaMemPairEndStats() {
        this.failed = true;
        this.average = Double.NaN;
        this.std = Double.NaN;
        this.low = Integer.MAX_VALUE;
        this.high = Integer.MIN_VALUE;
    }

    public String toString() {
        if (this.failed) {
            return "InsertSize ~ FAILED/DO_NOT_INFER";
        }
        return String.format("InsertSize ~ N(%.2f, %.2f) in [%d, %d]", this.average, this.std, this.low, this.high);
    }

    public boolean equals(Object other) {
        return other instanceof BwaMemPairEndStats && this.equals((BwaMemPairEndStats)other);
    }

    public int hashCode() {
        if (this.failed) {
            return 0;
        }
        return Double.hashCode(this.average) * 31 + Double.hashCode(this.std) * 31 + Integer.hashCode(this.low) * 31 + Integer.hashCode(this.high) * 31;
    }

    public boolean equals(BwaMemPairEndStats other) {
        if (other == null || this.failed != other.failed) {
            return false;
        }
        return this.failed || this.average == other.average && this.std == other.std && this.low == other.low && this.high == other.high;
    }

    static {
        DO_NOT_INFER = FAILED = new BwaMemPairEndStats();
    }
}

