/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.bwa;

import java.util.OptionalLong;
import org.broadinstitute.hellbender.utils.bwa.InvalidInputException;

public class InvalidFileFormatException
extends InvalidInputException {
    private final String file;
    private final OptionalLong line;

    public InvalidFileFormatException(String file, OptionalLong line, String message, Throwable cause) {
        super(InvalidFileFormatException.composeMessage(file, line, message), cause);
        this.file = file;
        this.line = line;
    }

    public InvalidFileFormatException(String file, String message, Throwable cause) {
        this(file, OptionalLong.empty(), message, cause);
    }

    public InvalidFileFormatException(String file, String message) {
        this(file, OptionalLong.empty(), null, null);
    }

    private static String composeMessage(String file, OptionalLong line, String message) {
        if (file == null) {
            throw new IllegalArgumentException("the input file cannot be null");
        }
        if (line.isPresent() && line.getAsLong() < 1L) {
            throw new IllegalArgumentException("the line number cannot be null");
        }
        String location = "file " + file + (line.isPresent() ? " (" + line.getAsLong() + ")" : "");
        String details = message == null ? ": invalid format" : ": " + message;
        return location + details;
    }

    public OptionalLong getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }
}

