/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.fermi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.function.Function;
import org.broadinstitute.hellbender.utils.fermi.FermiLiteAssembly;

public final class FermiLiteAssembler
implements AutoCloseable {
    private static volatile boolean nativeLibLoaded = false;
    private ByteBuffer opts;

    public FermiLiteAssembler() {
        FermiLiteAssembler.loadNativeLibrary();
        this.opts = FermiLiteAssembler.createDefaultOptions();
        if (this.opts == null) {
            throw new IllegalStateException("Unable to create default options.  Out of memory?");
        }
        this.opts.order(ByteOrder.nativeOrder()).position(0).limit(this.opts.capacity());
    }

    public boolean isOpen() {
        return this.opts != null;
    }

    @Override
    public void close() {
        if (this.opts != null) {
            FermiLiteAssembler.destroyByteBuffer(this.opts);
            this.opts = null;
        }
    }

    public int getNThreads() {
        return this.getOpts().getInt(0);
    }

    public void setNThreads(int nThreads) {
        this.getOpts().putInt(0, nThreads);
    }

    public int getECKSize() {
        return this.getOpts().getInt(4);
    }

    public void setECKSize(int kSize) {
        this.getOpts().putInt(4, kSize);
    }

    public int getMinCnt() {
        return this.getOpts().getInt(8);
    }

    public void setMinCnt(int minCnt) {
        this.getOpts().putInt(8, minCnt);
    }

    public int getMaxCnt() {
        return this.getOpts().getInt(12);
    }

    public void setMaxCnt(int maxCnt) {
        this.getOpts().putInt(12, maxCnt);
    }

    public int getMinAsmOverlap() {
        return this.getOpts().getInt(16);
    }

    public void setMinAsmOverlap(int minAsmOverlap) {
        this.getOpts().putInt(16, minAsmOverlap);
    }

    public int getMinMergeLen() {
        return this.getOpts().getInt(20);
    }

    public void setMinMergeLen(int minMergeLen) {
        this.getOpts().putInt(20, minMergeLen);
    }

    public int getCleaningFlag() {
        return this.getOpts().getInt(24);
    }

    public void setCleaningFlag(int cleaningFlag) {
        this.getOpts().putInt(24, cleaningFlag);
    }

    public int getCleaningMinOverlap() {
        return this.getOpts().getInt(28);
    }

    public void setCleaningMinOverlap(int minOverlap) {
        this.getOpts().putInt(28, minOverlap);
    }

    public int getCleaningELen() {
        return this.getOpts().getInt(32);
    }

    public void setCleaningELen(int eLen) {
        this.getOpts().putInt(32, eLen);
    }

    public int getCleaningMinEnsr() {
        return this.getOpts().getInt(36);
    }

    public void setCleaningMinEnsr(int minEnsr) {
        this.getOpts().putInt(36, minEnsr);
    }

    public int getCleaningMinInsr() {
        return this.getOpts().getInt(40);
    }

    public void setCleaningMinInsr(int minInsr) {
        this.getOpts().putInt(40, minInsr);
    }

    public int getCleaningMaxBDist() {
        return this.getOpts().getInt(44);
    }

    public void setCleaningMaxBDist(int maxBDist) {
        this.getOpts().putInt(44, maxBDist);
    }

    public int getCleaningMaxBDiff() {
        return this.getOpts().getInt(48);
    }

    public void setCleaningMaxBDiff(int maxBDiff) {
        this.getOpts().putInt(48, maxBDiff);
    }

    public int getCleaningMaxBVtx() {
        return this.getOpts().getInt(52);
    }

    public void setCleaningMaxBVtx(int maxBVtx) {
        this.getOpts().putInt(52, maxBVtx);
    }

    public int getCleaningMinMergeLen() {
        return this.getOpts().getInt(56);
    }

    public void setCleaningMinMergeLen(int minMergeLen) {
        this.getOpts().putInt(56, minMergeLen);
    }

    public int getCleaningTrimLen() {
        return this.getOpts().getInt(60);
    }

    public void setCleaningTrimLen(int trimLen) {
        this.getOpts().putInt(60, trimLen);
    }

    public int getCleaningTrimDepth() {
        return this.getOpts().getInt(64);
    }

    public void setCleaningTrimDepth(int trimDepth) {
        this.getOpts().putInt(64, trimDepth);
    }

    public float getCleaningDRatio1() {
        return this.getOpts().getFloat(68);
    }

    public void setCleaningDRatio1(float dRatio1) {
        this.getOpts().putFloat(68, dRatio1);
    }

    public float getCleaningMaxBCov() {
        return this.getOpts().getFloat(72);
    }

    public void setCleaningMaxBCov(float maxBCov) {
        this.getOpts().putFloat(72, maxBCov);
    }

    public float getCleaningMaxBFrac() {
        return this.getOpts().getFloat(76);
    }

    public void setCleaningMaxBFrac(float maxBFrac) {
        this.getOpts().putFloat(76, maxBFrac);
    }

    int getExpectedOptsSize() {
        return 80;
    }

    int getOptsSize() {
        return this.getOpts().capacity();
    }

    public FermiLiteAssembly createAssembly(Iterable<? extends BasesAndQuals> basesAndQuals) {
        return this.createAssembly(basesAndQuals, bAndQ -> bAndQ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FermiLiteAssembly createAssembly(Iterable<T> reads, Function<T, BasesAndQuals> func) {
        ByteBuffer tmpOpts = this.getOpts();
        ByteBuffer assemblyData = FermiLiteAssembler.createAssemblyData(tmpOpts, FermiLiteAssembler.makeReadData(reads, func));
        if (assemblyData == null) {
            throw new IllegalStateException("Unable to create assembly. Out of memory?");
        }
        try {
            FermiLiteAssembly fermiLiteAssembly = FermiLiteAssembler.interpretAssemblyData(assemblyData);
            return fermiLiteAssembly;
        }
        finally {
            FermiLiteAssembler.destroyByteBuffer(assemblyData);
        }
    }

    public static String getFermiLiteVersion() {
        FermiLiteAssembler.loadNativeLibrary();
        return FermiLiteAssembler.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadNativeLibrary() {
        if (nativeLibLoaded) return;
        Class<FermiLiteAssembler> clazz = FermiLiteAssembler.class;
        synchronized (FermiLiteAssembler.class) {
            if (nativeLibLoaded) return;
            String libNameOverride = System.getProperty("LIBFML_PATH");
            if (libNameOverride != null) {
                System.load(libNameOverride);
            } else {
                String libName;
                String osName = System.getProperty("os.name", "unknown").toUpperCase();
                String osArch = System.getProperty("os.arch");
                if (!"x86_64".equals(osArch) && !"amd64".equals(osArch)) {
                    throw new IllegalStateException("We have pre-built fermi-lite binaries only for x86_64 and amd64.  Your os.arch is " + osArch + "." + "Set property LIBFML_PATH to point to a native library for your architecture.");
                }
                if (osName.startsWith("MAC")) {
                    libName = "/libfml.Darwin.dylib";
                } else {
                    if (!osName.startsWith("LINUX")) throw new IllegalStateException("We have pre-built fermi-lite binaries only for Linux and Mac.  Your os.name is " + osName + "." + "Set property LIBFML_PATH to point to a native library for your operating system.");
                    libName = "/libfml.Linux.so";
                }
                try (InputStream is = FermiLiteAssembler.class.getResourceAsStream(libName);){
                    if (is == null) {
                        throw new IllegalStateException("Can't find resource " + libName);
                    }
                    File tmpFile = File.createTempFile("libfml.", ".jnilib");
                    tmpFile.deleteOnExit();
                    Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    System.load(tmpFile.getPath());
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Misconfiguration: Unable to load fermi-lite native library " + libName, ioe);
                }
            }
            nativeLibLoaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static <T> ByteBuffer makeReadData(Iterable<T> reads, Function<T, BasesAndQuals> func) {
        int nReads = 0;
        int capacity = 4;
        for (T read : reads) {
            ++nReads;
            capacity += 2 * (func.apply(read).getBases().length + 1);
        }
        ByteBuffer readData = ByteBuffer.allocateDirect(capacity);
        readData.order(ByteOrder.nativeOrder());
        readData.putInt(nReads);
        for (T read : reads) {
            BasesAndQuals bAndQ = func.apply(read);
            readData.put(bAndQ.getBases()).put((byte)0);
            readData.put(bAndQ.getQuals()).put((byte)0);
        }
        readData.flip();
        return readData;
    }

    private static FermiLiteAssembly interpretAssemblyData(ByteBuffer assemblyData) {
        int idx;
        assemblyData.order(ByteOrder.nativeOrder()).position(0).limit(assemblyData.capacity());
        int nContigs = assemblyData.getInt();
        int seqOffset = assemblyData.getInt();
        ArrayList<FermiLiteAssembly.Contig> contigs = new ArrayList<FermiLiteAssembly.Contig>(nContigs);
        for (idx = 0; idx != nContigs; ++idx) {
            int seqLen = assemblyData.getInt();
            int nSupportingReads = assemblyData.getInt();
            int nConnections = assemblyData.getInt();
            int mark = assemblyData.position() + 8 * nConnections;
            assemblyData.position(seqOffset);
            byte[] seq = new byte[seqLen];
            assemblyData.get(seq);
            byte[] coverage = new byte[seqLen];
            assemblyData.get(coverage);
            contigs.add(new FermiLiteAssembly.Contig(seq, coverage, nSupportingReads));
            assemblyData.position(mark);
            seqOffset += 2 * seqLen;
        }
        assemblyData.position(8);
        for (idx = 0; idx != nContigs; ++idx) {
            FermiLiteAssembly.Contig contig = (FermiLiteAssembly.Contig)contigs.get(idx);
            assemblyData.getInt();
            assemblyData.getInt();
            int nConnections = assemblyData.getInt();
            ArrayList<FermiLiteAssembly.Connection> connections = new ArrayList<FermiLiteAssembly.Connection>(nConnections);
            while (nConnections-- > 0) {
                int overlapLen = assemblyData.getInt();
                boolean isSrc3Prime = overlapLen < 0;
                int contigId = assemblyData.getInt();
                boolean isTarget3Prime = contigId < 0;
                connections.add(new FermiLiteAssembly.Connection((FermiLiteAssembly.Contig)contigs.get(contigId &= Integer.MAX_VALUE), overlapLen &= Integer.MAX_VALUE, !isSrc3Prime, isTarget3Prime));
            }
            contig.setConnections(connections);
        }
        return new FermiLiteAssembly(contigs);
    }

    private ByteBuffer getOpts() {
        if (this.opts == null) {
            throw new IllegalStateException("The assembler has been closed.");
        }
        return this.opts;
    }

    private static native ByteBuffer createDefaultOptions();

    private static native ByteBuffer createAssemblyData(ByteBuffer var0, ByteBuffer var1);

    private static native void destroyByteBuffer(ByteBuffer var0);

    private static native String getVersion();

    public static interface BasesAndQuals {
        public byte[] getBases();

        public byte[] getQuals();
    }
}

