/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.fermi;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class FermiLiteAssembly {
    private final List<Contig> contigs;

    public FermiLiteAssembly(List<Contig> contigs) {
        this.contigs = Collections.unmodifiableList(contigs);
    }

    public int getNContigs() {
        return this.contigs.size();
    }

    public Contig getContig(int idx) {
        return this.contigs.get(idx);
    }

    public List<Contig> getContigs() {
        return this.contigs;
    }

    public void writeGFA(Writer writer) throws IOException {
        HashMap<Contig, Integer> idMap = new HashMap<Contig, Integer>((int)((long)this.contigs.size() * 4L / 3L) + 1);
        int id = 0;
        for (Contig contig : this.contigs) {
            idMap.put(contig, id++);
        }
        writer.write("H\tVN:Z:1.0\n");
        for (Contig contig : this.contigs) {
            int contigId = (Integer)idMap.get(contig);
            writer.write("S\ttig" + contigId + "\t" + new String(contig.getSequence()) + "\tLN:i:" + contig.getSequence().length + "\tRC:i:" + contig.getNSupportingReads() + "\n");
            for (Connection connection : contig.getConnections()) {
                int targetId = (Integer)idMap.get(connection.getTarget());
                if (contigId > targetId) continue;
                int overlapLen = connection.getOverlapLen();
                writer.write("L\ttig" + contigId + "\t" + (connection.isRC() ? "-" : "+") + "\ttig" + targetId + "\t" + (connection.isTargetRC() ? "-" : "+") + "\t" + (overlapLen < 0 ? -overlapLen + "H" : overlapLen + "M") + "\n");
            }
        }
    }

    public static final class Connection {
        private final Contig target;
        private final int overlapLen;
        private final boolean isRC;
        private final boolean isTargetRC;

        public Connection(Contig target, int overlapLen, boolean isRC, boolean isTargetRC) {
            this.target = target;
            this.overlapLen = overlapLen;
            this.isRC = isRC;
            this.isTargetRC = isTargetRC;
        }

        public Contig getTarget() {
            return this.target;
        }

        public int getOverlapLen() {
            return this.overlapLen;
        }

        public boolean isRC() {
            return this.isRC;
        }

        public boolean isTargetRC() {
            return this.isTargetRC;
        }

        public Connection rcConnection(Contig contig) {
            return new Connection(contig, this.overlapLen, !this.isTargetRC, !this.isRC);
        }
    }

    public static final class Contig {
        private final byte[] sequence;
        private final byte[] perBaseCoverage;
        private final int nSupportingReads;
        private List<Connection> connections;

        public Contig(byte[] sequence, byte[] perBaseCoverage, int nSupportingReads) {
            this.sequence = sequence;
            this.perBaseCoverage = perBaseCoverage;
            this.nSupportingReads = nSupportingReads;
            this.connections = Collections.emptyList();
        }

        public byte[] getSequence() {
            return this.sequence;
        }

        public byte[] getPerBaseCoverage() {
            return this.perBaseCoverage;
        }

        public int getNSupportingReads() {
            return this.nSupportingReads;
        }

        public List<Connection> getConnections() {
            return this.connections;
        }

        public void setConnections(List<Connection> connections) {
            this.connections = Collections.unmodifiableList(connections);
        }

        public Connection getSolePredecessor() {
            return this.getSingletonConnection(true);
        }

        public Connection getSoleSuccessor() {
            return this.getSingletonConnection(false);
        }

        public Connection getSingletonConnection(boolean isRC) {
            Connection singleton = null;
            for (Connection conn : this.connections) {
                if (conn.isRC() != isRC) continue;
                if (singleton != null) {
                    return null;
                }
                singleton = conn;
            }
            return singleton;
        }
    }
}

