/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.BinaryCigarCodec;
import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.SortingCollection;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class SAMRecordSparkCodec
implements SortingCollection.Codec<SAMRecord> {
    private final BinaryCodec binaryCodec = new BinaryCodec();
    private final BinaryTagCodec binaryTagCodec = new BinaryTagCodec(this.binaryCodec);
    private final SAMRecordFactory samRecordFactory;

    public SAMRecordSparkCodec() {
        this((SAMRecordFactory)new DefaultSAMRecordFactory());
    }

    public SAMRecordSparkCodec(SAMRecordFactory factory) {
        this.samRecordFactory = factory;
    }

    public SAMRecordSparkCodec clone() {
        return new SAMRecordSparkCodec(this.samRecordFactory);
    }

    public void setOutputStream(OutputStream os) {
        this.binaryCodec.setOutputStream(os);
    }

    public void setOutputStream(OutputStream os, String filename) {
        this.binaryCodec.setOutputStream(os);
        this.binaryCodec.setOutputFileName(filename);
    }

    public void setInputStream(InputStream is) {
        this.binaryCodec.setInputStream(is);
    }

    public void setInputStream(InputStream is, String filename) {
        this.binaryCodec.setInputStream(is);
        this.binaryCodec.setInputFileName(filename);
    }

    public void encode(SAMRecord alignment) {
        int readLength = alignment.getReadLength();
        int cigarLength = alignment.getCigarLength();
        int blockSize = 32 + alignment.getReadNameLength() + 1 + cigarLength * 4 + (readLength + 1) / 2 + readLength;
        int attributesSize = alignment.getAttributesBinarySize();
        if (attributesSize != -1) {
            blockSize += attributesSize;
        } else {
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                blockSize += BinaryTagCodec.getTagSize((Object)attribute.value);
            }
        }
        this.binaryCodec.writeInt(blockSize);
        this.binaryCodec.writeInt(-1);
        this.binaryCodec.writeInt(alignment.getAlignmentStart() - 1);
        this.binaryCodec.writeUByte((short)(alignment.getReadNameLength() + 1));
        this.binaryCodec.writeUByte((short)alignment.getMappingQuality());
        this.binaryCodec.writeUShort(0);
        this.binaryCodec.writeUShort(cigarLength);
        this.binaryCodec.writeUShort(alignment.getFlags());
        this.binaryCodec.writeInt(alignment.getReadLength());
        this.binaryCodec.writeInt(-1);
        this.binaryCodec.writeInt(alignment.getMateAlignmentStart() - 1);
        this.binaryCodec.writeInt(alignment.getInferredInsertSize());
        byte[] variableLengthBinaryBlock = alignment.getVariableBinaryRepresentation();
        if (variableLengthBinaryBlock != null) {
            this.binaryCodec.writeBytes(variableLengthBinaryBlock);
        } else {
            int[] binaryCigar;
            if (alignment.getReadLength() != alignment.getBaseQualities().length && alignment.getBaseQualities().length != 0) {
                throw new RuntimeException("Mismatch between read length and quals length writing read " + alignment.getReadName() + "; read length: " + alignment.getReadLength() + "; quals length: " + alignment.getBaseQualities().length);
            }
            this.binaryCodec.writeString(alignment.getReadName(), false, true);
            for (int cigarElement : binaryCigar = BinaryCigarCodec.encode((Cigar)alignment.getCigar())) {
                this.binaryCodec.writeInt(cigarElement);
            }
            this.binaryCodec.writeBytes(SAMUtils.bytesToCompressedBases((byte[])alignment.getReadBases()));
            byte[] qualities = alignment.getBaseQualities();
            if (qualities.length == 0) {
                qualities = new byte[alignment.getReadLength()];
                Arrays.fill(qualities, (byte)-1);
            }
            this.binaryCodec.writeBytes(qualities);
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                this.binaryTagCodec.writeTag(attribute.tag, attribute.value, attribute.isUnsignedArray());
            }
        }
    }

    public SAMRecord decode() {
        int recordLength = 0;
        try {
            recordLength = this.binaryCodec.readInt();
        }
        catch (RuntimeEOFException e) {
            return null;
        }
        if (recordLength < 32) {
            throw new SAMFormatException("Invalid record length: " + recordLength);
        }
        int referenceID = this.binaryCodec.readInt();
        int coordinate = this.binaryCodec.readInt() + 1;
        short readNameLength = this.binaryCodec.readUByte();
        short mappingQuality = this.binaryCodec.readUByte();
        int bin = this.binaryCodec.readUShort();
        int cigarLen = this.binaryCodec.readUShort();
        int flags = this.binaryCodec.readUShort();
        int readLen = this.binaryCodec.readInt();
        int mateReferenceID = this.binaryCodec.readInt();
        int mateCoordinate = this.binaryCodec.readInt() + 1;
        int insertSize = this.binaryCodec.readInt();
        byte[] restOfRecord = new byte[recordLength - 32];
        this.binaryCodec.readBytes(restOfRecord);
        BAMRecord ret = this.samRecordFactory.createBAMRecord(null, referenceID, coordinate, readNameLength, mappingQuality, bin, cigarLen, flags, readLen, mateReferenceID, mateCoordinate, insertSize, restOfRecord);
        return ret;
    }
}

