/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender;

import com.google.cloud.storage.StorageException;
import htsjdk.samtools.util.StringUtil;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.ClassFinder;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramGroup;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineArgumentValidator;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.DeprecatedToolsRegistry;
import org.broadinstitute.hellbender.cmdline.PicardCommandLineProgramExecutor;
import org.broadinstitute.hellbender.exceptions.PicardNonZeroExitException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.ClassUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.runtime.RuntimeUtils;

public class Main {
    private static final String KNRM = "\u001b[0m";
    private static final String RED = "\u001b[31m";
    private static final String GREEN = "\u001b[32m";
    private static final String CYAN = "\u001b[36m";
    private static final String WHITE = "\u001b[37m";
    private static final String BOLDRED = "\u001b[1m\u001b[31m";
    private static final int COMMANDLINE_EXCEPTION_EXIT_VALUE = 1;
    public static final int USER_EXCEPTION_EXIT_VALUE = 2;
    public static final int PICARD_TOOL_EXCEPTION = 4;
    private static final int ANY_OTHER_EXCEPTION_EXIT_VALUE = 3;
    private static final String STACK_TRACE_ON_USER_EXCEPTION_PROPERTY = "GATK_STACKTRACE_ON_USER_EXCEPTION";
    private static final int HELP_SIMILARITY_FLOOR = 7;
    private static final int MINIMUM_SUBSTRING_LENGTH = 5;

    protected static void printDecoratedExceptionMessage(PrintStream ps, Exception e, String prefix) {
        Utils.nonNull(ps, "stream");
        Utils.nonNull(e, "exception");
        ps.println("***********************************************************************");
        ps.println();
        ps.println(prefix + e.getMessage());
        ps.println();
        ps.println("***********************************************************************");
    }

    protected List<String> getPackageList() {
        ArrayList<String> packageList = new ArrayList<String>();
        packageList.addAll(Arrays.asList("org.broadinstitute.hellbender"));
        packageList.addAll(Arrays.asList("picard"));
        return packageList;
    }

    protected void parseArgsForConfigSetup(String[] args) {
        ConfigFactory.getInstance().initializeConfigurationsFromCommandLineArgs(args, "--gatk-config-file");
    }

    protected List<Class<? extends CommandLineProgram>> getClassList() {
        return Collections.emptyList();
    }

    protected String getCommandLineName() {
        return "";
    }

    public Object instanceMain(String[] args, List<String> packageList, List<Class<? extends CommandLineProgram>> classList, String commandLineName) {
        CommandLineProgram program = this.setupConfigAndExtractProgram(args, packageList, classList, commandLineName);
        return Main.runCommandLineProgram(program, args);
    }

    protected static Object runCommandLineProgram(CommandLineProgram program, String[] rawArgs) {
        if (null == program) {
            return null;
        }
        String[] mainArgs = Arrays.copyOfRange(rawArgs, 1, rawArgs.length);
        return program.instanceMain(mainArgs);
    }

    protected CommandLineProgram setupConfigAndExtractProgram(String[] args, List<String> packageList, List<Class<? extends CommandLineProgram>> classList, String commandLineName) {
        this.parseArgsForConfigSetup(args);
        return this.extractCommandLineProgram(args, packageList, classList, commandLineName);
    }

    public Object instanceMain(String[] args) {
        return this.instanceMain(args, this.getPackageList(), this.getClassList(), this.getCommandLineName());
    }

    protected final void mainEntry(String[] args) {
        CommandLineProgram program = null;
        try {
            program = this.setupConfigAndExtractProgram(args, this.getPackageList(), this.getClassList(), this.getCommandLineName());
            Object result = Main.runCommandLineProgram(program, args);
            this.handleResult(result);
        }
        catch (CommandLineException e) {
            if (program != null) {
                System.err.println(program.getUsage());
            }
            this.handleUserException((Exception)((Object)e));
            System.exit(1);
        }
        catch (PicardNonZeroExitException e) {
            this.handleResult(e.getToolReturnCode());
            System.exit(4);
        }
        catch (UserException e) {
            this.handleUserException(e);
            System.exit(2);
        }
        catch (StorageException e) {
            this.handleStorageException(e);
            System.exit(3);
        }
        catch (Exception e) {
            this.handleNonUserException(e);
            System.exit(3);
        }
    }

    protected void handleResult(Object result) {
        if (result != null) {
            System.out.println("Tool returned:\n" + result);
        }
    }

    protected void handleUserException(Exception e) {
        Main.printDecoratedExceptionMessage(System.err, e, "A USER ERROR has occurred: ");
        if (Main.printStackTraceOnUserExceptions()) {
            e.printStackTrace();
        } else {
            System.err.println(String.format("Set the system property %s (--java-options '-D%s=true') to print the stack trace.", STACK_TRACE_ON_USER_EXCEPTION_PROPERTY, STACK_TRACE_ON_USER_EXCEPTION_PROPERTY));
        }
    }

    protected void handleNonUserException(Exception exception) {
        exception.printStackTrace();
    }

    protected void handleStorageException(StorageException exception) {
        System.err.println("code:      " + exception.getCode());
        System.err.println("message:   " + exception.getMessage());
        System.err.println("reason:    " + exception.getReason());
        System.err.println("location:  " + exception.getLocation());
        System.err.println("retryable: " + exception.isRetryable());
        exception.printStackTrace();
    }

    public static void main(String[] args) {
        new Main().mainEntry(args);
    }

    private static boolean printStackTraceOnUserExceptions() {
        return "true".equals(System.getenv(STACK_TRACE_ON_USER_EXCEPTION_PROPERTY)) || Boolean.getBoolean(STACK_TRACE_ON_USER_EXCEPTION_PROPERTY);
    }

    private CommandLineProgram extractCommandLineProgram(String[] args, List<String> packageList, List<Class<? extends CommandLineProgram>> classList, String commandLineName) {
        ClassFinder classFinder = new ClassFinder();
        for (String pkg : packageList) {
            classFinder.find(pkg, picard.cmdline.CommandLineProgram.class);
            classFinder.find(pkg, CommandLineProgram.class);
        }
        String missingAnnotationClasses = "";
        Set toCheck = classFinder.getClasses();
        toCheck.addAll(classList);
        LinkedHashMap<String, Class> simpleNameToClass = new LinkedHashMap<String, Class>();
        for (Class clazz : toCheck) {
            if (clazz.equals(PicardCommandLineProgramExecutor.class) || clazz.equals(CommandLineArgumentValidator.class) || !ClassUtils.canMakeInstances(clazz)) continue;
            CommandLineProgramProperties property = Main.getProgramProperty(clazz);
            if (null == property) {
                if (missingAnnotationClasses.isEmpty()) {
                    missingAnnotationClasses = missingAnnotationClasses + clazz.getSimpleName();
                    continue;
                }
                missingAnnotationClasses = missingAnnotationClasses + ", " + clazz.getSimpleName();
                continue;
            }
            if (simpleNameToClass.containsKey(clazz.getSimpleName())) {
                throw new RuntimeException("Simple class name collision: " + clazz.getName());
            }
            simpleNameToClass.put(clazz.getSimpleName(), clazz);
        }
        if (!missingAnnotationClasses.isEmpty()) {
            throw new RuntimeException("The following classes are missing the required CommandLineProgramProperties annotation: " + missingAnnotationClasses);
        }
        LinkedHashSet classes = new LinkedHashSet();
        classes.addAll(simpleNameToClass.values());
        if (args.length < 1 || args[0].equals("-h") || args[0].equals("--help")) {
            this.printUsage(System.out, classes, commandLineName);
        } else if (Arrays.stream(args).anyMatch(arg -> arg.equals("-version") || arg.equals("--version"))) {
            this.printVersionInfo(System.out);
        } else {
            if (simpleNameToClass.containsKey(args[0])) {
                Class clazz;
                clazz = (Class)simpleNameToClass.get(args[0]);
                try {
                    Object commandLineProgram = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    return commandLineProgram instanceof picard.cmdline.CommandLineProgram ? new PicardCommandLineProgramExecutor((picard.cmdline.CommandLineProgram)commandLineProgram) : (CommandLineProgram)commandLineProgram;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.printUsage(System.err, classes, commandLineName);
            throw new UserException(this.getUnknownCommandMessage(classes, args[0]));
        }
        return null;
    }

    public static CommandLineProgramProperties getProgramProperty(Class<?> clazz) {
        return clazz.getAnnotation(CommandLineProgramProperties.class);
    }

    private void printUsage(PrintStream destinationStream, Set<Class<?>> classes, String commandLineName) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[1m\u001b[31mUSAGE: " + commandLineName + " " + GREEN + "<program name>" + BOLDRED + " [-h]\n\n" + KNRM).append("\u001b[1m\u001b[31mAvailable Programs:\n\u001b[0m");
        LinkedHashMap<Class, CommandLineProgramGroup> programGroupClassToProgramGroupInstance = new LinkedHashMap<Class, CommandLineProgramGroup>();
        TreeMap programsByGroup = new TreeMap(CommandLineProgramGroup.comparator);
        LinkedHashMap programsToProperty = new LinkedHashMap();
        for (Class<?> clazz : classes) {
            ArrayList programs;
            CommandLineProgramProperties property = Main.getProgramProperty(clazz);
            if (null == property) {
                throw new RuntimeException(String.format("The class '%s' is missing the required CommandLineProgramProperties annotation.", clazz.getSimpleName()));
            }
            if (property.omitFromCommandLine()) continue;
            programsToProperty.put(clazz, property);
            CommandLineProgramGroup programGroup = (CommandLineProgramGroup)programGroupClassToProgramGroupInstance.get(property.programGroup());
            if (null == programGroup) {
                try {
                    programGroup = (CommandLineProgramGroup)property.programGroup().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                programGroupClassToProgramGroupInstance.put(property.programGroup(), programGroup);
            }
            if (null == (programs = (ArrayList)programsByGroup.get(programGroup))) {
                programs = new ArrayList();
                programsByGroup.put(programGroup, programs);
            }
            programs.add(clazz);
        }
        for (Map.Entry entry : programsByGroup.entrySet()) {
            CommandLineProgramGroup programGroup = (CommandLineProgramGroup)entry.getKey();
            builder.append("\u001b[37m--------------------------------------------------------------------------------------\n\u001b[0m");
            builder.append(String.format("%s%-48s %-45s%s\n", RED, programGroup.getName() + ":", programGroup.getDescription(), KNRM));
            ArrayList sortedClasses = new ArrayList();
            sortedClasses.addAll((Collection)entry.getValue());
            Collections.sort(sortedClasses, new SimpleNameComparator());
            for (Class clazz : sortedClasses) {
                CommandLineProgramProperties clpProperties = (CommandLineProgramProperties)programsToProperty.get(clazz);
                if (null == clpProperties) {
                    throw new RuntimeException(String.format("Unexpected error: did not find the CommandLineProgramProperties annotation for '%s'", clazz.getSimpleName()));
                }
                builder.append(this.getDisplaySummaryForTool(clazz, clpProperties));
            }
            builder.append(String.format("\n", new Object[0]));
        }
        builder.append("\u001b[37m--------------------------------------------------------------------------------------\n\u001b[0m");
        destinationStream.println(builder.toString());
    }

    protected String getDisplaySummaryForTool(Class<?> toolClass, CommandLineProgramProperties clpProperties) {
        BetaFeature betaFeature = toolClass.getAnnotation(BetaFeature.class);
        ExperimentalFeature experimentalFeature = toolClass.getAnnotation(ExperimentalFeature.class);
        StringBuilder builder = new StringBuilder();
        String summaryLine = experimentalFeature != null ? String.format("%s%s %s%s", RED, "(EXPERIMENTAL Tool)", CYAN, clpProperties.oneLineSummary()) : (betaFeature != null ? String.format("%s%s %s%s", RED, "(BETA Tool)", CYAN, clpProperties.oneLineSummary()) : String.format("%s%s", CYAN, clpProperties.oneLineSummary()));
        String annotatedToolName = this.getDisplayNameForToolClass(toolClass);
        if (toolClass.getSimpleName().length() >= 45) {
            builder.append(String.format("%s    %s    %s%s\n", GREEN, annotatedToolName, summaryLine, KNRM));
        } else {
            builder.append(String.format("%s    %-45s%s%s\n", GREEN, annotatedToolName, summaryLine, KNRM));
        }
        return builder.toString();
    }

    protected String getDisplayNameForToolClass(Class<?> clazz) {
        return RuntimeUtils.toolDisplayName(clazz);
    }

    public String getToolDeprecationMessage(String toolName) {
        return DeprecatedToolsRegistry.getToolDeprecationInfo(toolName);
    }

    public String getUnknownCommandMessage(Set<Class<?>> classes, String command) {
        String deprecationMessage = this.getToolDeprecationMessage(command);
        if (deprecationMessage != null) {
            return deprecationMessage;
        }
        return this.getSuggestedAlternateCommand(classes, command);
    }

    public String getSuggestedAlternateCommand(Set<Class<?>> classes, String command) {
        LinkedHashMap distances = new LinkedHashMap();
        int bestDistance = Integer.MAX_VALUE;
        int bestN = 0;
        for (Class<?> clazz : classes) {
            String name = clazz.getSimpleName();
            if (name.equals(command)) {
                throw new RuntimeException("Command matches: " + command);
            }
            int distance = name.startsWith(command) || 5 <= command.length() && name.contains(command) ? 0 : StringUtil.levenshteinDistance((String)command, (String)name, (int)0, (int)2, (int)1, (int)4);
            distances.put(clazz, distance);
            if (distance < bestDistance) {
                bestDistance = distance;
                bestN = 1;
                continue;
            }
            if (distance != bestDistance) continue;
            ++bestN;
        }
        if (0 == bestDistance && bestN == classes.size()) {
            bestDistance = 8;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("'%s' is not a valid command.", command));
        message.append(System.lineSeparator());
        if (bestDistance < 7) {
            message.append(String.format("Did you mean %s?", bestN < 2 ? "this" : "one of these"));
            message.append(System.lineSeparator());
            for (Class<?> clazz : classes) {
                if (bestDistance != (Integer)distances.get(clazz)) continue;
                message.append(String.format("        %s", clazz.getSimpleName()));
            }
        }
        return message.toString();
    }

    protected void printVersionInfo(PrintStream out) {
        String toolkitName = RuntimeUtils.getToolkitName(this.getClass());
        String version = RuntimeUtils.getVersion(this.getClass());
        System.out.println(String.format("%s v%s", toolkitName, version));
        Manifest manifest = RuntimeUtils.getManifest(this.getClass());
        if (manifest != null) {
            Attributes manifestAttributes = manifest.getMainAttributes();
            String htsjdkVersion = manifestAttributes.getValue("htsjdk-Version");
            String picardVersion = manifestAttributes.getValue("Picard-Version");
            out.println("HTSJDK Version: " + (htsjdkVersion != null ? htsjdkVersion : "unknown"));
            out.println("Picard Version: " + (picardVersion != null ? picardVersion : "unknown"));
        }
    }

    static {
        Utils.forceJVMLocaleToUSEnglish();
        System.setProperty("picard.useLegacyParser", "false");
    }

    private static class SimpleNameComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 1096632824580028876L;

        private SimpleNameComparator() {
        }

        @Override
        public int compare(Class<?> aClass, Class<?> bClass) {
            return RuntimeUtils.toolDisplayName(aClass).compareTo(RuntimeUtils.toolDisplayName(bClass));
        }
    }
}

