/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intel.gkl.compression.IntelDeflaterFactory;
import com.intel.gkl.compression.IntelInflaterFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.metrics.StringHeader;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockGunzipper;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.zip.DeflaterFactory;
import htsjdk.samtools.util.zip.InflaterFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLinePluginProvider;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.argparser.SpecialArgumentsCollection;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.LoggingUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.runtime.RuntimeUtils;

public abstract class CommandLineProgram
implements CommandLinePluginProvider {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private static final String DEFAULT_TOOLKIT_SHORT_NAME = "GATK";
    @Argument(fullName="tmp-dir", common=true, optional=true, doc="Temp directory to use.")
    public GATKPath tmpDir;
    @ArgumentCollection(doc="Special Arguments that have meaning to the argument parsing system.  It is unlikely these will ever need to be accessed by the command line program")
    public SpecialArgumentsCollection specialArgumentsCollection = new SpecialArgumentsCollection();
    @Argument(fullName="verbosity", shortName="verbosity", doc="Control verbosity of logging.", common=true, optional=true)
    public Log.LogLevel VERBOSITY = Log.LogLevel.INFO;
    @Argument(fullName="QUIET", doc="Whether to suppress job-summary info on System.err.", common=true)
    public Boolean QUIET = false;
    @Argument(fullName="use-jdk-deflater", shortName="jdk-deflater", doc="Whether to use the JdkDeflater (as opposed to IntelDeflater)", common=true)
    public boolean useJdkDeflater = false;
    @Argument(fullName="use-jdk-inflater", shortName="jdk-inflater", doc="Whether to use the JdkInflater (as opposed to IntelInflater)", common=true)
    public boolean useJdkInflater = false;
    @Argument(fullName="gcs-max-retries", shortName="gcs-retries", doc="If the GCS bucket channel errors out, how many times it will attempt to re-initiate the connection", optional=true)
    public int NIO_MAX_REOPENS = ConfigFactory.getInstance().getGATKConfig().gcsMaxRetries();
    @Argument(fullName="gcs-project-for-requester-pays", doc="Project to bill when accessing \"requester pays\" buckets. If unset, these buckets cannot be accessed.  User must have storage.buckets.get permission on the bucket being accessed.", optional=true)
    public String NIO_PROJECT_FOR_REQUESTER_PAYS = ConfigFactory.getInstance().getGATKConfig().gcsProjectForRequesterPays();
    @Argument(fullName="gatk-config-file", doc="A configuration file to use with the GATK.", common=true, optional=true)
    public String GATK_CONFIG_FILE = null;
    private CommandLineParser commandLineParser;
    private final List<Header> defaultHeaders = new ArrayList<Header>();
    private String commandLine;

    protected void onStartup() {
    }

    protected abstract Object doWork();

    protected void onShutdown() {
    }

    public final Object runTool() {
        try {
            this.logger.info("Initializing engine");
            this.onStartup();
            this.logger.info("Done initializing engine");
            Object object = this.doWork();
            return object;
        }
        finally {
            this.logger.info("Shutting down engine");
            this.onShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceMainPostParseArgs() {
        if (this.tmpDir == null) {
            this.tmpDir = new GATKPath(System.getProperty("java.io.tmpdir"));
        }
        ZonedDateTime startDateTime = ZonedDateTime.now();
        this.defaultHeaders.add((Header)new StringHeader(this.commandLine));
        this.defaultHeaders.add((Header)new StringHeader("Started on: " + Utils.getDateTimeForDisplay(startDateTime)));
        LoggingUtils.setLoggingLevel(this.VERBOSITY);
        Path p = this.tmpDir.toPath();
        try {
            p.getFileSystem().provider().checkAccess(p, AccessMode.READ, AccessMode.WRITE);
            System.setProperty("java.io.tmpdir", IOUtils.getAbsolutePathWithoutFileProtocol(p));
        }
        catch (AccessDeniedException | NoSuchFileException e) {
            throw new UserException.BadTempDir(p, "should exist and have read/write access", e);
        }
        catch (IOException e) {
            throw new UserException.BadTempDir(p, e.getMessage(), e);
        }
        if (!this.useJdkDeflater) {
            BlockCompressedOutputStream.setDefaultDeflaterFactory((DeflaterFactory)new IntelDeflaterFactory());
        }
        if (!this.useJdkInflater) {
            BlockGunzipper.setDefaultInflaterFactory((InflaterFactory)new IntelInflaterFactory());
        }
        BucketUtils.setGlobalNIODefaultOptions(this.NIO_MAX_REOPENS, this.NIO_PROJECT_FOR_REQUESTER_PAYS);
        if (!this.QUIET.booleanValue()) {
            this.printStartupMessage(startDateTime);
        }
        this.warnOnToolStatus();
        try {
            Object object = this.runTool();
            return object;
        }
        finally {
            if (!this.QUIET.booleanValue()) {
                ZonedDateTime endDateTime = ZonedDateTime.now();
                double elapsedMinutes = (double)Duration.between(startDateTime, endDateTime).toMillis() / 60000.0;
                String elapsedString = new DecimalFormat("#,##0.00").format(elapsedMinutes);
                System.err.println("[" + Utils.getDateTimeForDisplay(endDateTime) + "] " + this.getClass().getName() + " done. Elapsed time: " + elapsedString + " minutes.");
                System.err.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
            }
        }
    }

    public Object instanceMain(String[] argv) {
        if (!this.parseArgs(argv)) {
            return 0;
        }
        return this.instanceMainPostParseArgs();
    }

    protected String[] customCommandLineValidation() {
        return null;
    }

    protected final boolean parseArgs(String[] argv) {
        boolean ret = this.getCommandLineParser().parseArguments(System.err, argv);
        this.commandLine = this.getCommandLineParser().getCommandLine();
        if (!ret) {
            return false;
        }
        String[] customErrorMessages = this.customCommandLineValidation();
        if (customErrorMessages != null) {
            throw new CommandLineException("Command Line Validation failed:" + Arrays.stream(customErrorMessages).collect(Collectors.joining(", ")));
        }
        return true;
    }

    public List<? extends CommandLinePluginDescriptor<?>> getPluginDescriptors() {
        return new ArrayList();
    }

    protected <A extends MetricBase, B extends Comparable<?>> MetricsFile<A, B> getMetricsFile() {
        MetricsFile file = new MetricsFile();
        for (Header h : this.defaultHeaders) {
            file.addHeader(h);
        }
        return file;
    }

    protected void printStartupMessage(ZonedDateTime startDateTime) {
        try {
            this.logger.info(Utils.dupChar('-', 60));
            this.logger.info(String.format("%s v%s", this.getToolkitName(), this.getVersion()));
            this.logger.info(this.getSupportInformation());
            this.logger.info(String.format("Executing as %s@%s on %s v%s %s", System.getProperty("user.name"), InetAddress.getLocalHost().getHostName(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
            this.logger.info(String.format("Java runtime: %s v%s", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version")));
            this.logger.info("Start Date/Time: " + Utils.getDateTimeForDisplay(startDateTime));
            this.logger.info(Utils.dupChar('-', 60));
            this.logger.info(Utils.dupChar('-', 60));
            this.printLibraryVersions();
            this.printSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getToolStatusWarning(boolean useTerminalColor) {
        String KNRM = "\u001b[0m";
        String BOLDRED = "\u001b[1m\u001b[31m";
        int BORDER_LENGTH = 60;
        String warningMessage = null;
        if (this.isBetaFeature()) {
            warningMessage = String.format("\n\n%s   %s\n\n   Warning: %s is a BETA tool and is not yet ready for use in production\n\n   %s%s\n\n", useTerminalColor ? BOLDRED : "", Utils.dupChar('!', 60), this.getClass().getSimpleName(), Utils.dupChar('!', 60), useTerminalColor ? KNRM : "");
        } else if (this.isExperimentalFeature()) {
            warningMessage = String.format("\n\n%s   %s\n\n   Warning: %s is an EXPERIMENTAL tool and should not be used for production\n\n   %s%s\n\n", useTerminalColor ? BOLDRED : "", Utils.dupChar('!', 60), this.getClass().getSimpleName(), Utils.dupChar('!', 60), useTerminalColor ? KNRM : "");
        }
        return warningMessage;
    }

    protected void warnOnToolStatus() {
        String warningMessage = this.getToolStatusWarning(true);
        if (warningMessage != null) {
            this.logger.warn(warningMessage);
        }
    }

    public boolean isBetaFeature() {
        return this.getClass().getAnnotation(BetaFeature.class) != null;
    }

    public boolean isExperimentalFeature() {
        return this.getClass().getAnnotation(ExperimentalFeature.class) != null;
    }

    protected String getToolkitName() {
        return RuntimeUtils.getToolkitName(this.getClass());
    }

    protected String getToolkitShortName() {
        Manifest manifest = RuntimeUtils.getManifest(this.getClass());
        if (manifest != null) {
            return manifest.getMainAttributes().getValue("Toolkit-Short-Name");
        }
        return DEFAULT_TOOLKIT_SHORT_NAME;
    }

    public String getVersion() {
        return RuntimeUtils.getVersion(this.getClass());
    }

    protected String getSupportInformation() {
        return "For support and documentation go to https://software.broadinstitute.org/gatk/";
    }

    protected void printLibraryVersions() {
        Manifest manifest = RuntimeUtils.getManifest(this.getClass());
        if (manifest != null) {
            Attributes manifestAttributes = manifest.getMainAttributes();
            String htsjdkVersion = manifestAttributes.getValue("htsjdk-Version");
            String picardVersion = manifestAttributes.getValue("Picard-Version");
            String sparkVersion = manifestAttributes.getValue("Spark-Version");
            this.logger.info("HTSJDK Version: " + (htsjdkVersion != null ? htsjdkVersion : "unknown"));
            this.logger.info("Picard Version: " + (picardVersion != null ? picardVersion : "unknown"));
            this.logger.info("Built for Spark Version: " + (sparkVersion != null ? sparkVersion : "unknown"));
        }
    }

    protected void printSettings() {
        if (this.VERBOSITY != Log.LogLevel.DEBUG) {
            this.logger.info("HTSJDK Defaults.COMPRESSION_LEVEL : " + Defaults.COMPRESSION_LEVEL);
            this.logger.info("HTSJDK Defaults.USE_ASYNC_IO_READ_FOR_SAMTOOLS : " + Defaults.USE_ASYNC_IO_READ_FOR_SAMTOOLS);
            this.logger.info("HTSJDK Defaults.USE_ASYNC_IO_WRITE_FOR_SAMTOOLS : " + Defaults.USE_ASYNC_IO_WRITE_FOR_SAMTOOLS);
            this.logger.info("HTSJDK Defaults.USE_ASYNC_IO_WRITE_FOR_TRIBBLE : " + Defaults.USE_ASYNC_IO_WRITE_FOR_TRIBBLE);
        } else {
            Defaults.allDefaults().forEach((key, value) -> this.logger.info("HTSJDK " + Defaults.class.getSimpleName() + "." + key + " : " + value));
        }
        ConfigFactory.logConfigFields(ConfigFactory.getInstance().getGATKConfig(), Log.LogLevel.DEBUG);
        boolean usingIntelDeflater = BlockCompressedOutputStream.getDefaultDeflaterFactory() instanceof IntelDeflaterFactory && ((IntelDeflaterFactory)BlockCompressedOutputStream.getDefaultDeflaterFactory()).usingIntelDeflater();
        this.logger.info("Deflater: " + (usingIntelDeflater ? "IntelDeflater" : "JdkDeflater"));
        boolean usingIntelInflater = BlockGunzipper.getDefaultInflaterFactory() instanceof IntelInflaterFactory && ((IntelInflaterFactory)BlockGunzipper.getDefaultInflaterFactory()).usingIntelInflater();
        this.logger.info("Inflater: " + (usingIntelInflater ? "IntelInflater" : "JdkInflater"));
        this.logger.info("GCS max retries/reopens: " + BucketUtils.getCloudStorageConfiguration(this.NIO_MAX_REOPENS, "").maxChannelReopens());
        if (Strings.isNullOrEmpty((String)this.NIO_PROJECT_FOR_REQUESTER_PAYS)) {
            this.logger.info("Requester pays: disabled");
        } else {
            this.logger.info("Requester pays: enabled. Billed to: " + this.NIO_PROJECT_FOR_REQUESTER_PAYS);
        }
    }

    public final String getCommandLine() {
        return this.commandLine;
    }

    public final String getUsage() {
        return this.getCommandLineParser().usage(true, this.specialArgumentsCollection.SHOW_HIDDEN);
    }

    public final void setDefaultHeaders(List<Header> headers) {
        Utils.nonNull(headers);
        this.defaultHeaders.clear();
        this.defaultHeaders.addAll(headers);
    }

    public final List<Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @VisibleForTesting
    public final CommandLineParser getCommandLineParser() {
        if (this.commandLineParser == null) {
            this.commandLineParser = new CommandLineArgumentParser((Object)this, this.getPluginDescriptors(), Collections.emptySet());
        }
        return this.commandLineParser;
    }
}

