/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline.GATKPlugin;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.DefaultGATKVariantAnnotationArgumentCollection;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKAnnotationArgumentCollection;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.PedigreeAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.config.GATKConfig;

public class GATKAnnotationPluginDescriptor
extends CommandLinePluginDescriptor<Annotation> {
    private static final List<String> PLUGIN_PACKAGE_NAMES;
    private static final Class<?> PLUGIN_BASE_CLASS;
    protected transient Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @ArgumentCollection
    private final GATKAnnotationArgumentCollection userArgs;
    private final Map<String, Annotation> allDiscoveredAnnotations = new HashMap<String, Annotation>();
    private final Map<String, Annotation> toolDefaultAnnotations = new HashMap<String, Annotation>();
    private final Set<String> toolDefaultGroups = new HashSet<String>();
    private final Set<String> requiredPredecessors = new HashSet<String>();
    private final Map<String, Map<String, Annotation>> discoveredGroups = new HashMap<String, Map<String, Annotation>>();
    private List<Annotation> resolvedInstances;
    @Argument(fullName="founder-id", shortName="founder-id", doc="Samples representing the population \"founders\"", optional=true)
    private List<String> founderIds;
    @Argument(fullName="pedigree", shortName="ped", doc="Pedigree file for determining the population \"founders\"", optional=true)
    private GATKPath pedigreeFile;

    public Class<?> getPluginBaseClass() {
        return PLUGIN_BASE_CLASS;
    }

    public List<String> getPackageNames() {
        return PLUGIN_PACKAGE_NAMES;
    }

    public GATKAnnotationPluginDescriptor(GATKAnnotationArgumentCollection userArgs, List<Annotation> toolDefaultAnnotations, List<Class<? extends Annotation>> toolDefaultGroups) {
        this.userArgs = userArgs;
        if (null != toolDefaultAnnotations) {
            toolDefaultAnnotations.forEach(f -> {
                Class<?> annotClass = f.getClass();
                String className = annotClass.getSimpleName();
                if (className.length() == 0) {
                    className = annotClass.getName();
                }
                this.populateAnnotationGroups(className, (Annotation)f);
                this.toolDefaultAnnotations.put(className, (Annotation)f);
            });
        }
        if (null != toolDefaultGroups) {
            toolDefaultGroups.forEach(a -> {
                if (!a.isInterface() || a == Annotation.class) {
                    throw new GATKException(String.format("Tool specified annotation group %s is not a valid annotation group, must be an interface extending Annotation", a.getSimpleName()));
                }
                this.toolDefaultGroups.add(a.getSimpleName());
            });
        }
    }

    public GATKAnnotationPluginDescriptor(List<Annotation> toolDefaultAnnotations, List<Class<? extends Annotation>> toolDefaultGroups) {
        this(new DefaultGATKVariantAnnotationArgumentCollection(), toolDefaultAnnotations, toolDefaultGroups);
    }

    public boolean includePluginClass(Class<?> c) {
        return !c.getName().equals(this.getPluginBaseClass().getName()) && !Modifier.isAbstract(c.getModifiers()) && !c.getName().contains("UnitTest$");
    }

    public String getDisplayName() {
        return "annotation";
    }

    public Annotation createInstanceForPlugin(Class<?> pluggableClass) throws IllegalAccessException, InstantiationException {
        Annotation annot = null;
        String simpleName = pluggableClass.getSimpleName();
        if (this.allDiscoveredAnnotations.containsKey(simpleName)) {
            throw new IllegalArgumentException(String.format("A plugin class name collision was detected (%s/%s). Simple names of plugin classes must be unique across packages.", pluggableClass.getName(), this.allDiscoveredAnnotations.get(simpleName).getClass().getName()));
        }
        annot = this.toolDefaultAnnotations.containsKey(simpleName) ? this.toolDefaultAnnotations.get(simpleName) : (Annotation)pluggableClass.newInstance();
        this.allDiscoveredAnnotations.put(simpleName, annot);
        this.populateAnnotationGroups(simpleName, annot);
        return annot;
    }

    private void populateAnnotationGroups(String simpleName, Annotation annot) {
        LinkedList interfaces = new LinkedList();
        Collections.addAll(interfaces, annot.getClass().getInterfaces());
        while (!interfaces.isEmpty()) {
            Class inter = (Class)interfaces.poll();
            if (inter == PLUGIN_BASE_CLASS || !PLUGIN_BASE_CLASS.isAssignableFrom(inter)) continue;
            HashMap<String, Annotation> groupIdentity = this.discoveredGroups.containsKey(inter.getSimpleName()) ? this.discoveredGroups.get(inter.getSimpleName()) : new HashMap<String, Annotation>();
            groupIdentity.putIfAbsent(simpleName, annot);
            this.discoveredGroups.put(inter.getSimpleName(), groupIdentity);
            Collections.addAll(interfaces, inter.getInterfaces());
        }
    }

    public Set<String> getAllowedValuesForDescriptorHelp(String longArgName) {
        if (longArgName.equals("annotation")) {
            return this.allDiscoveredAnnotations.keySet();
        }
        if (longArgName.equals("annotations-to-exclude")) {
            Set<String> annotations = this.toolDefaultGroups.stream().map(k -> this.discoveredGroups.get(k).keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
            annotations.addAll(this.toolDefaultAnnotations.keySet());
            return annotations;
        }
        if (longArgName.equals("annotation-group")) {
            return this.discoveredGroups.keySet();
        }
        return null;
    }

    public boolean isDependentArgumentAllowed(Class<?> predecessorClass) {
        boolean isAllowed;
        String predecessorName = predecessorClass.getSimpleName();
        boolean bl = isAllowed = this.userArgs.getUserEnabledAnnotationNames().contains(predecessorName) || this.toolDefaultAnnotations.get(predecessorName) != null;
        if (!isAllowed) {
            isAllowed = Stream.of(this.userArgs.getUserEnabledAnnotationGroups(), this.toolDefaultGroups).flatMap(Collection::stream).anyMatch(group -> this.discoveredGroups.containsKey(group) && this.discoveredGroups.get(group).keySet().stream().anyMatch(s -> s.equals(predecessorName)));
        }
        if (isAllowed) {
            this.requiredPredecessors.add(predecessorName);
        }
        return isAllowed;
    }

    public void validateAndResolvePlugins() throws CommandLineException {
        block10: {
            block9: {
                Set<String> duplicateUserEnabledAnnotationNames = Utils.getDuplicatedItems(this.userArgs.getUserEnabledAnnotationNames());
                if (!duplicateUserEnabledAnnotationNames.isEmpty()) {
                    throw new CommandLineException.BadArgumentValue(String.format("The annotation(s) are enabled more than once: %s", Utils.join(", ", duplicateUserEnabledAnnotationNames)));
                }
                Set<String> duplicateDisabledUserAnnotationNames = Utils.getDuplicatedItems(this.userArgs.getUserDisabledAnnotationNames());
                if (!duplicateDisabledUserAnnotationNames.isEmpty()) {
                    throw new CommandLineException.BadArgumentValue(String.format("The annotation(s) are disabled more than once: %s", Utils.join(", ", duplicateDisabledUserAnnotationNames)));
                }
                HashSet<String> enabledAndDisabled = new HashSet<String>(this.userArgs.getUserEnabledAnnotationNames());
                enabledAndDisabled.retainAll(this.userArgs.getUserDisabledAnnotationNames());
                if (!enabledAndDisabled.isEmpty()) {
                    String badAnnotationList = Utils.join(", ", enabledAndDisabled);
                    throw new CommandLineException(String.format("The annotation(s): %s are both enabled and disabled", badAnnotationList));
                }
                this.userArgs.getUserDisabledAnnotationNames().forEach(s -> {
                    if (!this.allDiscoveredAnnotations.containsKey(s)) {
                        throw new CommandLineException.BadArgumentValue(String.format("Disabled annotation (%s) does not exist", s));
                    }
                    if (!this.toolDefaultAnnotations.containsKey(s)) {
                        this.logger.warn(String.format("Disabled annotation (%s) is not enabled by this tool", s));
                    }
                });
                HashSet<String> redundantAnnots = new HashSet<String>(this.toolDefaultAnnotations.keySet());
                redundantAnnots.retainAll(this.userArgs.getUserEnabledAnnotationNames());
                redundantAnnots.forEach(s -> this.logger.warn(String.format("Redundant enabled annotation (%s) is enabled for this tool by default", s)));
                HashSet<String> redundantGroups = new HashSet<String>(this.toolDefaultGroups);
                redundantGroups.retainAll(this.userArgs.getUserEnabledAnnotationGroups());
                redundantGroups.forEach(s -> this.logger.warn(String.format("Redundant enabled annotation group (%s) is enabled for this tool by default", s)));
                this.userArgs.getUserDisabledAnnotationNames().forEach(s -> {
                    if (this.requiredPredecessors.contains(s)) {
                        String message = String.format("Values were supplied for (%s) that is also disabled", s);
                        if (this.toolDefaultAnnotations.containsKey(s)) {
                            this.logger.warn(message);
                        } else {
                            throw new CommandLineException(message);
                        }
                    }
                });
                this.userArgs.getUserEnabledAnnotationNames().forEach(s -> {
                    Annotation ta = this.allDiscoveredAnnotations.get(s);
                    if (null == ta && !this.toolDefaultAnnotations.containsKey(s)) {
                        throw new CommandLineException("Unrecognized annotation name: " + s);
                    }
                });
                this.userArgs.getUserEnabledAnnotationGroups().forEach(s -> {
                    if (!this.discoveredGroups.containsKey(s)) {
                        throw new CommandLineException("Unrecognized annotation group name: " + s);
                    }
                });
                for (String group : this.toolDefaultGroups) {
                    for (Annotation annot : this.discoveredGroups.get(group).values()) {
                        this.toolDefaultAnnotations.put(annot.getClass().getSimpleName(), annot);
                    }
                }
                if (this.founderIds != null && !this.founderIds.isEmpty()) break block9;
                if (this.pedigreeFile == null) break block10;
            }
            if (this.getResolvedInstances().stream().filter(PedigreeAnnotation.class::isInstance).map(a -> (PedigreeAnnotation)a).peek(a -> {
                if (!this.founderIds.isEmpty()) {
                    a.setFounderIds(this.founderIds);
                }
                if (this.pedigreeFile != null) {
                    a.setPedigreeFile(this.pedigreeFile);
                }
                a.validateArguments();
            }).count() == 0L) {
                Object[] objectArray = new Object[3];
                objectArray[0] = "pedigree";
                objectArray[1] = "founder-id";
                objectArray[2] = this.allDiscoveredAnnotations.values().stream().filter(PedigreeAnnotation.class::isInstance).map(a -> a.getClass().getSimpleName()).collect(Collectors.joining(", "));
                throw new CommandLineException(String.format("Pedigree argument \"%s\" or \"%s\" was specified without a pedigree annotation being requested, (eg: %s))", objectArray));
            }
        }
    }

    public List<Annotation> getDefaultInstances() {
        return new ArrayList<Annotation>(this.toolDefaultAnnotations.values());
    }

    public List<Annotation> getResolvedInstances() {
        if (this.resolvedInstances == null) {
            TreeSet<Annotation> annotations = new TreeSet<Annotation>(Comparator.comparing(t -> t.getClass().getSimpleName()));
            if (!this.userArgs.getDisableToolDefaultAnnotations()) {
                annotations.addAll(this.toolDefaultAnnotations.values());
            }
            for (String group : this.userArgs.getUserEnabledAnnotationGroups()) {
                annotations.addAll(this.discoveredGroups.get(group).values());
            }
            if (this.userArgs.getEnableAllAnnotations()) {
                annotations.addAll(this.allDiscoveredAnnotations.values());
            } else {
                for (String annotation : this.userArgs.getUserEnabledAnnotationNames()) {
                    annotations.add(this.allDiscoveredAnnotations.get(annotation));
                }
            }
            this.resolvedInstances = annotations.stream().filter(t -> !this.userArgs.getUserDisabledAnnotationNames().contains(t.getClass().getSimpleName())).collect(Collectors.toList());
        }
        return this.resolvedInstances;
    }

    public Class<?> getClassForPluginHelp(String pluginName) {
        return this.allDiscoveredAnnotations.containsKey(pluginName) ? this.allDiscoveredAnnotations.get(pluginName).getClass() : null;
    }

    static {
        GATKConfig config = ConfigFactory.getInstance().getGATKConfig();
        PLUGIN_PACKAGE_NAMES = Collections.unmodifiableList(config.annotation_packages());
        PLUGIN_BASE_CLASS = Annotation.class;
    }
}

