/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline.GATKPlugin;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.DefaultGATKReadFilterArgumentCollection;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKReadFilterArgumentCollection;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.config.GATKConfig;

public class GATKReadFilterPluginDescriptor
extends CommandLinePluginDescriptor<ReadFilter> {
    protected transient Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private static final List<String> PLUGIN_PACKAGE_NAMES;
    private static final Class<ReadFilter> pluginBaseClass;
    private static final String READ_PLUGIN_DISPLAY_NAME = "readFilter";
    @ArgumentCollection
    @VisibleForTesting
    final GATKReadFilterArgumentCollection userArgs;
    private final Map<String, ReadFilter> allDiscoveredReadFilters = new HashMap<String, ReadFilter>();
    private final Map<String, ReadFilter> toolDefaultReadFilters = new LinkedHashMap<String, ReadFilter>();
    private final Set<String> requiredPredecessors = new HashSet<String>();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    public GATKReadFilterPluginDescriptor(GATKReadFilterArgumentCollection userArgs, List<ReadFilter> toolDefaultFilters) {
        this.userArgs = userArgs;
        if (null != toolDefaultFilters) {
            toolDefaultFilters.forEach(f -> {
                Class<?> rfClass = f.getClass();
                String className = rfClass.getSimpleName();
                if (className.length() == 0) {
                    className = rfClass.getName();
                }
                this.toolDefaultReadFilters.put(className, (ReadFilter)f);
            });
        }
    }

    public GATKReadFilterPluginDescriptor(List<ReadFilter> toolDefaultFilters) {
        this(new DefaultGATKReadFilterArgumentCollection(), toolDefaultFilters);
    }

    public String getDisplayName() {
        return READ_PLUGIN_DISPLAY_NAME;
    }

    public Class<ReadFilter> getPluginBaseClass() {
        return pluginBaseClass;
    }

    public List<String> getPackageNames() {
        return PLUGIN_PACKAGE_NAMES;
    }

    public boolean includePluginClass(Class<?> c) {
        return !c.getName().equals(this.getPluginBaseClass().getName()) && !c.getName().startsWith(CountingReadFilter.class.getName()) && !c.getName().startsWith(this.getPluginBaseClass().getName() + "$") && !c.getName().contains("UnitTest$");
    }

    public ReadFilter createInstanceForPlugin(Class<?> pluggableClass) throws IllegalAccessException, InstantiationException {
        ReadFilter readFilter = null;
        String simpleName = pluggableClass.getSimpleName();
        if (this.allDiscoveredReadFilters.containsKey(simpleName)) {
            throw new IllegalArgumentException(String.format("A plugin class name collision was detected (%s/%s). Simple names of plugin classes must be unique across packages.", pluggableClass.getName(), this.allDiscoveredReadFilters.get(simpleName).getClass().getName()));
        }
        readFilter = this.toolDefaultReadFilters.containsKey(simpleName) ? this.toolDefaultReadFilters.get(simpleName) : (ReadFilter)pluggableClass.newInstance();
        this.allDiscoveredReadFilters.put(simpleName, readFilter);
        return readFilter;
    }

    public boolean isDependentArgumentAllowed(Class<?> predecessorClass) {
        boolean isAllowed;
        String predecessorName = predecessorClass.getSimpleName();
        boolean bl = isAllowed = this.userArgs.getUserEnabledReadFilterNames().contains(predecessorName) || this.toolDefaultReadFilters.get(predecessorName) != null;
        if (isAllowed) {
            this.requiredPredecessors.add(predecessorName);
        }
        return isAllowed;
    }

    public List<ReadFilter> getResolvedInstances() {
        ArrayList<ReadFilter> finalFilters = this.userArgs.getDisableToolDefaultReadFilters() ? new ArrayList<ReadFilter>(this.userArgs.getUserEnabledReadFilterNames().size()) : this.toolDefaultReadFilters.entrySet().stream().filter(e -> !this.isDisabledFilter((String)e.getKey())).map(e -> (ReadFilter)e.getValue()).collect(Collectors.toList());
        List<ReadFilter> userEnabledFilters = this.getUserEnabledInstances();
        if (userEnabledFilters != null) {
            userEnabledFilters.stream().filter(f -> !finalFilters.contains(f)).forEach(f -> finalFilters.add((ReadFilter)f));
        }
        return finalFilters;
    }

    private List<ReadFilter> getUserEnabledInstances() {
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>(this.userArgs.getUserEnabledReadFilterNames().size());
        this.userArgs.getUserEnabledReadFilterNames().forEach(s -> {
            ReadFilter rf = this.allDiscoveredReadFilters.get(s);
            filters.add(rf);
        });
        return filters;
    }

    public List<ReadFilter> getDefaultInstances() {
        return new ArrayList<ReadFilter>(this.toolDefaultReadFilters.values());
    }

    public Set<String> getAllowedValuesForDescriptorHelp(String longArgName) {
        if (longArgName.equals("read-filter")) {
            return this.allDiscoveredReadFilters.keySet();
        }
        if (longArgName.equals("disable-read-filter")) {
            return this.toolDefaultReadFilters.keySet();
        }
        return null;
    }

    public Class<?> getClassForPluginHelp(String pluginName) {
        if (this.allDiscoveredReadFilters.get(pluginName) != null) {
            return this.allDiscoveredReadFilters.get(pluginName).getClass();
        }
        throw new IllegalArgumentException(String.format("Can't resolve ReadFilter plugin for name %s", pluginName));
    }

    public void validateAndResolvePlugins() {
        Set<String> duplicateUserEnabledFilterNames = Utils.getDuplicatedItems(this.userArgs.getUserEnabledReadFilterNames());
        if (!duplicateUserEnabledFilterNames.isEmpty()) {
            throw new CommandLineException.BadArgumentValue(String.format("The read filter(s) are enabled more than once: %s", Utils.join(", ", duplicateUserEnabledFilterNames)));
        }
        Set<String> duplicateDisabledUserFilterNames = Utils.getDuplicatedItems(this.userArgs.getUserDisabledReadFilterNames());
        if (!duplicateDisabledUserFilterNames.isEmpty()) {
            throw new CommandLineException.BadArgumentValue(String.format("The read filter(s) are disabled more than once: %s", Utils.join(", ", duplicateDisabledUserFilterNames)));
        }
        HashSet<String> enabledAndDisabled = new HashSet<String>(this.userArgs.getUserEnabledReadFilterNames());
        enabledAndDisabled.retainAll(this.userArgs.getUserDisabledReadFilterNames());
        if (!enabledAndDisabled.isEmpty()) {
            String badFiltersList = Utils.join(", ", enabledAndDisabled);
            throw new CommandLineException(String.format("The read filter(s): %s are both enabled and disabled", badFiltersList));
        }
        this.userArgs.getUserDisabledReadFilterNames().forEach(s -> {
            if (!this.allDiscoveredReadFilters.containsKey(s)) {
                throw new CommandLineException.BadArgumentValue(String.format("Disabled filter (%s) does not exist", s));
            }
            if (!this.toolDefaultReadFilters.containsKey(s)) {
                this.logger.warn(String.format("Disabled filter (%s) is not enabled by this tool", s));
            }
        });
        HashSet<String> redundant = new HashSet<String>(this.toolDefaultReadFilters.keySet());
        redundant.retainAll(this.userArgs.getUserEnabledReadFilterNames());
        redundant.forEach(s -> this.logger.warn(String.format("Redundant enabled filter (%s) is enabled for this tool by default", s)));
        this.userArgs.getUserDisabledReadFilterNames().forEach(s -> {
            if (this.requiredPredecessors.contains(s)) {
                String message = String.format("Values were supplied for (%s) that is also disabled", s);
                if (this.toolDefaultReadFilters.containsKey(s)) {
                    this.logger.warn(message);
                } else {
                    throw new CommandLineException(message);
                }
            }
        });
        HashMap requestedReadFilters = new HashMap();
        this.userArgs.getUserEnabledReadFilterNames().forEach(s -> {
            ReadFilter trf = this.allDiscoveredReadFilters.get(s);
            if (null == trf) {
                if (!this.toolDefaultReadFilters.containsKey(s)) {
                    throw new CommandLineException("Unrecognized read filter name: " + s);
                }
            } else {
                requestedReadFilters.put(s, trf);
            }
        });
    }

    public boolean isDisabledFilter(String filterName) {
        return this.userArgs.getUserDisabledReadFilterNames().contains(filterName) || this.userArgs.getDisableToolDefaultReadFilters() && !this.userArgs.getUserEnabledReadFilterNames().contains(filterName);
    }

    public final ReadFilter getMergedReadFilter(SAMFileHeader samHeader) {
        Utils.nonNull(samHeader);
        return this.getMergedReadFilter(samHeader, ReadFilter::fromList);
    }

    public final CountingReadFilter getMergedCountingReadFilter(SAMFileHeader samHeader) {
        Utils.nonNull(samHeader);
        return this.getMergedReadFilter(samHeader, CountingReadFilter::fromList);
    }

    public <T extends ReadFilter> T getMergedReadFilter(SAMFileHeader samHeader, BiFunction<List<ReadFilter>, SAMFileHeader, T> aggregateFunction) {
        Utils.nonNull(samHeader);
        Utils.nonNull(aggregateFunction);
        List<ReadFilter> finalFilters = this.getResolvedInstances();
        return (T)((ReadFilter)aggregateFunction.apply(finalFilters, samHeader));
    }

    static {
        GATKConfig config = ConfigFactory.getInstance().getGATKConfig();
        PLUGIN_PACKAGE_NAMES = Collections.unmodifiableList(config.read_filter_packages());
        pluginBaseClass = ReadFilter.class;
    }
}

