/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public abstract class PicardCommandLineProgram
extends CommandLineProgram {
    @Argument(doc="Validation stringency for all SAM files read by this program.  Setting stringency to SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true)
    public ValidationStringency VALIDATION_STRINGENCY = ValidationStringency.DEFAULT_STRINGENCY;
    @Argument(doc="Compression level for all compressed files created (e.g. BAM and GELI).", common=true)
    public int COMPRESSION_LEVEL = BlockCompressedStreamConstants.DEFAULT_COMPRESSION_LEVEL;
    @Argument(doc="When writing SAM files that need to be sorted, this will specify the number of records stored in RAM before spilling to disk. Increasing this number reduces the number of file handles needed to sort a SAM file, and increases the amount of RAM needed.", optional=true, common=true)
    public Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    @Argument(doc="Whether to create a BAM index when writing a coordinate-sorted BAM file.", common=true)
    public Boolean CREATE_INDEX = Defaults.CREATE_INDEX;
    @Argument(doc="Whether to create an MD5 digest for any BAM or FASTQ files created.  ", common=true)
    public boolean CREATE_MD5_FILE = Defaults.CREATE_MD5;
    @Argument(fullName="reference", shortName="R", doc="Reference sequence file.", common=true, optional=true)
    public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;

    @Override
    public Object instanceMain(String[] argv) {
        if (!this.parseArgs(argv)) {
            return 0;
        }
        SamReaderFactory.setDefaultValidationStringency((ValidationStringency)this.VALIDATION_STRINGENCY);
        BlockCompressedOutputStream.setDefaultCompressionLevel((int)this.COMPRESSION_LEVEL);
        if (this.MAX_RECORDS_IN_RAM != null) {
            SAMFileWriterImpl.setDefaultMaxRecordsInRam((int)this.MAX_RECORDS_IN_RAM);
        }
        if (this.CREATE_INDEX.booleanValue()) {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)true);
        }
        SAMFileWriterFactory.setDefaultCreateMd5File((boolean)this.CREATE_MD5_FILE);
        return this.instanceMainPostParseArgs();
    }

    public SAMFileWriter createSAMWriter(File outputFile, File referenceFile, SAMFileHeader header, boolean preSorted) {
        BlockCompressedOutputStream.setDefaultCompressionLevel((int)this.COMPRESSION_LEVEL);
        SAMFileWriterFactory factory = new SAMFileWriterFactory().setCreateIndex(this.CREATE_INDEX.booleanValue()).setCreateMd5File(this.CREATE_MD5_FILE);
        if (this.MAX_RECORDS_IN_RAM != null) {
            factory = factory.setMaxRecordsInRam(this.MAX_RECORDS_IN_RAM.intValue());
        }
        return ReadUtils.createCommonSAMWriterFromFactory(factory, outputFile, referenceFile, header, preSorted);
    }
}

