/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline.argumentcollections;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.TraversalParameters;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.GenomeLocSortedSet;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalSetRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class IntervalArgumentCollection
implements Serializable {
    private static final Logger logger = LogManager.getLogger(IntervalArgumentCollection.class);
    private static final long serialVersionUID = 1L;
    public static final String EXCLUDE_INTERVALS_LONG_NAME = "exclude-intervals";
    public static final String EXCLUDE_INTERVALS_SHORT_NAME = "XL";
    public static final String INTERVAL_SET_RULE_LONG_NAME = "interval-set-rule";
    public static final String INTERVAL_PADDING_LONG_NAME = "interval-padding";
    public static final String INTERVAL_EXCLUSION_PADDING_LONG_NAME = "interval-exclusion-padding";
    public static final String INTERVAL_MERGING_RULE_LONG_NAME = "interval-merging-rule";
    @Argument(fullName="exclude-intervals", shortName="XL", doc="One or more genomic intervals to exclude from processing", suppressFileExpansion=true, optional=true, common=true)
    protected final List<String> excludeIntervalStrings = new ArrayList<String>();
    @Argument(fullName="interval-set-rule", shortName="isr", doc="Set merging approach to use for combining interval inputs", common=true)
    protected IntervalSetRule intervalSetRule = IntervalSetRule.UNION;
    @Argument(fullName="interval-padding", shortName="ip", doc="Amount of padding (in bp) to add to each interval you are including.", common=true)
    protected int intervalPadding = 0;
    @Argument(fullName="interval-exclusion-padding", shortName="ixp", doc="Amount of padding (in bp) to add to each interval you are excluding.", common=true)
    protected int intervalExclusionPadding = 0;
    @Argument(fullName="interval-merging-rule", shortName="imr", doc="Interval merging rule for abutting intervals", optional=true)
    protected IntervalMergingRule intervalMergingRule = IntervalMergingRule.ALL;
    protected TraversalParameters traversalParameters = null;

    protected abstract List<String> getIntervalStrings();

    @VisibleForTesting
    protected abstract void addToIntervalStrings(String var1);

    public List<SimpleInterval> getIntervals(SAMSequenceDictionary sequenceDict) {
        return this.getTraversalParameters(sequenceDict).getIntervalsForTraversal();
    }

    public IntervalSetRule getIntervalSetRule() {
        return this.intervalSetRule;
    }

    public int getIntervalPadding() {
        return this.intervalPadding;
    }

    public int getIntervalExclusionPadding() {
        return this.intervalExclusionPadding;
    }

    public IntervalMergingRule getIntervalMergingRule() {
        return this.intervalMergingRule;
    }

    public List<SimpleInterval> getIntervalsWithoutMerging(SAMSequenceDictionary sequenceDict) {
        if (this.getIntervalStrings().isEmpty()) {
            throw new GATKException("Cannot call getIntervalsWithoutMerging() without specifying intervals to include.");
        }
        List<GenomeLoc> intervals = IntervalUtils.loadIntervalsNonMerging(this.getIntervalStrings(), this.intervalPadding, new GenomeLocParser(sequenceDict));
        boolean traverseUnmapped = false;
        if (intervals.contains(GenomeLoc.UNMAPPED)) {
            traverseUnmapped = true;
            intervals.remove(GenomeLoc.UNMAPPED);
        }
        return new TraversalParameters(IntervalUtils.convertGenomeLocsToSimpleIntervals(intervals), traverseUnmapped).getIntervalsForTraversal();
    }

    public TraversalParameters getTraversalParameters(SAMSequenceDictionary sequenceDict) {
        if (!this.intervalsSpecified()) {
            throw new GATKException("Cannot call getTraversalParameters() without specifying either intervals to include or exclude.");
        }
        if (this.traversalParameters == null) {
            this.traversalParameters = this.parseIntervals(new GenomeLocParser(sequenceDict), this.intervalMergingRule, this.intervalSetRule, this.excludeIntervalStrings);
        }
        return this.traversalParameters;
    }

    private TraversalParameters parseIntervals(GenomeLocParser genomeLocParser, IntervalMergingRule intervalMergingRule, IntervalSetRule intervalSetRule, List<String> excludeIntervalStrings) {
        GenomeLocSortedSet intervals;
        GenomeLocSortedSet includeSortedSet;
        if (!this.intervalsSpecified()) {
            throw new GATKException("Cannot call parseIntervals() without specifying either intervals to include or exclude.");
        }
        if (this.getIntervalStrings().isEmpty()) {
            includeSortedSet = GenomeLocSortedSet.createSetFromSequenceDictionary(genomeLocParser.getSequenceDictionary());
        } else {
            try {
                includeSortedSet = IntervalUtils.loadIntervals(this.getIntervalStrings(), intervalSetRule, intervalMergingRule, this.intervalPadding, genomeLocParser);
            }
            catch (UserException.EmptyIntersection e) {
                throw new CommandLineException.BadArgumentValue("-L, --interval-set-rule", this.getIntervalStrings() + "," + (Object)((Object)intervalSetRule), "The specified intervals had an empty intersection");
            }
        }
        GenomeLocSortedSet excludeSortedSet = IntervalUtils.loadIntervals(excludeIntervalStrings, IntervalSetRule.UNION, intervalMergingRule, this.intervalExclusionPadding, genomeLocParser);
        if (excludeSortedSet.contains(GenomeLoc.UNMAPPED)) {
            throw new UserException("-XL unmapped is not currently supported");
        }
        if (excludeSortedSet.isEmpty()) {
            intervals = includeSortedSet;
        } else {
            intervals = includeSortedSet.subtractRegions(excludeSortedSet);
            if (intervals.isEmpty()) {
                throw new CommandLineException.BadArgumentValue("-L,-XL", this.getIntervalStrings().toString() + ", " + excludeIntervalStrings.toString(), "The intervals specified for exclusion with -XL removed all territory specified by -L.");
            }
            long toPruneSize = includeSortedSet.coveredSize();
            long toExcludeSize = excludeSortedSet.coveredSize();
            long intervalSize = intervals.coveredSize();
            logger.info(String.format("Initial include intervals span %d loci; exclude intervals span %d loci", toPruneSize, toExcludeSize));
            logger.info(String.format("Excluding %d loci from original intervals (%.2f%% reduction)", toPruneSize - intervalSize, (double)(toPruneSize - intervalSize) / (0.01 * (double)toPruneSize)));
        }
        logger.info(String.format("Processing %d bp from intervals", intervals.coveredSize()));
        boolean traverseUnmapped = false;
        if (intervals.contains(GenomeLoc.UNMAPPED)) {
            traverseUnmapped = true;
            intervals.remove(GenomeLoc.UNMAPPED);
        }
        return new TraversalParameters(IntervalUtils.convertGenomeLocsToSimpleIntervals(intervals.toList()), traverseUnmapped);
    }

    public boolean intervalsSpecified() {
        return !this.getIntervalStrings().isEmpty() || !this.excludeIntervalStrings.isEmpty();
    }
}

