/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline.argumentcollections;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;

public class OptionalTextOutputArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="output", shortName="O", doc="Optional output file", optional=true)
    @VisibleForTesting
    GATKPath output = null;

    public GATKPath getOutputPath() {
        return this.output;
    }

    public void print(Object value) {
        if (this.output != null) {
            try {
                Files.write(this.output.toPath(), value.toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile(this.output.toString(), (Exception)e);
            }
        }
    }

    public void println(Object value) {
        this.print(value.toString() + "\n");
    }
}

