/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.cmdline.argumentcollections;

import htsjdk.samtools.ValidationStringency;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.utils.read.ReadConstants;

public abstract class ReadInputArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="read-validation-stringency", shortName="VS", doc="Validation stringency for all SAM/BAM/CRAM/SRA files read by this program.  The default stringency value SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true, optional=true)
    protected ValidationStringency readValidationStringency = ReadConstants.DEFAULT_READ_VALIDATION_STRINGENCY;
    @Argument(fullName="read-index", shortName="read-index", doc="Indices to use for the read inputs. If specified, an index must be provided for every read input and in the same order as the read inputs. If this argument is not specified, the path to the index for each input will be inferred automatically.", common=true, optional=true)
    protected List<GATKPath> readIndices;

    public abstract List<GATKPath> getReadPathSpecifiers();

    public List<Path> getReadPaths() {
        return this.getReadPathSpecifiers().stream().map(GATKPath::toPath).collect(Collectors.toList());
    }

    public List<Path> getReadIndexPaths() {
        if (this.readIndices == null || this.readIndices.isEmpty()) {
            return null;
        }
        return this.readIndices.stream().map(GATKPath::toPath).collect(Collectors.toList());
    }

    public ValidationStringency getReadValidationStringency() {
        return this.readValidationStringency;
    }
}

