/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.validation.ConcordanceState;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

public abstract class AbstractConcordanceWalker
extends WalkerBase {
    public static final String TRUTH_VARIANTS_LONG_NAME = "truth";
    public static final String EVAL_VARIANTS_SHORT_NAME = "eval";
    public static final String EVAL_VARIANTS_LONG_NAME = "evaluation";
    public static final String CONFIDENCE_REGION_LONG_NAME = "confidence";
    public static final String CONFIDENCE_REGION_SHORT_NAME = "C";
    public static final int CACHE_LOOKAHEAD = 100000;
    @Argument(shortName="truth", fullName="truth", doc="A VCF containing truth variants", optional=false)
    public String truthVariantsFile;
    @Argument(shortName="eval", fullName="evaluation", doc="A VCF containing variants to be compared to the truth", optional=false)
    public String evalVariantsFile;
    @Argument(doc="TO BE IMPLEMENTED", fullName="confidence", shortName="C", optional=true)
    protected File highConfidenceRegion;
    private FeatureDataSource<VariantContext> truthVariants;
    private FeatureDataSource<VariantContext> evalVariants;
    protected SAMSequenceDictionary dict;
    private VariantContextComparator variantContextComparator;

    @Override
    public final SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        this.initializeTruthVariantsIfNecessary();
        return this.truthVariants.getSequenceDictionary();
    }

    private void initializeTruthVariantsIfNecessary() {
        if (!BucketUtils.fileExists(this.truthVariantsFile)) {
            throw new IllegalArgumentException("Truth variants file " + this.truthVariantsFile + " does not exist or is not readable.");
        }
        if (this.truthVariants == null) {
            this.truthVariants = new FeatureDataSource(new FeatureInput(this.truthVariantsFile, TRUTH_VARIANTS_LONG_NAME), 100000, VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer);
        }
    }

    protected Predicate<VariantContext> makeTruthVariantFilter() {
        return vc -> !vc.isFiltered();
    }

    protected Predicate<VariantContext> makeEvalVariantFilter() {
        return vc -> true;
    }

    private Spliterator<TruthVersusEval> getSpliteratorForDrivingVariants() {
        FilterIterator truthIterator = new FilterIterator(this.truthVariants.iterator(), this.makeTruthVariantFilter());
        FilterIterator evalIterator = new FilterIterator(this.evalVariants.iterator(), this.makeEvalVariantFilter());
        return new ConcordanceIterator((Iterator<VariantContext>)truthIterator, (Iterator<VariantContext>)evalIterator).spliterator();
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        this.initializeTruthVariantsIfNecessary();
        this.evalVariants = new FeatureDataSource(new FeatureInput(this.evalVariantsFile, EVAL_VARIANTS_SHORT_NAME), 100000, VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer);
        if (this.hasUserSuppliedIntervals()) {
            this.truthVariants.setIntervalsForTraversal(this.userIntervals);
            this.evalVariants.setIntervalsForTraversal(this.userIntervals);
        }
        this.dict = this.getBestAvailableSequenceDictionary();
        this.variantContextComparator = new VariantContextComparator(this.dict);
    }

    protected abstract void apply(TruthVersusEval var1, ReadsContext var2, ReferenceContext var3);

    @Override
    public void traverse() {
        StreamSupport.stream(this.getSpliteratorForDrivingVariants(), false).forEach(truthVersusEval -> {
            SimpleInterval variantInterval = new SimpleInterval((Locatable)truthVersusEval);
            this.apply((TruthVersusEval)truthVersusEval, new ReadsContext(this.reads, variantInterval), new ReferenceContext(this.reference, variantInterval));
            this.progressMeter.update(variantInterval);
        });
    }

    @Override
    protected final void onShutdown() {
        super.onShutdown();
        if (this.truthVariants != null) {
            this.truthVariants.close();
        }
        if (this.evalVariants != null) {
            this.evalVariants.close();
        }
    }

    public final VCFHeader getTruthHeader() {
        return AbstractConcordanceWalker.getHeader(this.truthVariants);
    }

    public final VCFHeader getEvalHeader() {
        return AbstractConcordanceWalker.getHeader(this.evalVariants);
    }

    private static VCFHeader getHeader(FeatureDataSource<VariantContext> source) {
        Object header = source.getHeader();
        if (!(header instanceof VCFHeader)) {
            throw new GATKException("Header for " + source.getName() + " is not in VCF header format");
        }
        return (VCFHeader)header;
    }

    protected abstract boolean areVariantsAtSameLocusConcordant(VariantContext var1, VariantContext var2);

    protected static class TruthVersusEval
    implements Locatable {
        private final Optional<VariantContext> truth;
        private final Optional<VariantContext> eval;
        private final ConcordanceState concordanceState;

        private TruthVersusEval(Optional<VariantContext> truth, Optional<VariantContext> eval, ConcordanceState concordanceState) {
            this.truth = truth;
            this.eval = eval;
            this.concordanceState = concordanceState;
        }

        public static TruthVersusEval falseNegative(VariantContext truth) {
            return new TruthVersusEval(Optional.of(truth), Optional.empty(), ConcordanceState.FALSE_NEGATIVE);
        }

        public static TruthVersusEval falsePositive(VariantContext eval) {
            return new TruthVersusEval(Optional.empty(), Optional.of(eval), ConcordanceState.FALSE_POSITIVE);
        }

        public static TruthVersusEval truePositive(VariantContext truth, VariantContext eval) {
            return new TruthVersusEval(Optional.of(truth), Optional.of(eval), ConcordanceState.TRUE_POSITIVE);
        }

        public static TruthVersusEval filteredFalseNegative(VariantContext truth, VariantContext eval) {
            return new TruthVersusEval(Optional.of(truth), Optional.of(eval), ConcordanceState.FILTERED_FALSE_NEGATIVE);
        }

        public static TruthVersusEval filteredTrueNegative(VariantContext eval) {
            return new TruthVersusEval(Optional.empty(), Optional.of(eval), ConcordanceState.FILTERED_TRUE_NEGATIVE);
        }

        public ConcordanceState getConcordance() {
            return this.concordanceState;
        }

        public VariantContext getTruth() {
            Utils.validateArg(this.truth.isPresent(), () -> "This is a " + this.concordanceState.toString() + " and has no truth VariantContext.");
            return this.truth.get();
        }

        public VariantContext getEval() {
            Utils.validateArg(this.eval.isPresent(), () -> "This is a " + this.concordanceState.toString() + " and has no eval VariantContext.");
            return this.eval.get();
        }

        public boolean hasTruth() {
            return this.truth.isPresent();
        }

        public boolean hasEval() {
            return this.eval.isPresent();
        }

        public VariantContext getTruthIfPresentElseEval() {
            return this.truth.orElseGet(() -> this.eval.get());
        }

        public String getContig() {
            return this.getTruthIfPresentElseEval().getContig();
        }

        public int getStart() {
            return this.getTruthIfPresentElseEval().getStart();
        }

        public int getEnd() {
            return this.getTruthIfPresentElseEval().getEnd();
        }
    }

    private class ConcordanceIterator
    implements Iterator<TruthVersusEval> {
        private final PeekableIterator<VariantContext> truthIterator;
        private final PeekableIterator<VariantContext> evalIterator;

        protected ConcordanceIterator(Iterator<VariantContext> truthIterator, Iterator<VariantContext> evalIterator) {
            this.truthIterator = new PeekableIterator(truthIterator);
            this.evalIterator = new PeekableIterator(evalIterator);
        }

        @Override
        public boolean hasNext() {
            return this.truthIterator.hasNext() || this.evalIterator.hasNext();
        }

        @Override
        public TruthVersusEval next() {
            if (!this.truthIterator.hasNext()) {
                return this.nextEvalOnlyVariant();
            }
            if (!this.evalIterator.hasNext()) {
                return this.nextTruthOnlyVariant();
            }
            int positionCompare = AbstractConcordanceWalker.this.variantContextComparator.compare((VariantContext)this.truthIterator.peek(), (VariantContext)this.evalIterator.peek());
            if (positionCompare > 0) {
                return this.nextEvalOnlyVariant();
            }
            if (positionCompare < 0) {
                return this.nextTruthOnlyVariant();
            }
            if (((VariantContext)this.evalIterator.peek()).isFiltered()) {
                return TruthVersusEval.filteredFalseNegative((VariantContext)this.truthIterator.next(), (VariantContext)this.evalIterator.next());
            }
            if (AbstractConcordanceWalker.this.areVariantsAtSameLocusConcordant((VariantContext)this.truthIterator.peek(), (VariantContext)this.evalIterator.peek())) {
                return TruthVersusEval.truePositive((VariantContext)this.truthIterator.next(), (VariantContext)this.evalIterator.next());
            }
            return TruthVersusEval.falseNegative((VariantContext)this.truthIterator.next());
        }

        private TruthVersusEval nextEvalOnlyVariant() {
            VariantContext evalVariant = (VariantContext)this.evalIterator.next();
            return evalVariant.isFiltered() ? TruthVersusEval.filteredTrueNegative(evalVariant) : TruthVersusEval.falsePositive(evalVariant);
        }

        private TruthVersusEval nextTruthOnlyVariant() {
            return TruthVersusEval.falseNegative((VariantContext)this.truthIterator.next());
        }

        private Spliterator<TruthVersusEval> spliterator() {
            return Spliterators.spliteratorUnknownSize(this, 0);
        }
    }
}

