/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMFileHeader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.MultiIntervalShard;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;
import org.broadinstitute.hellbender.utils.downsampling.DownsamplingMethod;
import org.broadinstitute.hellbender.utils.iterators.IntervalLocusIterator;
import org.broadinstitute.hellbender.utils.locusiterator.IntervalAlignmentContextIterator;
import org.broadinstitute.hellbender.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class ActivityProfileStateIterator
implements Iterator<ActivityProfileState> {
    private static final Logger logger = LogManager.getLogger(ActivityProfileStateIterator.class);
    private final ReferenceDataSource reference;
    private final FeatureManager features;
    private final AssemblyRegionEvaluator evaluator;
    private final Iterator<AlignmentContext> locusIterator;

    public ActivityProfileStateIterator(MultiIntervalShard<GATKRead> readShard, SAMFileHeader readHeader, ReferenceDataSource reference, FeatureManager features, AssemblyRegionEvaluator evaluator) {
        Utils.nonNull(readShard);
        Utils.nonNull(readHeader);
        Utils.nonNull(evaluator);
        this.reference = reference;
        this.features = features;
        this.evaluator = evaluator;
        LocusIteratorByState libs = new LocusIteratorByState(readShard.iterator(), DownsamplingMethod.NONE, false, ReadUtils.getSamplesFromHeader(readHeader), readHeader, true);
        IntervalLocusIterator intervalLocusIterator = new IntervalLocusIterator(readShard.getIntervals().iterator());
        this.locusIterator = new IntervalAlignmentContextIterator(libs, intervalLocusIterator, readHeader.getSequenceDictionary());
    }

    @Override
    public boolean hasNext() {
        return this.locusIterator.hasNext();
    }

    @Override
    public ActivityProfileState next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when there were no more elements");
        }
        AlignmentContext pileup = this.locusIterator.next();
        SimpleInterval pileupInterval = new SimpleInterval(pileup);
        ReferenceContext pileupRefContext = new ReferenceContext(this.reference, pileupInterval);
        FeatureContext pileupFeatureContext = new FeatureContext(this.features, pileupInterval);
        return this.evaluator.isActive(pileup, pileupRefContext, pileupFeatureContext);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported by AssemblyRegionIterator");
    }
}

