/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.hellbender.utils.HasGenomeLocation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

public final class AlignmentContext
implements Locatable,
HasGenomeLocation {
    private final Locatable loc;
    private final ReadPileup basePileup;
    private boolean hasPileupBeenDownsampled;

    public AlignmentContext(Locatable loc, ReadPileup basePileup) {
        this(loc, basePileup, false);
    }

    public AlignmentContext(Locatable loc, ReadPileup basePileup, boolean hasPileupBeenDownsampled) {
        Utils.nonNull(loc, "BUG: GenomeLoc in Alignment context is null");
        Utils.nonNull(basePileup, "BUG: ReadBackedPileup in Alignment context is null");
        this.loc = loc;
        this.basePileup = basePileup;
        this.hasPileupBeenDownsampled = hasPileupBeenDownsampled;
    }

    public int size() {
        return this.basePileup.size();
    }

    public String getContig() {
        return this.getLocation().getContig();
    }

    public int getStart() {
        return this.getLocation().getStart();
    }

    public int getEnd() {
        return this.getLocation().getEnd();
    }

    public long getPosition() {
        return this.getStart();
    }

    @Override
    public Locatable getLocation() {
        return this.loc;
    }

    public boolean hasPileupBeenDownsampled() {
        return this.hasPileupBeenDownsampled;
    }

    public ReadPileup getBasePileup() {
        return this.basePileup;
    }

    public AlignmentContext stratify(ReadOrientation type) {
        switch (type) {
            case COMPLETE: {
                return this;
            }
            case FORWARD: {
                return new AlignmentContext(this.loc, this.basePileup.makeFilteredPileup(pe -> !pe.getRead().isReverseStrand()));
            }
            case REVERSE: {
                return new AlignmentContext(this.loc, this.basePileup.makeFilteredPileup(pe -> pe.getRead().isReverseStrand()));
            }
        }
        throw new IllegalArgumentException("Unable to get alignment context for type = " + (Object)((Object)type));
    }

    public Map<String, AlignmentContext> splitContextBySampleName(SAMFileHeader header) {
        return this.splitContextBySampleName(null, header);
    }

    public Map<String, AlignmentContext> splitContextBySampleName(String assumedSingleSample, SAMFileHeader header) {
        if (assumedSingleSample != null) {
            return Collections.singletonMap(assumedSingleSample, this);
        }
        Locatable loc = this.getLocation();
        Map<String, ReadPileup> pileups = this.getBasePileup().splitBySample(header, assumedSingleSample);
        LinkedHashMap<String, AlignmentContext> contexts = new LinkedHashMap<String, AlignmentContext>(pileups.size());
        for (Map.Entry<String, ReadPileup> entry : pileups.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            contexts.put(entry.getKey(), new AlignmentContext(loc, entry.getValue()));
        }
        return contexts;
    }

    public static Map<String, AlignmentContext> splitContextBySampleName(ReadPileup pileup, SAMFileHeader header) {
        return new AlignmentContext(pileup.getLocation(), pileup).splitContextBySampleName(header);
    }

    public String toString() {
        return "AlignmentContext{loc=" + this.loc + ", basePileup=" + this.basePileup + ", hasPileupBeenDownsampled=" + this.hasPileupBeenDownsampled + '}';
    }

    public static enum ReadOrientation {
        COMPLETE,
        FORWARD,
        REVERSE;

    }
}

