/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfile;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;
import org.broadinstitute.hellbender.utils.activityprofile.BandPassActivityProfile;

public class AssemblyRegionFromActivityProfileStateIterator
implements Iterator<AssemblyRegion> {
    private static final Logger logger = LogManager.getLogger(AssemblyRegionFromActivityProfileStateIterator.class);
    private final SAMFileHeader readHeader;
    private final int minRegionSize;
    private final int maxRegionSize;
    private final int assemblyRegionPadding;
    private AssemblyRegion readyRegion;
    private Queue<AssemblyRegion> pendingRegions;
    private final Iterator<ActivityProfileState> activityProfileStateIterator;
    private final ActivityProfile activityProfile;

    public AssemblyRegionFromActivityProfileStateIterator(Iterator<ActivityProfileState> activityProfileStateIterator, SAMFileHeader readHeader, int minRegionSize, int maxRegionSize, int assemblyRegionPadding, double activeProbThreshold, int maxProbPropagationDistance) {
        Utils.nonNull(readHeader);
        Utils.validateArg(minRegionSize >= 1, "minRegionSize must be >= 1");
        Utils.validateArg(maxRegionSize >= 1, "maxRegionSize must be >= 1");
        Utils.validateArg(minRegionSize <= maxRegionSize, "minRegionSize must be <= maxRegionSize");
        Utils.validateArg(assemblyRegionPadding >= 0, "assemblyRegionPadding must be >= 0");
        Utils.validateArg(activeProbThreshold >= 0.0, "activeProbThreshold must be >= 0.0");
        Utils.validateArg(maxProbPropagationDistance >= 0, "maxProbPropagationDistance must be >= 0");
        this.activityProfileStateIterator = activityProfileStateIterator;
        this.readHeader = readHeader;
        this.minRegionSize = minRegionSize;
        this.maxRegionSize = maxRegionSize;
        this.assemblyRegionPadding = assemblyRegionPadding;
        this.readyRegion = null;
        this.pendingRegions = new ArrayDeque<AssemblyRegion>();
        this.activityProfile = new BandPassActivityProfile(maxProbPropagationDistance, activeProbThreshold, 50, 17.0, readHeader);
        this.readyRegion = this.loadNextAssemblyRegion();
    }

    @Override
    public boolean hasNext() {
        return this.readyRegion != null;
    }

    @Override
    public AssemblyRegion next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when there were no more elements");
        }
        AssemblyRegion toReturn = this.readyRegion;
        this.readyRegion = this.loadNextAssemblyRegion();
        return toReturn;
    }

    private AssemblyRegion loadNextAssemblyRegion() {
        AssemblyRegion nextRegion = null;
        while (this.activityProfileStateIterator.hasNext() && nextRegion == null) {
            ActivityProfileState profile = this.activityProfileStateIterator.next();
            if (!this.activityProfile.isEmpty()) {
                boolean forceConversion = profile.getLoc().getStart() != this.activityProfile.getEnd() + 1;
                this.pendingRegions.addAll(this.activityProfile.popReadyAssemblyRegions(this.assemblyRegionPadding, this.minRegionSize, this.maxRegionSize, forceConversion));
            }
            this.activityProfile.add(profile);
            if (this.pendingRegions.isEmpty() || !IntervalUtils.isAfter(profile.getLoc(), this.pendingRegions.peek().getPaddedSpan(), this.readHeader.getSequenceDictionary())) continue;
            nextRegion = this.pendingRegions.poll();
        }
        if (!this.activityProfileStateIterator.hasNext()) {
            if (!this.activityProfile.isEmpty()) {
                this.pendingRegions.addAll(this.activityProfile.popReadyAssemblyRegions(this.assemblyRegionPadding, this.minRegionSize, this.maxRegionSize, true));
            }
            if (!this.pendingRegions.isEmpty() && nextRegion == null) {
                nextRegion = this.pendingRegions.poll();
            }
        }
        return nextRegion;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported by AssemblyRegionIterator");
    }
}

