/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.MultiIntervalShard;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfile;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;
import org.broadinstitute.hellbender.utils.activityprofile.BandPassActivityProfile;
import org.broadinstitute.hellbender.utils.downsampling.DownsamplingMethod;
import org.broadinstitute.hellbender.utils.iterators.IntervalLocusIterator;
import org.broadinstitute.hellbender.utils.iterators.ReadCachingIterator;
import org.broadinstitute.hellbender.utils.locusiterator.IntervalAlignmentContextIterator;
import org.broadinstitute.hellbender.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class AssemblyRegionIterator
implements Iterator<AssemblyRegion> {
    private static final Logger logger = LogManager.getLogger(AssemblyRegionIterator.class);
    private final MultiIntervalShard<GATKRead> readShard;
    private final SAMFileHeader readHeader;
    private final ReferenceDataSource reference;
    private final FeatureManager features;
    private final AssemblyRegionEvaluator evaluator;
    final AssemblyRegionArgumentCollection assemblyRegionArgs;
    private AssemblyRegion readyRegion;
    private Queue<AssemblyRegion> pendingRegions;
    private List<GATKRead> previousRegionReads;
    private final ReadCachingIterator readCachingIterator;
    private Queue<GATKRead> readCache;
    private final Iterator<AlignmentContext> locusIterator;
    private final LocusIteratorByState libs;
    private final ActivityProfile activityProfile;

    public AssemblyRegionIterator(MultiIntervalShard<GATKRead> readShard, SAMFileHeader readHeader, ReferenceDataSource reference, FeatureManager features, AssemblyRegionEvaluator evaluator, AssemblyRegionArgumentCollection assemblyRegionArgs) {
        Utils.nonNull(readShard);
        Utils.nonNull(readHeader);
        Utils.nonNull(evaluator);
        assemblyRegionArgs.validate();
        this.readShard = readShard;
        this.readHeader = readHeader;
        this.reference = reference;
        this.features = features;
        this.evaluator = evaluator;
        this.assemblyRegionArgs = assemblyRegionArgs;
        this.readyRegion = null;
        this.previousRegionReads = null;
        this.pendingRegions = new ArrayDeque<AssemblyRegion>();
        this.readCachingIterator = new ReadCachingIterator(readShard.iterator());
        this.readCache = new ArrayDeque<GATKRead>();
        this.activityProfile = new BandPassActivityProfile(assemblyRegionArgs.maxProbPropagationDistance, assemblyRegionArgs.activeProbThreshold, 50, 17.0, readHeader);
        this.libs = new LocusIteratorByState((Iterator<GATKRead>)this.readCachingIterator, DownsamplingMethod.NONE, false, ReadUtils.getSamplesFromHeader(readHeader), readHeader, true);
        IntervalLocusIterator intervalLocusIterator = new IntervalLocusIterator(readShard.getIntervals().iterator());
        this.locusIterator = new IntervalAlignmentContextIterator(this.libs, intervalLocusIterator, readHeader.getSequenceDictionary());
        this.readyRegion = this.loadNextAssemblyRegion();
    }

    @Override
    public boolean hasNext() {
        return this.readyRegion != null;
    }

    @Override
    public AssemblyRegion next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when there were no more elements");
        }
        AssemblyRegion toReturn = this.readyRegion;
        this.previousRegionReads = toReturn.getReads();
        this.readyRegion = this.loadNextAssemblyRegion();
        return toReturn;
    }

    private AssemblyRegion loadNextAssemblyRegion() {
        AssemblyRegion nextRegion = null;
        while (this.locusIterator.hasNext() && nextRegion == null) {
            AlignmentContext pileup = this.locusIterator.next();
            if (!this.activityProfile.isEmpty()) {
                boolean forceConversion = pileup.getLocation().getStart() != this.activityProfile.getEnd() + 1;
                this.pendingRegions.addAll(this.activityProfile.popReadyAssemblyRegions(this.assemblyRegionArgs.assemblyRegionPadding, this.assemblyRegionArgs.minAssemblyRegionSize, this.assemblyRegionArgs.maxAssemblyRegionSize, forceConversion));
            }
            SimpleInterval pileupInterval = new SimpleInterval(pileup);
            ReferenceContext pileupRefContext = new ReferenceContext(this.reference, pileupInterval);
            FeatureContext pileupFeatureContext = new FeatureContext(this.features, pileupInterval);
            ActivityProfileState profile = this.evaluator.isActive(pileup, pileupRefContext, pileupFeatureContext);
            this.activityProfile.add(profile);
            if (this.pendingRegions.isEmpty() || !IntervalUtils.isAfter(pileup.getLocation(), this.pendingRegions.peek().getPaddedSpan(), this.readHeader.getSequenceDictionary())) continue;
            nextRegion = this.pendingRegions.poll();
        }
        if (!this.locusIterator.hasNext()) {
            while (this.libs.hasNext()) {
                this.libs.next();
            }
            if (!this.activityProfile.isEmpty()) {
                this.pendingRegions.addAll(this.activityProfile.popReadyAssemblyRegions(this.assemblyRegionArgs.assemblyRegionPadding, this.assemblyRegionArgs.minAssemblyRegionSize, this.assemblyRegionArgs.maxAssemblyRegionSize, true));
            }
            if (!this.pendingRegions.isEmpty() && nextRegion == null) {
                nextRegion = this.pendingRegions.poll();
            }
        }
        if (nextRegion != null) {
            this.fillNextAssemblyRegionWithReads(nextRegion);
        }
        return nextRegion;
    }

    private void fillNextAssemblyRegionWithReads(AssemblyRegion region) {
        GATKRead nextRead;
        if (this.previousRegionReads != null) {
            for (GATKRead previousRegionRead : this.previousRegionReads) {
                if (!region.getPaddedSpan().overlaps(previousRegionRead)) continue;
                region.add(previousRegionRead);
            }
        }
        this.readCache.addAll(this.readCachingIterator.consumeCachedReads());
        while (!this.readCache.isEmpty() && !IntervalUtils.isAfter(nextRead = this.readCache.peek(), region.getPaddedSpan(), this.readHeader.getSequenceDictionary())) {
            this.readCache.poll();
            if (!region.getPaddedSpan().overlaps(nextRead)) continue;
            region.add(nextRead);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported by AssemblyRegionIterator");
    }
}

