/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.AssemblyRegionIterator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.MultiIntervalLocalReadShard;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.IGVUtils;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.downsampling.PositionalDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;

public abstract class AssemblyRegionWalker
extends WalkerBase {
    @ArgumentCollection
    public final AssemblyRegionArgumentCollection assemblyRegionArgs = new AssemblyRegionArgumentCollection();
    @Argument(fullName="assembly-region-out", doc="Output the assembly region to this IGV formatted file", optional=true)
    protected String assemblyRegionOut = null;
    private PrintStream assemblyRegionOutStream;
    private List<MultiIntervalLocalReadShard> readShards;

    @Override
    public final boolean requiresReads() {
        return true;
    }

    @Override
    public final boolean requiresReference() {
        return true;
    }

    @Override
    public String getProgressMeterRecordLabel() {
        return "regions";
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        this.assemblyRegionArgs.validate();
        List<SimpleInterval> intervals = this.hasUserSuppliedIntervals() ? this.userIntervals : IntervalUtils.getAllIntervalsForReference(this.getHeaderForReads().getSequenceDictionary());
        this.readShards = this.makeReadShards(intervals);
        this.initializeAssemblyRegionOutputStreams();
    }

    private List<MultiIntervalLocalReadShard> makeReadShards(List<SimpleInterval> intervals) {
        ArrayList<MultiIntervalLocalReadShard> shards = new ArrayList<MultiIntervalLocalReadShard>();
        List<List<SimpleInterval>> intervalsGroupedByContig = IntervalUtils.groupIntervalsByContig(intervals);
        for (List<SimpleInterval> allIntervalsOnContig : intervalsGroupedByContig) {
            shards.add(new MultiIntervalLocalReadShard(allIntervalsOnContig, this.assemblyRegionArgs.assemblyRegionPadding, this.reads));
        }
        return shards;
    }

    private void initializeAssemblyRegionOutputStreams() {
        if (this.assemblyRegionOut != null) {
            try {
                this.assemblyRegionOutStream = new PrintStream(this.assemblyRegionOut);
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile(this.assemblyRegionOut, "Error writing assembly regions to output file", (Exception)e);
            }
            this.logger.info("Writing assembly regions to " + this.assemblyRegionOut);
            IGVUtils.printIGVFormatHeader(this.assemblyRegionOutStream, "line", "AssemblyRegions");
        }
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> defaultFilters = new ArrayList<ReadFilter>(2);
        defaultFilters.add(new WellformedReadFilter());
        defaultFilters.add(new ReadFilterLibrary.MappedReadFilter());
        return defaultFilters;
    }

    protected ReadsDownsampler createDownsampler() {
        return this.assemblyRegionArgs.maxReadsPerAlignmentStart > 0 ? new PositionalDownsampler(this.assemblyRegionArgs.maxReadsPerAlignmentStart, this.getHeaderForReads()) : null;
    }

    @Override
    public void traverse() {
        CountingReadFilter countedFilter = this.makeReadFilter();
        this.progressMeter.setRecordsBetweenTimeChecks(10L);
        for (MultiIntervalLocalReadShard readShard : this.readShards) {
            readShard.setPreReadFilterTransformer(this.makePreReadFilterTransformer());
            readShard.setReadFilter(countedFilter);
            readShard.setDownsampler(this.createDownsampler());
            readShard.setPostReadFilterTransformer(this.makePostReadFilterTransformer());
            this.processReadShard(readShard, this.reference, this.features);
        }
        this.logger.info(countedFilter.getSummaryLine());
    }

    private void processReadShard(MultiIntervalLocalReadShard shard, ReferenceDataSource reference, FeatureManager features) {
        AssemblyRegionIterator assemblyRegionIter = new AssemblyRegionIterator(shard, this.getHeaderForReads(), reference, features, this.assemblyRegionEvaluator(), this.assemblyRegionArgs);
        while (assemblyRegionIter.hasNext()) {
            AssemblyRegion assemblyRegion = (AssemblyRegion)assemblyRegionIter.next();
            if (this.assemblyRegionArgs.forceActive) {
                assemblyRegion.setIsActive(true);
            }
            this.logger.debug("Processing assembly region at " + assemblyRegion.getSpan() + " isActive: " + assemblyRegion.isActive() + " numReads: " + assemblyRegion.getReads().size());
            this.writeAssemblyRegion(assemblyRegion);
            this.apply(assemblyRegion, new ReferenceContext(reference, assemblyRegion.getPaddedSpan()), new FeatureContext(features, assemblyRegion.getPaddedSpan()));
            this.progressMeter.update(assemblyRegion.getSpan());
        }
    }

    private void writeAssemblyRegion(AssemblyRegion region) {
        if (this.assemblyRegionOutStream != null) {
            IGVUtils.printIGVFormatRow(this.assemblyRegionOutStream, new SimpleInterval(region.getContig(), region.getStart(), region.getStart()), "end-marker", 0.0);
            IGVUtils.printIGVFormatRow(this.assemblyRegionOutStream, region, "size=" + new SimpleInterval(region).size(), region.isActive() ? 1.0 : -1.0);
        }
    }

    @Override
    protected final void onShutdown() {
        super.onShutdown();
        if (this.assemblyRegionOutStream != null) {
            this.assemblyRegionOutStream.close();
        }
    }

    public abstract AssemblyRegionEvaluator assemblyRegionEvaluator();

    public abstract void apply(AssemblyRegion var1, ReferenceContext var2, FeatureContext var3);
}

