/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.consensus.MoleculeID;
import org.broadinstitute.hellbender.tools.walkers.consensus.ReadsWithSameUMI;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class DuplicateSetWalker
extends ReadWalker {
    public static final String MIN_REQUIRED_READS_NAME = "min-reads";
    public static final String MIN_REQUIRED_READS_PER_STRAND_NAME = "min-per-strand-reads";
    private static final int DEFAULT_MINIMUM_READS_PER_SET = 1;
    private static final int DEFAULT_MINIMUM_READS_PER_STRAND = 0;
    @Argument(fullName="min-reads", doc="The mininum total number of reads required in the set", optional=true, minValue=0.0)
    private int minimumRequiredReadsPerUMI = 1;
    @Argument(fullName="min-per-strand-reads", doc="The mininum total number of reads in each strand", optional=true, minValue=0.0)
    private int minimumRequiredReadsPerStrand = 0;
    protected ReadsWithSameUMI currentReadsWithSameUMI = null;

    @Override
    public final void traverse() {
        super.traverse();
        this.processLastReadSet();
    }

    @Override
    public final void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (this.currentReadsWithSameUMI == null) {
            this.currentReadsWithSameUMI = new ReadsWithSameUMI(read);
            return;
        }
        int readMoleculeNumber = MoleculeID.getMoleculeNumberOfRead(read);
        int duplicateSetMoleculeNumber = this.currentReadsWithSameUMI.getMoleculeNumber();
        if (duplicateSetMoleculeNumber > readMoleculeNumber) {
            throw new UserException(String.format("The input bam must be sorted by the molecule ID (%s) tag.", SAMTag.MI.name()));
        }
        if (duplicateSetMoleculeNumber < readMoleculeNumber) {
            if (this.rejectSet(this.currentReadsWithSameUMI)) {
                this.currentReadsWithSameUMI = new ReadsWithSameUMI(read);
                return;
            }
            this.apply(this.currentReadsWithSameUMI, new ReferenceContext(this.reference, this.currentReadsWithSameUMI.getInterval()), new FeatureContext(this.features, this.currentReadsWithSameUMI.getInterval()));
            this.currentReadsWithSameUMI = new ReadsWithSameUMI(read);
            return;
        }
        this.currentReadsWithSameUMI.addRead(read);
    }

    public abstract void apply(ReadsWithSameUMI var1, ReferenceContext var2, FeatureContext var3);

    private void processLastReadSet() {
        if (this.currentReadsWithSameUMI.getReads().size() > 0) {
            this.apply(this.currentReadsWithSameUMI, new ReferenceContext(this.reference, this.currentReadsWithSameUMI.getInterval()), new FeatureContext(this.features, this.currentReadsWithSameUMI.getInterval()));
        }
    }

    protected boolean rejectSet(ReadsWithSameUMI readsWithSameUMI) {
        Pair<Integer, Integer> strandCounts = MoleculeID.countStrands(readsWithSameUMI.getReads());
        if (Math.min((Integer)strandCounts.getLeft(), (Integer)strandCounts.getRight()) < this.minimumRequiredReadsPerStrand) {
            return true;
        }
        if (readsWithSameUMI.getReads().size() % 2 == 1) {
            return true;
        }
        return readsWithSameUMI.getReads().size() < this.minimumRequiredReadsPerUMI;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> readFilters = new ArrayList<ReadFilter>(6);
        readFilters.add(new WellformedReadFilter());
        readFilters.addAll(DuplicateSetWalker.getDuplicateSetWalkerSpecificReadFilterList());
        return readFilters;
    }

    private static List<ReadFilter> getDuplicateSetWalkerSpecificReadFilterList() {
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>(5);
        filters.add(ReadFilterLibrary.MAPPING_QUALITY_AVAILABLE);
        filters.add(ReadFilterLibrary.MAPPED);
        filters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        filters.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        filters.add(ReadFilterLibrary.NON_ZERO_REFERENCE_LENGTH_ALIGNMENT);
        return filters;
    }
}

