/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.SimpleInterval;

class FeatureCache<CACHED_FEATURE extends Feature> {
    private static final Logger logger = LogManager.getLogger(FeatureCache.class);
    private final Deque<CACHED_FEATURE> cache = new ArrayDeque<CACHED_FEATURE>(1024);
    private SimpleInterval cachedInterval;
    private int numCacheHits = 0;
    private int numCacheMisses = 0;
    private static final int INITIAL_CAPACITY = 1024;
    private static final int EXPECTED_MAX_OVERLAPPING_FEATURES_DURING_CACHE_TRIM = 128;

    public String getContig() {
        return this.cachedInterval.getContig();
    }

    public int getCacheStart() {
        return this.cachedInterval.getStart();
    }

    public int getCacheEnd() {
        return this.cachedInterval.getEnd();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public int getNumCacheHits() {
        return this.numCacheHits;
    }

    public int getNumCacheMisses() {
        return this.numCacheMisses;
    }

    public void fill(Iterator<CACHED_FEATURE> featureIter, SimpleInterval interval) {
        this.cache.clear();
        while (featureIter.hasNext()) {
            this.cache.add(featureIter.next());
        }
        this.cachedInterval = interval;
    }

    public boolean cacheHit(Locatable interval) {
        boolean cacheHit;
        boolean bl = cacheHit = this.cachedInterval != null && this.cachedInterval.contains(interval);
        if (cacheHit) {
            ++this.numCacheHits;
        } else {
            ++this.numCacheMisses;
        }
        return cacheHit;
    }

    public void trimToNewStartPosition(int newStart) {
        if (newStart > this.cachedInterval.getEnd()) {
            throw new GATKException(String.format("BUG: attempted to trim Feature cache to an improper new start position (%d). Cache stop = %d", newStart, this.cachedInterval.getEnd()));
        }
        ArrayList<Feature> overlappingFeaturesBeforeNewStart = new ArrayList<Feature>(128);
        while (!this.cache.isEmpty() && ((Feature)this.cache.getFirst()).getStart() < newStart) {
            Feature featureBeforeNewStart = (Feature)this.cache.removeFirst();
            if (featureBeforeNewStart.getEnd() < newStart) continue;
            overlappingFeaturesBeforeNewStart.add(featureBeforeNewStart);
        }
        for (int i = overlappingFeaturesBeforeNewStart.size() - 1; i >= 0; --i) {
            this.cache.addFirst(overlappingFeaturesBeforeNewStart.get(i));
        }
        this.cachedInterval = new SimpleInterval(this.cachedInterval.getContig(), newStart, this.cachedInterval.getEnd());
    }

    public List<CACHED_FEATURE> getCachedFeaturesUpToStopPosition(int stopPosition) {
        Feature candidateFeature;
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>(this.cache.size());
        Iterator<CACHED_FEATURE> iterator = this.cache.iterator();
        while (iterator.hasNext() && (candidateFeature = (Feature)iterator.next()).getStart() <= stopPosition) {
            matchingFeatures.add(candidateFeature);
        }
        return matchingFeatures;
    }

    public void printCacheStatistics() {
        this.printCacheStatistics("");
    }

    public void printCacheStatistics(String sourceName) {
        String sourceNameString = sourceName.isEmpty() ? "" : "for data source " + sourceName;
        int totalQueries = this.getNumCacheHits() + this.getNumCacheMisses();
        logger.debug(String.format("Cache hit rate %s was %.2f%% (%d out of %d total queries)", sourceNameString, totalQueries > 0 ? (double)this.getNumCacheHits() / (double)totalQueries * 100.0 : 0.0, this.getNumCacheHits(), totalQueries));
    }
}

