/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.DoNotSubclass;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

@DoNotSubclass
public class FeatureContext {
    private final FeatureManager featureManager;
    private final SimpleInterval interval;

    public FeatureContext() {
        this((FeatureManager)null, null);
    }

    public FeatureContext(FeatureManager featureManager, SimpleInterval interval) {
        this.featureManager = featureManager;
        this.interval = interval;
    }

    public FeatureContext(FeatureContext featureContext, SimpleInterval interval) {
        this(featureContext.featureManager, interval);
    }

    public boolean hasBackingDataSource() {
        return this.featureManager != null;
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public <T extends Feature> Object getHeader(FeatureInput<T> featureDescriptor) {
        return this.featureManager != null ? this.featureManager.getHeader(featureDescriptor) : null;
    }

    public <T extends Feature> List<T> getValues(FeatureInput<T> featureDescriptor) {
        return this.getValues(featureDescriptor, this.interval);
    }

    public <T extends Feature> List<T> getValues(FeatureInput<T> featureDescriptor, int windowLeadingBases, int windowTrailingBases) {
        return this.getValues(featureDescriptor, this.getQueryInterval(windowLeadingBases, windowTrailingBases));
    }

    public <T extends Feature> List<T> getValues(FeatureInput<T> featureDescriptor, Locatable queryInterval) {
        if (this.featureManager == null || queryInterval == null || featureDescriptor == null) {
            return Collections.emptyList();
        }
        return this.featureManager.getFeatures(featureDescriptor, queryInterval);
    }

    private SimpleInterval getQueryInterval(int windowLeadingBases, int windowTrailingBases) {
        Utils.validateArg(windowLeadingBases >= 0, "Window starts after the current interval");
        Utils.validateArg(windowTrailingBases >= 0, "Window ends before the current interval");
        if (this.interval == null) {
            return null;
        }
        if (windowLeadingBases == 0 && windowTrailingBases == 0) {
            return this.interval;
        }
        return new SimpleInterval(this.interval.getContig(), this.windowStart(this.interval, windowLeadingBases), this.windowStop(this.interval, windowTrailingBases));
    }

    private int windowStart(SimpleInterval locus, int windowLeadingBases) {
        return Math.max(locus.getStart() - windowLeadingBases, 1);
    }

    private int windowStop(SimpleInterval locus, int windowTrailingBases) {
        return Math.addExact(locus.getEnd(), windowTrailingBases);
    }

    public <T extends Feature> List<T> getValues(FeatureInput<T> featureDescriptor, int featureStart) {
        if (this.featureManager == null || this.interval == null) {
            return Collections.emptyList();
        }
        return this.subsetToStartPosition(this.getValues(featureDescriptor), featureStart);
    }

    public <T extends Feature> List<T> getValues(Collection<FeatureInput<T>> featureDescriptors) {
        if (this.featureManager == null || this.interval == null || featureDescriptors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> features = new ArrayList<T>();
        for (FeatureInput<T> featureSource : featureDescriptors) {
            features.addAll(this.getValues(featureSource));
        }
        return features;
    }

    public <T extends Feature> List<T> getValues(Collection<FeatureInput<T>> featureDescriptors, int featureStart) {
        if (this.featureManager == null || this.interval == null) {
            return Collections.emptyList();
        }
        return this.subsetToStartPosition(this.getValues(featureDescriptors), featureStart);
    }

    private <T extends Feature> List<T> subsetToStartPosition(Collection<T> features, int start) {
        return features.stream().filter(feat -> feat.getStart() == start).collect(Collectors.toList());
    }

    @VisibleForTesting
    public static FeatureContext createFeatureContextForTesting(Map<FeatureInput<? extends Feature>, Class<? extends Feature>> featureInputsWithType, String dummyToolInstanceName, SimpleInterval interval, int featureQueryLookahead, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, Path reference) {
        Utils.nonNull(featureInputsWithType);
        Utils.nonNull(dummyToolInstanceName);
        Utils.nonNull(interval);
        FeatureManager featureManager = new FeatureManager(featureInputsWithType, dummyToolInstanceName, featureQueryLookahead, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, reference);
        return new FeatureContext(featureManager, interval);
    }
}

