/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureCache;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.FeatureIntervalIterator;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKDataSource;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.IndexFeatureFile;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBUtils;
import org.broadinstitute.hellbender.utils.IndexUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.genomicsdb.model.GenomicsDBExportConfiguration;
import org.genomicsdb.reader.GenomicsDBFeatureReader;

public final class FeatureDataSource<T extends Feature>
implements GATKDataSource<T>,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(FeatureDataSource.class);
    private final FeatureReader<T> featureReader;
    private CloseableTribbleIterator<T> currentIterator;
    private List<SimpleInterval> intervalsForTraversal;
    private final FeatureCache<T> queryCache;
    private final int queryLookaheadBases;
    private final FeatureInput<T> featureInput;
    private final boolean hasIndex;
    private final boolean supportsRandomAccess;
    public static final int DEFAULT_QUERY_LOOKAHEAD_BASES = 1000;

    public FeatureDataSource(File featureFile) {
        this(featureFile, null);
    }

    public FeatureDataSource(String featurePath) {
        this(featurePath, null, 1000, null);
    }

    public FeatureDataSource(File featureFile, String name) {
        this(featureFile, name, 1000);
    }

    public FeatureDataSource(File featureFile, String name, int queryLookaheadBases) {
        this(Utils.nonNull(featureFile).getAbsolutePath(), name, queryLookaheadBases, null);
    }

    public FeatureDataSource(String featurePath, String name, int queryLookaheadBases, Class<? extends Feature> targetFeatureType) {
        this(new FeatureInput(featurePath, name != null ? name : featurePath), queryLookaheadBases, targetFeatureType);
    }

    public FeatureDataSource(FeatureInput<T> featureInput, int queryLookaheadBases, Class<? extends Feature> targetFeatureType) {
        this(featureInput, queryLookaheadBases, targetFeatureType, 0, 0);
    }

    public FeatureDataSource(String featurePath, String name, int queryLookaheadBases, Class<? extends Feature> targetFeatureType, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer) {
        this(new FeatureInput(featurePath, name != null ? name : featurePath), queryLookaheadBases, targetFeatureType, cloudPrefetchBuffer, cloudIndexPrefetchBuffer);
    }

    public FeatureDataSource(FeatureInput<T> featureInput, int queryLookaheadBases, Class<? extends Feature> targetFeatureType, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer) {
        this(featureInput, queryLookaheadBases, targetFeatureType, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, new GenomicsDBOptions());
    }

    public FeatureDataSource(FeatureInput<T> featureInput, int queryLookaheadBases, Class<? extends Feature> targetFeatureType, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, Path reference) {
        this(featureInput, queryLookaheadBases, targetFeatureType, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, new GenomicsDBOptions(reference));
    }

    public FeatureDataSource(FeatureInput<T> featureInput, int queryLookaheadBases, Class<? extends Feature> targetFeatureType, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, GenomicsDBOptions genomicsDBOptions) {
        Utils.validateArg(queryLookaheadBases >= 0, "Query lookahead bases must be >= 0");
        this.featureInput = Utils.nonNull(featureInput, "featureInput must not be null");
        if (IOUtils.isGenomicsDBPath(featureInput)) {
            Utils.nonNull(genomicsDBOptions, "GenomicsDBOptions must not be null. Calling tool may not read from a GenomicsDB data source.");
        }
        this.featureReader = FeatureDataSource.getFeatureReader(featureInput, targetFeatureType, BucketUtils.getPrefetchingWrapper(cloudPrefetchBuffer), BucketUtils.getPrefetchingWrapper(cloudIndexPrefetchBuffer), genomicsDBOptions);
        if (IOUtils.isGenomicsDBPath(featureInput)) {
            this.hasIndex = false;
            this.supportsRandomAccess = true;
        } else if (this.featureReader instanceof AbstractFeatureReader) {
            this.supportsRandomAccess = this.hasIndex = ((AbstractFeatureReader)this.featureReader).hasIndex();
        } else {
            throw new GATKException("Found a feature input that was neither GenomicsDB or a Tribble AbstractFeatureReader.  Input was " + featureInput.toString() + ".");
        }
        if (!this.hasIndex && IOUtil.hasBlockCompressedExtension((String)featureInput.getFeaturePath())) {
            throw new UserException.MissingIndex(featureInput.toString(), "Support for unindexed block-compressed files has been temporarily disabled. Try running IndexFeatureFile on the input.");
        }
        this.currentIterator = null;
        this.intervalsForTraversal = null;
        this.queryCache = new FeatureCache();
        this.queryLookaheadBases = queryLookaheadBases;
    }

    final void printCacheStats() {
        this.queryCache.printCacheStatistics(this.getName());
    }

    private static <T extends Feature> FeatureReader<T> getFeatureReader(FeatureInput<T> featureInput, Class<? extends Feature> targetFeatureType, Function<SeekableByteChannel, SeekableByteChannel> cloudWrapper, Function<SeekableByteChannel, SeekableByteChannel> cloudIndexWrapper, GenomicsDBOptions genomicsDBOptions) {
        if (IOUtils.isGenomicsDBPath(featureInput.getFeaturePath())) {
            Utils.nonNull(genomicsDBOptions);
            try {
                if (genomicsDBOptions.getReference() == null) {
                    throw new UserException.MissingReference("You must provide a reference if you want to load from GenomicsDB");
                }
                try {
                    File referenceAsFile = genomicsDBOptions.getReference().toFile();
                    return FeatureDataSource.getGenomicsDBFeatureReader(featureInput, referenceAsFile, genomicsDBOptions);
                }
                catch (UnsupportedOperationException e) {
                    throw new UserException.BadInput("GenomicsDB requires that the reference be a local file.", e);
                }
            }
            catch (ClassCastException e) {
                throw new UserException("GenomicsDB inputs can only be used to provide VariantContexts.", e);
            }
        }
        FeatureCodec<T, ?> codec = FeatureDataSource.getCodecForFeatureInput(featureInput, targetFeatureType);
        return FeatureDataSource.getTribbleFeatureReader(featureInput, codec, cloudWrapper, cloudIndexWrapper);
    }

    private static <T extends Feature> FeatureCodec<T, ?> getCodecForFeatureInput(FeatureInput<T> featureInput, Class<? extends Feature> targetFeatureType) {
        Object codec;
        Class<FeatureCodec<T, ?>> codecClass = featureInput.getFeatureCodecClass();
        if (codecClass == null) {
            Path featurePath = featureInput.toPath();
            IOUtils.assertFileIsReadable(featurePath);
            codec = FeatureManager.getCodecForFile(featurePath, targetFeatureType);
            featureInput.setFeatureCodecClass(codec.getClass());
        } else {
            try {
                codec = codecClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new GATKException("Unable to automatically instantiate codec " + codecClass.getName());
            }
        }
        return codec;
    }

    private static <T extends Feature> AbstractFeatureReader<T, ?> getTribbleFeatureReader(FeatureInput<T> featureInput, FeatureCodec<T, ?> codec, Function<SeekableByteChannel, SeekableByteChannel> cloudWrapper, Function<SeekableByteChannel, SeekableByteChannel> cloudIndexWrapper) {
        Utils.nonNull(codec);
        try {
            String absoluteRawPath = featureInput.getRawInputString();
            boolean requireIndex = false;
            if (BucketUtils.isEligibleForPrefetching(featureInput)) {
                return AbstractFeatureReader.getFeatureReader((String)absoluteRawPath, null, codec, (boolean)false, cloudWrapper, cloudIndexWrapper);
            }
            return AbstractFeatureReader.getFeatureReader((String)absoluteRawPath, null, codec, (boolean)false, Utils.identityFunction(), Utils.identityFunction());
        }
        catch (TribbleException e) {
            throw new GATKException("Error initializing feature reader for path " + featureInput.getFeaturePath(), e);
        }
    }

    protected static FeatureReader<VariantContext> getGenomicsDBFeatureReader(GATKPath path, File reference, GenomicsDBOptions genomicsDBOptions) {
        String workspace = IOUtils.getGenomicsDBAbsolutePath(path);
        if (workspace == null) {
            throw new IllegalArgumentException("Trying to create a GenomicsDBReader from  non-GenomicsDB input path " + path);
        }
        if (Files.notExists(IOUtils.getPath(workspace.endsWith("/") ? workspace : workspace + "/"), new LinkOption[0])) {
            throw new UserException("GenomicsDB workspace " + path + " does not exist");
        }
        String callsetJson = IOUtils.appendPathToDir(workspace, "callset.json");
        String vidmapJson = IOUtils.appendPathToDir(workspace, "vidmap.json");
        String vcfHeader = IOUtils.appendPathToDir(workspace, "vcfheader.vcf");
        IOUtils.assertPathsAreReadable(callsetJson, vidmapJson, vcfHeader);
        try {
            GenomicsDBExportConfiguration.ExportConfiguration exportConfigurationBuilder = GenomicsDBUtils.createExportConfiguration(workspace, callsetJson, vidmapJson, vcfHeader, genomicsDBOptions);
            if (genomicsDBOptions.useBCFCodec()) {
                return new GenomicsDBFeatureReader(exportConfigurationBuilder, (FeatureCodec)new BCF2Codec(), Optional.empty());
            }
            return new GenomicsDBFeatureReader(exportConfigurationBuilder, (FeatureCodec)new VCFCodec(), Optional.empty());
        }
        catch (IOException e) {
            throw new UserException("Couldn't create GenomicsDBFeatureReader", e);
        }
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        SAMSequenceDictionary dict = null;
        Object header = this.getHeader();
        if (header instanceof VCFHeader) {
            dict = ((VCFHeader)header).getSequenceDictionary();
        }
        if (dict != null && !dict.isEmpty()) {
            return dict;
        }
        if (this.hasIndex) {
            return IndexUtils.createSequenceDictionaryFromFeatureIndex(IOUtils.getPath(this.featureInput.getFeaturePath()));
        }
        return null;
    }

    public void setIntervalsForTraversal(List<SimpleInterval> intervals) {
        List<SimpleInterval> list = this.intervalsForTraversal = intervals != null && !intervals.isEmpty() ? intervals : null;
        if (this.intervalsForTraversal != null && !this.supportsRandomAccess) {
            throw new UserException("Input " + this.featureInput.getFeaturePath() + " must support random access to enable traversal by intervals. If it's a file, please index it using the bundled tool " + IndexFeatureFile.class.getSimpleName());
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.closeOpenIterationIfNecessary();
        try {
            this.currentIterator = this.intervalsForTraversal != null ? new FeatureIntervalIterator<T>(this.intervalsForTraversal, this.featureReader, this.featureInput.getFeaturePath()) : this.featureReader.iterator();
            return this.currentIterator;
        }
        catch (IOException e) {
            throw new GATKException("Error creating iterator over file " + this.featureInput.getFeaturePath(), e);
        }
    }

    @Override
    public Iterator<T> query(SimpleInterval interval) {
        return this.queryAndPrefetch(interval).iterator();
    }

    public List<T> queryAndPrefetch(Locatable interval) {
        if (!this.supportsRandomAccess) {
            throw new UserException("Input " + this.featureInput.getFeaturePath() + " must support random access to enable queries by interval. If it's a file, please index it using the bundled tool " + IndexFeatureFile.class.getSimpleName());
        }
        if (this.queryCache.cacheHit(interval)) {
            this.queryCache.trimToNewStartPosition(interval.getStart());
        } else {
            this.refillQueryCache(interval);
        }
        return this.queryCache.getCachedFeaturesUpToStopPosition(interval.getEnd());
    }

    private void refillQueryCache(Locatable interval) {
        this.closeOpenIterationIfNecessary();
        SimpleInterval queryInterval = new SimpleInterval(interval.getContig(), interval.getStart(), Math.addExact(interval.getEnd(), this.queryLookaheadBases));
        try (CloseableTribbleIterator queryIter = this.featureReader.query(queryInterval.getContig(), queryInterval.getStart(), queryInterval.getEnd());){
            this.queryCache.fill((Iterator<T>)queryIter, queryInterval);
        }
        catch (IOException e) {
            throw new GATKException("Error querying file " + this.featureInput + " over interval " + interval, e);
        }
    }

    public String getName() {
        return this.featureInput.getName();
    }

    public Object getHeader() {
        return this.featureReader.getHeader();
    }

    @Override
    public void close() {
        this.closeOpenIterationIfNecessary();
        logger.debug(String.format("Cache statistics for FeatureInput %s:", this.featureInput));
        this.queryCache.printCacheStatistics();
        try {
            if (this.featureReader != null) {
                this.featureReader.close();
            }
        }
        catch (IOException e) {
            throw new GATKException("Error closing Feature reader for input " + this.featureInput);
        }
    }

    private void closeOpenIterationIfNecessary() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator = null;
        }
    }
}

