/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class FeatureInput<T extends Feature>
extends GATKPath
implements Serializable {
    protected static final Logger logger = LogManager.getLogger(FeatureInput.class);
    private static final long serialVersionUID = 1L;
    private transient Class<FeatureCodec<T, ?>> featureCodecClass;
    public static final String FEATURE_ARGUMENT_TAG_DELIMITER = ":";

    FeatureInput(String rawArgumentValue) {
        super(rawArgumentValue);
        Utils.nonNull(rawArgumentValue, "rawArgumentValue");
    }

    public FeatureInput(GATKPath gatkPath) {
        super(gatkPath);
    }

    public FeatureInput(GATKPath gatkPath, String name) {
        super(gatkPath);
        Utils.nonNull(name, "name");
        if (gatkPath.getTag() != null) {
            logger.warn(String.format("FeatureInput: user-provided tag name %s will be replaced with %s", gatkPath.getTag(), name));
        }
        this.setTag(name);
    }

    FeatureInput(String featurePath, String name) {
        this(featurePath, name, Collections.emptyMap());
    }

    @VisibleForTesting
    public FeatureInput(String rawInputSpecifier, String name, Map<String, String> keyValueMap) {
        super(rawInputSpecifier);
        Utils.nonNull(name, "name");
        Utils.nonNull(keyValueMap, "kevValueMap");
        Utils.nonNull(rawInputSpecifier, "feature-file");
        this.setTag(name);
        this.setTagAttributes(keyValueMap);
    }

    public void setFeatureCodecClass(Class<FeatureCodec<T, ?>> featureCodecClass) {
        this.featureCodecClass = featureCodecClass;
    }

    public Class<FeatureCodec<T, ?>> getFeatureCodecClass() {
        return this.featureCodecClass;
    }

    private String makeIntoAbsolutePath() {
        if (IOUtils.isGenomicsDBPath(this)) {
            return IOUtils.getAbsolutePathWithGenomicsDBURIScheme(this);
        }
        if (this.getScheme() != null && !this.getScheme().equals("file")) {
            return this.toPath().toAbsolutePath().toUri().toString();
        }
        return this.getURI().getPath();
    }

    public String getAttribute(String key) {
        Utils.nonNull(key);
        return this.getTagAttributes().get(key);
    }

    public String getName() {
        return this.getTag() != null ? this.getTag() : this.makeIntoAbsolutePath();
    }

    public boolean hasUserSuppliedName() {
        return this.getTag() != null;
    }

    public String getFeaturePath() {
        return this.getRawInputString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.getRawInputString().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FeatureInput)) {
            return false;
        }
        FeatureInput otherFeature = (FeatureInput)other;
        return super.equals(otherFeature) && Objects.equals(this.getRawInputString(), otherFeature.getRawInputString());
    }

    @Override
    public String toString() {
        String featureFilePath = this.makeIntoAbsolutePath();
        return this.hasUserSuppliedName() ? String.format("%s%s%s", this.getTag(), FEATURE_ARGUMENT_TAG_DELIMITER, featureFilePath) : featureFilePath;
    }
}

