/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.SimpleInterval;

class FeatureIntervalIterator<T extends Feature>
implements CloseableTribbleIterator<T> {
    private final String sourceName;
    private final FeatureReader<T> featureReader;
    private final Iterator<SimpleInterval> intervalIterator;
    private CloseableTribbleIterator<T> featuresInCurrentInterval;
    private T nextFeature;
    private SimpleInterval currentInterval;
    private SimpleInterval previousInterval;

    public FeatureIntervalIterator(List<SimpleInterval> intervals, FeatureReader<T> featureReader, String sourceName) {
        this.intervalIterator = intervals.iterator();
        this.featureReader = featureReader;
        this.sourceName = sourceName;
        this.nextFeature = this.loadNextNovelFeature();
    }

    public boolean hasNext() {
        return this.nextFeature != null;
    }

    public T next() {
        if (this.nextFeature == null) {
            throw new NoSuchElementException("No more Features for current interval set");
        }
        T toReturn = this.nextFeature;
        this.nextFeature = this.loadNextNovelFeature();
        return toReturn;
    }

    private T loadNextNovelFeature() {
        T candidateFeature;
        do {
            if ((candidateFeature = this.loadNextFeature()) == null || !this.featureIsNovel(candidateFeature)) continue;
            return candidateFeature;
        } while (candidateFeature != null);
        return null;
    }

    private T loadNextFeature() {
        while (this.featuresInCurrentInterval == null || !this.featuresInCurrentInterval.hasNext()) {
            if (this.queryNextInterval()) continue;
            return null;
        }
        return (T)((Feature)this.featuresInCurrentInterval.next());
    }

    private boolean featureIsNovel(T feature) {
        return this.previousInterval == null || !this.previousInterval.overlaps(new SimpleInterval((Locatable)feature));
    }

    private boolean queryNextInterval() {
        if (this.featuresInCurrentInterval != null) {
            this.featuresInCurrentInterval.close();
            this.featuresInCurrentInterval = null;
        }
        if (!this.intervalIterator.hasNext()) {
            this.previousInterval = null;
            this.currentInterval = null;
            return false;
        }
        this.previousInterval = this.currentInterval;
        this.currentInterval = this.intervalIterator.next();
        try {
            this.featuresInCurrentInterval = this.featureReader.query(this.currentInterval.getContig(), this.currentInterval.getStart(), this.currentInterval.getEnd());
            return true;
        }
        catch (IOException e) {
            throw new GATKException("Error querying " + this.sourceName + " over interval " + this.currentInterval, e);
        }
    }

    public Iterator<T> iterator() {
        return this;
    }

    public void close() {
        if (this.featuresInCurrentInterval != null) {
            this.featuresInCurrentInterval.close();
        }
    }
}

