/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.ClassFinder;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.config.GATKConfig;

public final class FeatureManager
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(FeatureManager.class);
    private static final Class<FeatureCodec> CODEC_BASE_CLASS = FeatureCodec.class;
    private static final Set<Class<?>> DISCOVERED_CODECS;
    private static final Class<FeatureInput> FEATURE_ARGUMENT_CLASS;
    private final String toolInstanceSimpleClassName;
    private final Map<FeatureInput<? extends Feature>, FeatureDataSource<? extends Feature>> featureSources;

    public FeatureManager(CommandLineProgram toolInstance) {
        this(toolInstance, 1000);
    }

    public FeatureManager(CommandLineProgram toolInstance, int featureQueryLookahead) {
        this(toolInstance, featureQueryLookahead, 0, 0);
    }

    public FeatureManager(CommandLineProgram toolInstance, int featureQueryLookahead, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer) {
        this(toolInstance, featureQueryLookahead, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, null);
    }

    public FeatureManager(CommandLineProgram toolInstance, int featureQueryLookahead, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, GenomicsDBOptions gdbOptions) {
        this.toolInstanceSimpleClassName = toolInstance.getClass().getSimpleName();
        this.featureSources = new LinkedHashMap<FeatureInput<? extends Feature>, FeatureDataSource<? extends Feature>>();
        this.initializeFeatureSources(featureQueryLookahead, toolInstance, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, gdbOptions);
    }

    @VisibleForTesting
    FeatureManager(Map<FeatureInput<? extends Feature>, Class<? extends Feature>> featureInputsToTypeMap, String toolInstanceName, int featureQueryLookahead, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, Path reference) {
        Utils.nonNull(featureInputsToTypeMap);
        this.toolInstanceSimpleClassName = toolInstanceName;
        this.featureSources = new LinkedHashMap<FeatureInput<? extends Feature>, FeatureDataSource<? extends Feature>>();
        Utils.nonNull(featureInputsToTypeMap);
        featureInputsToTypeMap.forEach((k, v) -> this.addToFeatureSources(featureQueryLookahead, (FeatureInput<? extends Feature>)k, (Class<? extends Feature>)v, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, reference));
    }

    private void initializeFeatureSources(int featureQueryLookahead, CommandLineProgram toolInstance, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, GenomicsDBOptions gdbOptions) {
        List featureArgumentValues = toolInstance.getCommandLineParser().gatherArgumentValuesOfType(FEATURE_ARGUMENT_CLASS);
        for (Pair featureArgument : featureArgumentValues) {
            FeatureInput featureInput = (FeatureInput)featureArgument.getValue();
            if (featureInput == null) continue;
            Class<? extends Feature> featureType = FeatureManager.getFeatureTypeForFeatureInputArgument((ArgumentDefinition)featureArgument.getKey());
            this.addToFeatureSources(featureQueryLookahead, (FeatureInput<? extends Feature>)featureInput, featureType, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, gdbOptions);
        }
    }

    public void dumpAllFeatureCacheStats() {
        for (FeatureDataSource<? extends Feature> f : this.featureSources.values()) {
            f.printCacheStats();
        }
    }

    void addToFeatureSources(int featureQueryLookahead, FeatureInput<? extends Feature> featureInput, Class<? extends Feature> featureType, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, Path reference) {
        this.featureSources.put(featureInput, new FeatureDataSource<Feature>(featureInput, featureQueryLookahead, featureType, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, new GenomicsDBOptions(reference)));
    }

    void addToFeatureSources(int featureQueryLookahead, FeatureInput<? extends Feature> featureInput, Class<? extends Feature> featureType, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, GenomicsDBOptions genomicsDBOptions) {
        this.featureSources.put(featureInput, new FeatureDataSource<Feature>(featureInput, featureQueryLookahead, featureType, cloudPrefetchBuffer, cloudIndexPrefetchBuffer, genomicsDBOptions));
    }

    static Class<? extends Feature> getFeatureTypeForFeatureInputArgument(ArgumentDefinition argDef) {
        Type featureInputType;
        Type type = featureInputType = argDef.isCollection() ? FeatureManager.getNextTypeParameter((ParameterizedType)argDef.getUnderlyingField().getGenericType()) : argDef.getUnderlyingField().getGenericType();
        if (!(featureInputType instanceof ParameterizedType)) {
            throw new GATKException(String.format("FeatureInput declaration for argument --%s lacks an explicit type parameter for the Feature type", argDef.getUnderlyingField().getAnnotation(Argument.class).fullName()));
        }
        return (Class)FeatureManager.getNextTypeParameter((ParameterizedType)featureInputType);
    }

    private static Type getNextTypeParameter(ParameterizedType parameterizedType) {
        Type[] typeParameters = parameterizedType.getActualTypeArguments();
        if (typeParameters.length != 1) {
            throw new GATKException("Found a FeatureInput declaration with multiple type parameters, which is not supported");
        }
        return typeParameters[0];
    }

    public boolean isEmpty() {
        return this.featureSources.isEmpty();
    }

    public List<VCFHeader> getAllVariantHeaders() {
        return this.featureSources.values().stream().map(feature -> feature.getHeader()).filter(header -> header instanceof VCFHeader).map(header -> (VCFHeader)header).collect(Collectors.toList());
    }

    public List<SAMSequenceDictionary> getVariantSequenceDictionaries() {
        return this.getAllVariantHeaders().stream().map(h -> h.getSequenceDictionary()).filter(dict -> dict != null).collect(Collectors.toList());
    }

    public List<SAMSequenceDictionary> getAllSequenceDictionaries() {
        return this.featureSources.values().stream().map(fs -> fs.getSequenceDictionary()).filter(dict -> dict != null).collect(Collectors.toList());
    }

    public <T extends Feature> List<T> getFeatures(FeatureInput<T> featureDescriptor, Locatable interval) {
        FeatureDataSource<T> dataSource = this.lookupDataSource(featureDescriptor);
        return dataSource.queryAndPrefetch(interval);
    }

    public <T extends Feature> Iterator<T> getFeatureIterator(FeatureInput<T> featureDescriptor) {
        FeatureDataSource<T> dataSource = this.lookupDataSource(featureDescriptor);
        return dataSource.iterator();
    }

    public <T extends Feature> Object getHeader(FeatureInput<T> featureDescriptor) {
        FeatureDataSource<T> dataSource = this.lookupDataSource(featureDescriptor);
        return dataSource.getHeader();
    }

    private <T extends Feature> FeatureDataSource<T> lookupDataSource(FeatureInput<T> featureDescriptor) {
        FeatureDataSource<? extends Feature> dataSource = this.featureSources.get(featureDescriptor);
        if (dataSource == null) {
            throw new GATKException(String.format("FeatureInput %s not found in feature manager's database for tool %s. In order to be detected, FeatureInputs must be declared in the tool class itself, a superclass of the tool class, or an @ArgumentCollection declared in the tool class or a superclass. They must also be annotated as an @Argument.", featureDescriptor.getName(), this.toolInstanceSimpleClassName));
        }
        return dataSource;
    }

    public static FeatureCodec<? extends Feature, ?> getCodecForFile(Path featurePath) {
        return FeatureManager.getCodecForFile(featurePath, null);
    }

    public static FeatureCodec<? extends Feature, ?> getCodecForFile(Path featurePath, Class<? extends Feature> featureType) {
        if (!Files.isReadable(featurePath)) {
            throw new UserException.CouldNotReadInputFile(featurePath.toUri().toString());
        }
        List<FeatureCodec<Feature, ?>> candidateCodecs = FeatureManager.getCandidateCodecsForFile(featurePath);
        if (candidateCodecs.isEmpty()) {
            throw new UserException.NoSuitableCodecs(featurePath);
        }
        if (featureType != null) {
            List<String> discoveredCodecsFeatureTypes = candidateCodecs.stream().map(codec -> codec.getFeatureType().getSimpleName()).collect(Collectors.toList());
            candidateCodecs.removeIf(codec -> !featureType.isAssignableFrom(codec.getFeatureType()));
            if (candidateCodecs.isEmpty()) {
                throw new UserException.WrongFeatureType(featurePath, featureType, discoveredCodecsFeatureTypes);
            }
        }
        if (candidateCodecs.size() > 1) {
            StringBuilder multiCodecMatches = new StringBuilder();
            for (FeatureCodec<Feature, ?> candidateCodec : candidateCodecs) {
                multiCodecMatches.append(candidateCodec.getClass().getCanonicalName());
                multiCodecMatches.append(' ');
            }
            throw new GATKException("Multiple codecs found able to decode file " + featurePath.toAbsolutePath().toUri() + ". This indicates a misconfiguration on the part of the codec authors. Matching codecs are: " + multiCodecMatches.toString());
        }
        FeatureCodec<Feature, ?> selectedCodec = candidateCodecs.get(0);
        logger.info("Using codec " + selectedCodec.getClass().getSimpleName() + " to read file " + featurePath.toAbsolutePath().toUri());
        return selectedCodec;
    }

    private static List<FeatureCodec<? extends Feature, ?>> getCandidateCodecsForFile(Path featureFile) {
        ArrayList candidateCodecs = new ArrayList();
        for (Class<?> codecClass : DISCOVERED_CODECS) {
            try {
                FeatureCodec codec = (FeatureCodec)codecClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!codec.canDecode(featureFile.toAbsolutePath().toUri().toString())) continue;
                candidateCodecs.add(codec);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new GATKException("Unable to automatically instantiate codec " + codecClass.getName());
            }
        }
        return candidateCodecs;
    }

    public static boolean isFeatureFile(Path file) {
        return Files.exists(file, new LinkOption[0]) && !FeatureManager.getCandidateCodecsForFile(file).isEmpty();
    }

    @Override
    public void close() {
        this.featureSources.values().forEach(ds -> ds.close());
    }

    static {
        FEATURE_ARGUMENT_CLASS = FeatureInput.class;
        GATKConfig config = ConfigFactory.getInstance().getGATKConfig();
        ClassFinder finder = new ClassFinder();
        for (String codecPackage : config.codec_packages()) {
            finder.find(codecPackage, CODEC_BASE_CLASS);
        }
        DISCOVERED_CODECS = Collections.unmodifiableSet(finder.getConcreteClasses());
    }
}

