/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class FeatureWalker<F extends Feature>
extends WalkerBase {
    private FeatureDataSource<F> drivingFeatures;
    private Object header;

    @Override
    public boolean requiresFeatures() {
        return true;
    }

    @Override
    public String getProgressMeterRecordLabel() {
        return "features";
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 1000, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        this.initializeDrivingFeatures();
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        if (this.hasUserSuppliedIntervals()) {
            this.drivingFeatures.setIntervalsForTraversal(this.userIntervals);
        }
    }

    private void initializeDrivingFeatures() {
        GATKPath drivingPath = this.getDrivingFeaturePath();
        FeatureCodec<? extends Feature, ?> codec = FeatureManager.getCodecForFile(drivingPath.toPath());
        if (!this.isAcceptableFeatureType(codec.getFeatureType())) {
            throw new UserException("File " + drivingPath.getRawInputString() + " contains features of the wrong type.");
        }
        this.drivingFeatures = new FeatureDataSource(new FeatureInput(drivingPath), 1000, null, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.referenceArguments.getReferencePath());
        FeatureInput drivingFeaturesInput = new FeatureInput(drivingPath, "drivingFeatureFile");
        this.features.addToFeatureSources(0, drivingFeaturesInput, (Class<? extends Feature>)codec.getFeatureType(), this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.referenceArguments.getReferencePath());
        this.header = this.getHeaderForFeatures(drivingFeaturesInput);
    }

    protected abstract boolean isAcceptableFeatureType(Class<? extends Feature> var1);

    @Override
    public void traverse() {
        CountingReadFilter readFilter = this.makeReadFilter();
        Utils.stream(this.drivingFeatures).forEach(feature -> {
            SimpleInterval featureInterval = this.makeFeatureInterval(feature);
            this.apply(feature, new ReadsContext(this.reads, featureInterval, readFilter), new ReferenceContext(this.reference, featureInterval), new FeatureContext(this.features, featureInterval));
            this.progressMeter.update((Locatable)feature);
        });
    }

    protected <T extends Feature> SimpleInterval makeFeatureInterval(T feature) {
        return new SimpleInterval((Locatable)feature);
    }

    public abstract void apply(F var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
        if (this.drivingFeatures != null) {
            this.drivingFeatures.close();
        }
    }

    public abstract GATKPath getDrivingFeaturePath();

    public Object getDrivingFeaturesHeader() {
        return this.header;
    }
}

