/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.io.HtsPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.broadinstitute.barclay.argparser.TaggedArgument;
import org.broadinstitute.barclay.argparser.TaggedArgumentParser;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

public class GATKPath
extends HtsPath
implements TaggedArgument,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String HDFS_SCHEME = "hdfs";
    private String tagName;
    private Map<String, String> tagAttributes;

    public GATKPath(String uriString) {
        super(uriString);
    }

    public GATKPath(GATKPath sourceGATKPath) {
        super((HtsPath)sourceGATKPath);
        Map<String, String> sourceTagMap;
        if (sourceGATKPath.getTag() != null) {
            this.setTag(sourceGATKPath.getTag());
        }
        if ((sourceTagMap = sourceGATKPath.getTagAttributes()) != null) {
            this.setTagAttributes(new HashMap<String, String>(sourceTagMap));
        }
    }

    public java.nio.file.Path toPath() {
        if ("gs".equals(this.getURI().getScheme())) {
            java.nio.file.Path tempPath = BucketUtils.getPathOnGcs(this.getURIString());
            this.setCachedPath(tempPath);
            return tempPath;
        }
        try {
            return super.toPath();
        }
        catch (FileSystemNotFoundException e) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    throw e;
                }
                return FileSystems.newFileSystem(this.getURI(), new HashMap(), cl).provider().getPath(this.getURI());
            }
            catch (IOException ioe) {
                throw new GATKException("IOException loading new file system", ioe);
            }
        }
    }

    public InputStream getInputStream() {
        if (!this.isPath()) {
            throw new UserException(this.getToPathFailureReason());
        }
        try {
            InputStream inputStream;
            if (this.getURI().getScheme().equals(HDFS_SCHEME)) {
                Path file = new Path(this.getURIString());
                FileSystem fs = file.getFileSystem(new Configuration());
                inputStream = fs.open(file);
            } else {
                inputStream = super.getInputStream();
            }
            return inputStream;
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this, "Can't create input stream", (Throwable)e);
        }
    }

    public OutputStream getOutputStream() {
        if (!this.isPath()) {
            throw new UserException(this.getToPathFailureReason());
        }
        try {
            if (this.getURI().getScheme().equals(HDFS_SCHEME)) {
                Path fsPath = new Path(this.getURIString());
                FileSystem fs = fsPath.getFileSystem(new Configuration());
                return fs.create(fsPath);
            }
            OutputStream outputStream = super.getOutputStream();
            return outputStream;
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.getRawInputString(), (Exception)e);
        }
    }

    public boolean isHadoopURL() {
        return this.getScheme().equals(HDFS_SCHEME);
    }

    public void setTag(String tagName) {
        this.tagName = tagName;
    }

    public String getTag() {
        return this.tagName;
    }

    public void setTagAttributes(Map<String, String> attributes) {
        this.tagAttributes = attributes;
    }

    public Map<String, String> getTagAttributes() {
        return this.tagAttributes;
    }

    public String toString() {
        if (this.getTagAttributes() != null) {
            return super.toString() + TaggedArgumentParser.getDisplayString((String)"", (TaggedArgument)this);
        }
        return super.toString();
    }

    static boolean tagNameAndAttributesAreEqual(TaggedArgument first, TaggedArgument second) {
        return Objects.equals(first.getTag(), second.getTag()) && Objects.equals(first.getTagAttributes(), second.getTagAttributes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GATKPath)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return GATKPath.tagNameAndAttributesAreEqual(this, (GATKPath)o);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = this.tagName == null ? result : 31 * result + this.tagName.hashCode();
        result = this.getTagAttributes() == null ? result : 31 * result + this.getTagAttributes().hashCode();
        return result;
    }
}

