/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.io.IOPath;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.File;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKAnnotationPluginDescriptor;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKReadFilterPluginDescriptor;
import org.broadinstitute.hellbender.cmdline.argumentcollections.IntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalIntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalReadInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.ReadInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.ReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredIntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredReadInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.SequenceDictionaryValidationArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ProgressMeter;
import org.broadinstitute.hellbender.engine.ReadsDataSource;
import org.broadinstitute.hellbender.engine.ReadsPathDataSource;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public abstract class GATKTool
extends CommandLineProgram {
    @ArgumentCollection
    protected IntervalArgumentCollection intervalArgumentCollection = this.requiresIntervals() ? new RequiredIntervalArgumentCollection() : new OptionalIntervalArgumentCollection();
    @ArgumentCollection
    protected final ReadInputArgumentCollection readArguments = this.requiresReads() ? new RequiredReadInputArgumentCollection() : new OptionalReadInputArgumentCollection();
    @ArgumentCollection
    protected final ReferenceInputArgumentCollection referenceArguments = this.requiresReference() ? new RequiredReferenceInputArgumentCollection() : new OptionalReferenceInputArgumentCollection();
    @Argument(fullName="sequence-dictionary", shortName="sequence-dictionary", doc="Use the given sequence dictionary as the master/canonical sequence dictionary.  Must be a .dict file.", optional=true, common=true)
    private GATKPath masterSequenceDictionaryFilename = null;
    public static final String SECONDS_BETWEEN_PROGRESS_UPDATES_NAME = "seconds-between-progress-updates";
    @Argument(fullName="seconds-between-progress-updates", shortName="seconds-between-progress-updates", doc="Output traversal statistics every time this many seconds elapse", optional=true, common=true)
    private double secondsBetweenProgressUpdates = 10.0;
    @ArgumentCollection
    protected SequenceDictionaryValidationArgumentCollection seqValidationArguments = this.getSequenceDictionaryValidationArgumentCollection();
    @Argument(fullName="create-output-bam-index", shortName="OBI", doc="If true, create a BAM/CRAM index when writing a coordinate-sorted BAM/CRAM file.", optional=true, common=true)
    public boolean createOutputBamIndex = ConfigFactory.getInstance().getGATKConfig().createOutputBamIndex();
    @Argument(fullName="create-output-bam-md5", shortName="OBM", doc="If true, create a MD5 digest for any BAM/SAM/CRAM file created", optional=true, common=true)
    public boolean createOutputBamMD5 = false;
    @Argument(fullName="create-output-variant-index", shortName="OVI", doc="If true, create a VCF index when writing a coordinate-sorted VCF file.", optional=true, common=true)
    public boolean createOutputVariantIndex = true;
    @Argument(fullName="create-output-variant-md5", shortName="OVM", doc="If true, create a a MD5 digest any VCF file created.", optional=true, common=true)
    public boolean createOutputVariantMD5 = false;
    @Argument(fullName="lenient", shortName="LE", doc="Lenient processing of VCF files", common=true, optional=true)
    protected boolean lenientVCFProcessing = false;
    @Argument(fullName="add-output-sam-program-record", shortName="add-output-sam-program-record", doc="If true, adds a PG tag to created SAM/BAM/CRAM files.", optional=true, common=true)
    public boolean addOutputSAMProgramRecord = true;
    @Argument(fullName="add-output-vcf-command-line", shortName="add-output-vcf-command-line", doc="If true, adds a command line header line to created VCF files.", optional=true, common=true)
    public boolean addOutputVCFCommandLine = true;
    @Argument(fullName="cloud-prefetch-buffer", shortName="CPB", doc="Size of the cloud-only prefetch buffer (in MB; 0 to disable).", optional=true)
    public int cloudPrefetchBuffer = this.getDefaultCloudPrefetchBufferSize();
    @Argument(fullName="cloud-index-prefetch-buffer", shortName="CIPB", doc="Size of the cloud-only prefetch buffer (in MB; 0 to disable). Defaults to cloudPrefetchBuffer if unset.", optional=true)
    public int cloudIndexPrefetchBuffer = this.getDefaultCloudIndexPrefetchBufferSize();
    @Argument(fullName="disable-bam-index-caching", shortName="DBIC", doc="If true, don't cache bam indexes, this will reduce memory requirements but may harm performance if many intervals are specified.  Caching is automatically disabled if there are no intervals specified.", optional=true)
    public boolean disableBamIndexCaching = false;
    @Argument(fullName="sites-only-vcf-output", doc="If true, don't emit genotype fields when writing vcf file output.", optional=true)
    public boolean outputSitesOnlyVCFs = false;
    private SAMSequenceDictionary masterSequenceDictionary = null;
    ReferenceDataSource reference;
    ReadsDataSource reads;
    public FeatureManager features;
    List<SimpleInterval> userIntervals;
    protected ProgressMeter progressMeter;

    protected ReferenceDataSource directlyAccessEngineReferenceDataSource() {
        if (this.reference == null) {
            throw new GATKException("Attempted to retrieve null reference!");
        }
        return this.reference;
    }

    protected ReadsDataSource directlyAccessEngineReadsDataSource() {
        if (this.reads == null) {
            throw new GATKException("Attempted to retrieve null reads!");
        }
        return this.reads;
    }

    protected FeatureManager directlyAccessEngineFeatureManager() {
        if (this.features == null) {
            throw new GATKException("Attempted to retrieve null features!");
        }
        return this.features;
    }

    @Override
    public List<? extends CommandLinePluginDescriptor<?>> getPluginDescriptors() {
        GATKReadFilterPluginDescriptor readFilterDescriptor = new GATKReadFilterPluginDescriptor(this.getDefaultReadFilters());
        return this.useVariantAnnotations() ? Arrays.asList(new CommandLinePluginDescriptor[]{readFilterDescriptor, new GATKAnnotationPluginDescriptor(this.getDefaultVariantAnnotations(), this.getDefaultVariantAnnotationGroups())}) : Collections.singletonList(readFilterDescriptor);
    }

    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(new WellformedReadFilter());
    }

    public CountingReadFilter makeReadFilter() {
        GATKReadFilterPluginDescriptor readFilterPlugin = (GATKReadFilterPluginDescriptor)((Object)this.getCommandLineParser().getPluginDescriptor(GATKReadFilterPluginDescriptor.class));
        return this.hasReads() ? readFilterPlugin.getMergedCountingReadFilter(this.getHeaderForReads()) : new CountingReadFilter(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    public boolean useVariantAnnotations() {
        return false;
    }

    public List<Annotation> getDefaultVariantAnnotations() {
        return Collections.emptyList();
    }

    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return Collections.emptyList();
    }

    public Collection<Annotation> makeVariantAnnotations() {
        if (!this.useVariantAnnotations()) {
            throw new GATKException("Tool requested variant annotations but has not overridden 'useVariantAnnotations()' to return true");
        }
        GATKAnnotationPluginDescriptor annotationPlugin = (GATKAnnotationPluginDescriptor)((Object)this.getCommandLineParser().getPluginDescriptor(GATKAnnotationPluginDescriptor.class));
        return annotationPlugin.getResolvedInstances();
    }

    public ReadTransformer makePreReadFilterTransformer() {
        return ReadTransformer.identity();
    }

    public ReadTransformer makePostReadFilterTransformer() {
        return ReadTransformer.identity();
    }

    protected Stream<GATKRead> getTransformedReadStream(ReadFilter filter) {
        if (this.hasReads()) {
            ReadTransformer preTransformer = this.makePreReadFilterTransformer();
            ReadTransformer postTransformer = this.makePostReadFilterTransformer();
            return Utils.stream(this.reads).map(preTransformer).filter(filter).map(postTransformer);
        }
        return Stream.empty();
    }

    public int getDefaultCloudPrefetchBufferSize() {
        return ConfigFactory.getInstance().getGATKConfig().cloudPrefetchBuffer();
    }

    public int getDefaultCloudIndexPrefetchBufferSize() {
        return ConfigFactory.getInstance().getGATKConfig().cloudIndexPrefetchBuffer();
    }

    public String getProgressMeterRecordLabel() {
        return "records";
    }

    protected List<SimpleInterval> transformTraversalIntervals(List<SimpleInterval> getIntervals, SAMSequenceDictionary sequenceDictionary) {
        return getIntervals;
    }

    protected GenomicsDBOptions getGenomicsDBOptions() {
        return new GenomicsDBOptions(this.referenceArguments.getReferencePath());
    }

    void initializeReference() {
        this.reference = this.referenceArguments.getReferencePath() != null ? ReferenceDataSource.of(this.referenceArguments.getReferencePath()) : null;
    }

    void initializeReads() {
        if (!this.readArguments.getReadPathSpecifiers().isEmpty()) {
            SamReaderFactory factory = SamReaderFactory.makeDefault().validationStringency(this.readArguments.getReadValidationStringency());
            if (this.hasReference()) {
                factory = factory.referenceSequence(this.referenceArguments.getReferencePath());
            } else if (this.hasCramInput()) {
                throw UserException.MISSING_REFERENCE_FOR_CRAM;
            }
            if (this.bamIndexCachingShouldBeEnabled()) {
                factory = factory.enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES});
            }
            this.reads = new ReadsPathDataSource(this.readArguments.getReadPaths(), this.readArguments.getReadIndexPaths(), factory, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer < 0 ? this.cloudPrefetchBuffer : this.cloudIndexPrefetchBuffer);
        } else {
            this.reads = null;
        }
    }

    private boolean bamIndexCachingShouldBeEnabled() {
        return this.intervalArgumentCollection.intervalsSpecified() && !this.disableBamIndexCaching;
    }

    private boolean hasCramInput() {
        return this.readArguments.getReadPathSpecifiers().stream().anyMatch(IOPath::isCram);
    }

    void initializeFeatures() {
        this.features = new FeatureManager(this, 1000, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    void initializeIntervals() {
        if (this.intervalArgumentCollection.intervalsSpecified()) {
            SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
            if (sequenceDictionary == null) {
                throw new UserException("We require a sequence dictionary from a reference, a source of reads, or a source of variants to process intervals.  Since reference and reads files generally contain sequence dictionaries, this error most commonly occurs for VariantWalkers that do not require a reference or reads.  You can fix the problem by passing a reference file with a sequence dictionary via the -R argument or you can run the tool UpdateVCFSequenceDictionary on your vcf.");
            }
            this.userIntervals = this.transformTraversalIntervals(this.intervalArgumentCollection.getIntervals(sequenceDictionary), sequenceDictionary);
        }
    }

    public final boolean hasReference() {
        return this.reference != null;
    }

    public final boolean hasReads() {
        return this.reads != null;
    }

    public final boolean hasFeatures() {
        return this.features != null;
    }

    public final boolean hasUserSuppliedIntervals() {
        return this.userIntervals != null;
    }

    public boolean requiresReference() {
        return false;
    }

    public boolean requiresFeatures() {
        return false;
    }

    public boolean requiresReads() {
        return false;
    }

    public boolean requiresIntervals() {
        return false;
    }

    protected SequenceDictionaryValidationArgumentCollection getSequenceDictionaryValidationArgumentCollection() {
        return new SequenceDictionaryValidationArgumentCollection.StandardValidationCollection();
    }

    private void loadMasterSequenceDictionary() {
        if (this.masterSequenceDictionary == null && this.masterSequenceDictionaryFilename != null) {
            this.masterSequenceDictionary = ReferenceUtils.loadFastaDictionary(this.masterSequenceDictionaryFilename);
        }
    }

    public final SAMSequenceDictionary getReferenceDictionary() {
        return this.reference != null ? this.reference.getSequenceDictionary() : null;
    }

    public final SAMSequenceDictionary getMasterSequenceDictionary() {
        return this.masterSequenceDictionary;
    }

    public SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        List<SAMSequenceDictionary> dictionaries;
        if (this.masterSequenceDictionary != null) {
            return this.masterSequenceDictionary;
        }
        if (this.hasReference()) {
            return this.reference.getSequenceDictionary();
        }
        if (this.hasReads()) {
            return this.reads.getSequenceDictionary();
        }
        if (this.hasFeatures() && (dictionaries = this.features.getVariantSequenceDictionaries()).size() == 1) {
            return dictionaries.get(0);
        }
        return null;
    }

    public final SAMFileHeader getHeaderForReads() {
        return this.hasReads() ? this.reads.getHeader() : null;
    }

    public final <T extends Feature> Object getHeaderForFeatures(FeatureInput<T> featureDescriptor) {
        return this.hasFeatures() ? this.features.getHeader(featureDescriptor) : null;
    }

    @Override
    protected void onStartup() {
        super.onStartup();
        this.loadMasterSequenceDictionary();
        this.initializeReference();
        this.initializeReads();
        this.initializeFeatures();
        this.initializeIntervals();
        if (this.seqValidationArguments.performSequenceDictionaryValidation()) {
            this.validateSequenceDictionaries();
        }
        this.checkToolRequirements();
        this.initializeProgressMeter(this.getProgressMeterRecordLabel());
    }

    protected final void initializeProgressMeter(String progressMeterRecordLabel) {
        this.progressMeter = new ProgressMeter(this.secondsBetweenProgressUpdates);
        this.progressMeter.setRecordLabel(progressMeterRecordLabel);
    }

    private void validateSequenceDictionaries() {
        List<SAMSequenceDictionary> featureDicts;
        SAMSequenceDictionary refDict = this.hasReference() ? this.reference.getSequenceDictionary() : null;
        SAMSequenceDictionary readDict = this.hasReads() ? this.reads.getSequenceDictionary() : null;
        List<SAMSequenceDictionary> list = featureDicts = this.hasFeatures() ? this.features.getAllSequenceDictionaries() : Collections.emptyList();
        if (this.masterSequenceDictionary != null) {
            boolean requireMasterDictionaryIsSuperSet = this.hasCramInput();
            if (this.hasReads()) {
                SequenceDictionaryUtils.validateDictionaries("master sequence dictionary", this.masterSequenceDictionary, "reads", readDict, requireMasterDictionaryIsSuperSet, false);
            }
            if (this.hasReference()) {
                SequenceDictionaryUtils.validateDictionaries("master sequence dictionary", this.masterSequenceDictionary, "reference", refDict, requireMasterDictionaryIsSuperSet, false);
            }
            for (SAMSequenceDictionary featureDict : featureDicts) {
                SequenceDictionaryUtils.validateDictionaries("master sequence dictionary", this.masterSequenceDictionary, "features", featureDict);
            }
        }
        if (this.hasReference() && this.hasReads()) {
            if (this.hasCramInput()) {
                SequenceDictionaryUtils.validateCRAMDictionaryAgainstReference(refDict, readDict);
            } else {
                SequenceDictionaryUtils.validateDictionaries("reference", refDict, "reads", readDict);
            }
        }
        SAMSequenceDictionary bestDict = this.getBestAvailableSequenceDictionary();
        for (SAMSequenceDictionary featureDict : featureDicts) {
            if (this.hasReference()) {
                SequenceDictionaryUtils.validateDictionaries("reference", refDict, "features", featureDict);
            }
            if (this.hasReads()) {
                SequenceDictionaryUtils.validateDictionaries("reads", readDict, "features", featureDict);
            }
            if (bestDict == null) continue;
            SequenceDictionaryUtils.validateDictionaries("best available", bestDict, "features", featureDict);
        }
    }

    private void checkToolRequirements() {
        if (this.requiresFeatures() && !this.hasFeatures()) {
            throw new UserException("Tool " + this.getClass().getSimpleName() + " requires features, but none were provided");
        }
    }

    public final SAMFileGATKReadWriter createSAMWriter(GATKPath outputPathSpecifier, boolean preSorted) {
        if (!this.hasReference() && outputPathSpecifier.isCram()) {
            throw UserException.MISSING_REFERENCE_FOR_CRAM;
        }
        return new SAMFileGATKReadWriter(ReadUtils.createCommonSAMWriter(outputPathSpecifier.toPath(), this.referenceArguments.getReferencePath(), this.getHeaderForSAMWriter(), preSorted, this.createOutputBamIndex, this.createOutputBamMD5));
    }

    public VariantContextWriter createVCFWriter(File outFile) {
        return this.createVCFWriter(outFile == null ? null : outFile.toPath());
    }

    public VariantContextWriter createVCFWriter(GATKPath outFile) {
        return this.createVCFWriter(outFile == null ? null : outFile.toPath());
    }

    public VariantContextWriter createVCFWriter(Path outPath) {
        Utils.nonNull(outPath);
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        ArrayList<Options> options = new ArrayList<Options>();
        if (this.lenientVCFProcessing) {
            options.add(Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        }
        if (this.createOutputVariantIndex) {
            if (null == sequenceDictionary) {
                this.logger.warn("A variant index will not be created - a sequence dictionary is required to create an output index");
            } else {
                options.add(Options.INDEX_ON_THE_FLY);
            }
        }
        if (this.outputSitesOnlyVCFs) {
            options.add(Options.DO_NOT_WRITE_GENOTYPES);
        }
        return GATKVariantContextUtils.createVCFWriter(outPath, sequenceDictionary, this.createOutputVariantMD5, options.toArray(new Options[options.size()]));
    }

    protected SAMFileHeader getHeaderForSAMWriter() {
        SAMFileHeader header;
        SAMFileHeader sAMFileHeader = header = this.getHeaderForReads() == null ? new SAMFileHeader() : this.getHeaderForReads();
        if (this.addOutputSAMProgramRecord) {
            SAMProgramRecord programRecord = new SAMProgramRecord(this.createProgramGroupID(header));
            programRecord.setProgramVersion(this.getVersion());
            programRecord.setCommandLine(this.getCommandLine());
            programRecord.setProgramName(this.getToolName());
            header.addProgramRecord(programRecord);
        }
        return header;
    }

    protected Set<VCFHeaderLine> getDefaultToolVCFHeaderLines() {
        if (this.addOutputVCFCommandLine) {
            return GATKVariantContextUtils.getDefaultVCFHeaderLines(this.getToolkitShortName(), this.getClass().getSimpleName(), this.getVersion(), Utils.getDateTimeForDisplay(ZonedDateTime.now()), this.getCommandLine());
        }
        return new HashSet<VCFHeaderLine>();
    }

    private String createProgramGroupID(SAMFileHeader header) {
        String toolName;
        String pgID = toolName = this.getToolName();
        SAMProgramRecord record = header.getProgramRecord(pgID);
        int count = 1;
        while (record != null) {
            pgID = toolName + "." + String.valueOf(count++);
            record = header.getProgramRecord(pgID);
        }
        return pgID;
    }

    public FeatureInput<? extends Feature> addFeatureInputsAfterInitialization(String filePath, String name, Class<? extends Feature> featureType, int featureQueryLookahead) {
        FeatureInput featureInput = new FeatureInput(filePath, name);
        this.features.addToFeatureSources(featureQueryLookahead, featureInput, featureType, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.referenceArguments.getReferencePath());
        return featureInput;
    }

    public String getToolName() {
        return String.format("%s %s", this.getToolkitShortName(), this.getClass().getSimpleName());
    }

    public List<SimpleInterval> getTraversalIntervals() {
        return this.hasUserSuppliedIntervals() ? this.userIntervals : (this.hasReference() ? IntervalUtils.getAllIntervalsForReference(this.getReferenceDictionary()) : null);
    }

    @Override
    protected void onShutdown() {
        super.onShutdown();
        if (this.hasReference()) {
            this.reference.close();
        }
        if (this.hasReads()) {
            this.reads.close();
        }
        if (this.hasFeatures()) {
            this.features.close();
        }
    }

    public void onTraversalStart() {
    }

    public abstract void traverse();

    public Object onTraversalSuccess() {
        return null;
    }

    @Override
    protected final Object doWork() {
        try {
            this.onTraversalStart();
            this.progressMeter.start();
            this.traverse();
            if (!this.progressMeter.stopped()) {
                this.progressMeter.stop();
            }
            Object object = this.onTraversalSuccess();
            return object;
        }
        finally {
            this.closeTool();
        }
    }

    public void closeTool() {
    }
}

