/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class IntervalWalker
extends WalkerBase {
    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public String getProgressMeterRecordLabel() {
        return "intervals";
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 0, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
    }

    @Override
    public void traverse() {
        CountingReadFilter readFilter = this.makeReadFilter();
        for (SimpleInterval interval : this.userIntervals) {
            this.apply(interval, new ReadsContext(this.reads, interval, readFilter), new ReferenceContext(this.reference, interval), new FeatureContext(this.features, interval));
            this.progressMeter.update(interval);
        }
    }

    public abstract void apply(SimpleInterval var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
    }
}

