/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentContextIteratorBuilder;
import org.broadinstitute.hellbender.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.hellbender.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class LocusWalker
extends WalkerBase {
    public static final String MAX_DEPTH_PER_SAMPLE_NAME = "max-depth-per-sample";
    @Argument(fullName="max-depth-per-sample", shortName="max-depth-per-sample", doc="Maximum number of reads to retain per sample per locus. Reads above this threshold will be downsampled. Set to 0 to disable.", optional=true)
    protected int maxDepthPerSample = this.defaultMaxDepthPerSample();

    protected boolean keepUniqueReadListInLibs() {
        return false;
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public String getProgressMeterRecordLabel() {
        return "loci";
    }

    public boolean includeDeletions() {
        return true;
    }

    public boolean includeNs() {
        return false;
    }

    public boolean emitEmptyLoci() {
        return false;
    }

    protected int defaultMaxDepthPerSample() {
        return 0;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> defaultFilters = new ArrayList<ReadFilter>(2);
        defaultFilters.add(new WellformedReadFilter());
        defaultFilters.add(new ReadFilterLibrary.MappedReadFilter());
        return defaultFilters;
    }

    protected final LIBSDownsamplingInfo getDownsamplingInfo() {
        if (this.maxDepthPerSample < 0) {
            throw new CommandLineException.BadArgumentValue(MAX_DEPTH_PER_SAMPLE_NAME, String.valueOf(this.maxDepthPerSample), "should be a positive number");
        }
        return this.maxDepthPerSample == 0 ? LocusIteratorByState.NO_DOWNSAMPLING : new LIBSDownsamplingInfo(true, this.maxDepthPerSample);
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        if (this.hasUserSuppliedIntervals()) {
            this.reads.setTraversalBounds(this.intervalArgumentCollection.getTraversalParameters(this.getHeaderForReads().getSequenceDictionary()));
        }
    }

    @Override
    public void traverse() {
        CountingReadFilter countedFilter = this.makeReadFilter();
        Iterator<AlignmentContext> iterator = this.getAlignmentContextIterator(countedFilter);
        iterator.forEachRemaining(alignmentContext -> {
            SimpleInterval alignmentInterval = new SimpleInterval((Locatable)alignmentContext);
            this.apply((AlignmentContext)alignmentContext, new ReferenceContext(this.reference, alignmentInterval), new FeatureContext(this.features, alignmentInterval));
            this.progressMeter.update(alignmentInterval);
        });
        this.logger.info(countedFilter.getSummaryLine());
    }

    final Iterator<AlignmentContext> getAlignmentContextIterator(CountingReadFilter readFilterToUse) {
        SAMFileHeader header = this.getHeaderForReads();
        Set samples = header.getReadGroups().stream().map(SAMReadGroupRecord::getSample).collect(Collectors.toSet());
        Iterator<GATKRead> readIterator = this.getTransformedReadStream(readFilterToUse).iterator();
        AlignmentContextIteratorBuilder alignmentContextIteratorBuilder = new AlignmentContextIteratorBuilder();
        alignmentContextIteratorBuilder.setDownsamplingInfo(this.getDownsamplingInfo());
        alignmentContextIteratorBuilder.setEmitEmptyLoci(this.emitEmptyLoci());
        alignmentContextIteratorBuilder.setIncludeDeletions(this.includeDeletions());
        alignmentContextIteratorBuilder.setKeepUniqueReadListInLibs(this.keepUniqueReadListInLibs());
        alignmentContextIteratorBuilder.setIncludeNs(this.includeNs());
        return alignmentContextIteratorBuilder.build(readIterator, header, this.userIntervals, this.getBestAvailableSequenceDictionary(), this.hasReference());
    }

    public abstract void apply(AlignmentContext var1, ReferenceContext var2, FeatureContext var3);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
    }
}

