/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class LocusWalkerByInterval
extends LocusWalker {
    private OverlapDetector<Locatable> intervalsToTrack = null;
    private Set<Locatable> previousIntervals = new LinkedHashSet<Locatable>();

    @Override
    public void traverse() {
        CountingReadFilter countedFilter = this.makeReadFilter();
        Iterator<AlignmentContext> iterator = this.getAlignmentContextIterator(countedFilter);
        this.intervalsToTrack = OverlapDetector.create(this.getIntervalObjectsToQueryOver());
        iterator.forEachRemaining(alignmentContext -> {
            SimpleInterval alignmentInterval = new SimpleInterval((Locatable)alignmentContext);
            this.apply((AlignmentContext)alignmentContext, new ReferenceContext(this.reference, alignmentInterval), new FeatureContext(this.features, alignmentInterval));
            this.progressMeter.update(alignmentInterval);
        });
        for (Locatable l : this.previousIntervals) {
            this.onIntervalEnd(l);
        }
        this.logger.info(countedFilter.getSummaryLine());
    }

    @Override
    public final boolean requiresIntervals() {
        return true;
    }

    public abstract List<Locatable> getIntervalObjectsToQueryOver();

    @Override
    public final void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        Set currentIntervals = this.intervalsToTrack.getOverlaps((Locatable)alignmentContext);
        SetUtils.SetView passedIntervals = SetUtils.difference(this.previousIntervals, (Set)currentIntervals);
        SetUtils.SetView newIntervals = SetUtils.difference((Set)currentIntervals, this.previousIntervals);
        this.previousIntervals = currentIntervals;
        for (Locatable l : passedIntervals) {
            this.onIntervalEnd(l);
        }
        for (Locatable l : newIntervals) {
            this.onIntervalStart(l);
        }
        this.apply(alignmentContext, referenceContext, featureContext, currentIntervals);
    }

    public abstract void apply(AlignmentContext var1, ReferenceContext var2, FeatureContext var3, Set<Locatable> var4);

    public abstract void onIntervalStart(Locatable var1);

    public abstract void onIntervalEnd(Locatable var1);
}

